/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.gui.element;

import cofh.lib.gui.GuiBase;
import cofh.lib.gui.GuiColor;
import cofh.lib.gui.element.ElementBase;
import cofh.lib.gui.element.ElementButtonManaged;
import org.lwjgl.opengl.GL11;

public abstract class ElementSlider
extends ElementBase {
    protected int _value;
    protected int _valueMax;
    protected int _sliderWidth;
    protected int _sliderHeight;
    protected boolean _isDragging;
    public int borderColor = new GuiColor(120, 120, 120, 255).getColor();
    public int backgroundColor = new GuiColor(0, 0, 0, 255).getColor();

    protected ElementSlider(GuiBase guiBase, int n, int n2, int n3, int n4, int n5) {
        super(guiBase, n, n2, n3, n4);
        this._valueMax = n5;
    }

    public ElementSlider setColor(int n, int n2) {
        this.borderColor = n2;
        this.backgroundColor = n;
        return this;
    }

    public ElementSlider setSliderSize(int n, int n2) {
        this._sliderWidth = n;
        this._sliderHeight = n2;
        return this;
    }

    public void setValue(int n) {
        if (n != this._value && n >= 0 && n <= this._valueMax) {
            this._value = n;
            this.onValueChanged(this._value);
        }
    }

    @Override
    public void drawBackground(int n, int n2, float f) {
        this.drawModalRect(this.posX - 1, this.posY - 1, this.posX + this.sizeX + 1, this.posY + this.sizeY + 1, this.borderColor);
        this.drawModalRect(this.posX, this.posY, this.posX + this.sizeX, this.posY + this.sizeY, this.backgroundColor);
    }

    @Override
    public void drawForeground(int n, int n2) {
        int n3 = this._sliderWidth;
        int n4 = this._sliderHeight;
        int n5 = this.posX + this.getSliderX();
        int n6 = this.posY + this.getSliderY();
        if (!this.isEnabled()) {
            this.gui.bindTexture(ElementButtonManaged.DISABLED);
        } else if (this.isHovering(n, n2)) {
            this.gui.bindTexture(ElementButtonManaged.HOVER);
        } else {
            this.gui.bindTexture(ElementButtonManaged.ENABLED);
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.drawTexturedModalRect(n5, n6, 0, 0, n3 / 2, n4 / 2);
        this.drawTexturedModalRect(n5, n6 + n4 / 2, 0, 256 - n4 / 2, n3 / 2, n4 / 2);
        this.drawTexturedModalRect(n5 + n3 / 2, n6, 256 - n3 / 2, 0, n3 / 2, n4 / 2);
        this.drawTexturedModalRect(n5 + n3 / 2, n6 + n4 / 2, 256 - n3 / 2, 256 - n4 / 2, n3 / 2, n4 / 2);
    }

    protected boolean isHovering(int n, int n2) {
        return this.intersectsWith(n, n2);
    }

    public int getSliderX() {
        return 0;
    }

    public int getSliderY() {
        return 0;
    }

    @Override
    public boolean onMousePressed(int n, int n2, int n3) {
        this._isDragging = n3 == 0;
        return true;
    }

    @Override
    public void onMouseReleased(int n, int n2) {
        this._isDragging = false;
    }

    @Override
    public void update(int n, int n2) {
        if (this._isDragging) {
            this.dragSlider(n - this.posX, n2 - this.posY);
        }
    }

    protected abstract void dragSlider(int var1, int var2);

    @Override
    public boolean onMouseWheel(int n, int n2, int n3) {
        if (n3 > 0) {
            this.setValue(this._value - 1);
        } else if (n3 < 0) {
            this.setValue(this._value + 1);
        }
        return true;
    }

    public abstract void onValueChanged(int var1);
}

