/*
 * Decompiled with CFR 0.152.
 */
package jds.bibliocraft.rendering;

import jds.bibliocraft.CommonProxy;
import jds.bibliocraft.Config;
import jds.bibliocraft.models.ModelToolRack;
import jds.bibliocraft.models.OBJToolRack;
import jds.bibliocraft.tileentities.TileEntityWeaponRack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class TileEntityWeaponRackRenderer
extends TileEntitySpecialRenderer {
    private ModelToolRack rackModel = new ModelToolRack();
    private OBJToolRack objModel = new OBJToolRack();
    private int rackAngle;
    private int degreeAngle;
    private float ichange1;
    private float ichange2;
    private float ichange3;
    private float ichange4;
    private float kchange1;
    private float kchange2;
    private float kchange3;
    private float kchange4;
    private float optifineAdjust = 0.0f;
    private static boolean useTextureSheet;
    private boolean gregcheck = false;
    private RenderItem itemRenderer;
    private RenderManager renderManager = RenderManager.field_78727_a;
    private float yawValue;

    public void func_147500_a(TileEntity tileEntity, double i, double j, double k, float tick) {
        this.rackAngle = ((TileEntityWeaponRack)tileEntity).getAngle();
        useTextureSheet = this.usesTextureSheet();
        this.yawValue = !Minecraft.func_71375_t() ? this.renderManager.field_78734_h.field_70177_z : 0.0f;
        this.itemRenderer = new RenderItem(){

            public byte getMiniBlockCount(ItemStack stack, byte original) {
                return 1;
            }

            public byte getMiniItemCount(ItemStack stack, byte original) {
                return 1;
            }

            public boolean shouldBob() {
                return false;
            }

            public boolean shouldSpreadItems() {
                return false;
            }
        };
        this.itemRenderer.func_76976_a(this.renderManager);
        switch (this.rackAngle) {
            case 0: {
                this.degreeAngle = 270;
                this.ichange1 = 0.6f;
                this.ichange2 = 0.6f;
                this.ichange3 = 0.58f;
                this.ichange4 = 0.58f;
                this.kchange1 = 0.3f;
                this.kchange2 = 0.7f;
                this.kchange3 = 0.3f;
                this.kchange4 = 0.7f;
                break;
            }
            case 1: {
                this.degreeAngle = 180;
                this.ichange1 = 0.7f;
                this.ichange2 = 0.3f;
                this.ichange3 = 0.7f;
                this.ichange4 = 0.3f;
                this.kchange1 = 0.6f;
                this.kchange2 = 0.6f;
                this.kchange3 = 0.58f;
                this.kchange4 = 0.58f;
                break;
            }
            case 2: {
                this.degreeAngle = 90;
                this.ichange1 = 0.4f;
                this.ichange2 = 0.4f;
                this.ichange3 = 0.42f;
                this.ichange4 = 0.42f;
                this.kchange1 = 0.7f;
                this.kchange2 = 0.3f;
                this.kchange3 = 0.7f;
                this.kchange4 = 0.3f;
                break;
            }
            case 3: {
                this.degreeAngle = 0;
                this.ichange1 = 0.3f;
                this.ichange2 = 0.7f;
                this.ichange3 = 0.3f;
                this.ichange4 = 0.7f;
                this.kchange1 = 0.4f;
                this.kchange2 = 0.4f;
                this.kchange3 = 0.42f;
                this.kchange4 = 0.42f;
                break;
            }
        }
        GL11.glPushMatrix();
        GL11.glTranslated((double)(i + 0.5), (double)(j + 1.5), (double)(k + 0.5));
        GL11.glRotatef((float)(this.degreeAngle + 180), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        int texNum = tileEntity.func_145832_p();
        if (Config.optifineInstalled) {
            this.optifineAdjust = -0.08f;
        }
        TileEntityWeaponRack rackTile = (TileEntityWeaponRack)tileEntity;
        ItemStack slot1 = rackTile.getTool(0);
        ItemStack slot2 = rackTile.getTool(1);
        ItemStack slot3 = rackTile.getTool(2);
        ItemStack slot4 = rackTile.getTool(3);
        float scale = 0.0625f;
        if (useTextureSheet) {
            this.func_147499_a(this.getModelTexture(texNum));
            this.rackModel.renderRack();
        } else {
            this.func_147499_a(this.getModelTexture(texNum));
            this.rackModel.renderPegs();
            this.func_147499_a(this.getVanillaWoodTexture(texNum));
            GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            this.objModel.render();
            GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        }
        GL11.glEnable((int)2896);
        int weaponnum = rackTile.getShowWText();
        if (weaponnum > 0 && weaponnum < 5) {
            ItemStack wt = rackTile.getTool(weaponnum - 1);
            if (wt != null) {
                String weaText = wt.func_82833_r();
                this.renderText(weaText, 0.0, 0.0, 0.0);
            }
            rackTile.setShowWText(0);
        }
        GL11.glPopMatrix();
        boolean fancyGraphics = Minecraft.func_71375_t();
        this.renderRackSlot(slot1, i + (double)this.ichange1, j + (double)0.56f + (double)this.optifineAdjust, k + (double)this.kchange1, fancyGraphics);
        this.renderRackSlot(slot2, i + (double)this.ichange2, j + (double)0.56f + (double)this.optifineAdjust, k + (double)this.kchange2, fancyGraphics);
        this.renderRackSlot(slot3, i + (double)this.ichange3, j + (double)0.19f + (double)this.optifineAdjust, k + (double)this.kchange3, fancyGraphics);
        this.renderRackSlot(slot4, i + (double)this.ichange4, j + (double)0.19f + (double)this.optifineAdjust, k + (double)this.kchange4, fancyGraphics);
    }

    private void renderRackSlot(ItemStack stack, double xAdjust, double yAdjust, double zAdjust, boolean fancyGraphics) {
        if (stack != null) {
            this.gregcheck = stack.func_77977_a().toLowerCase().contains("metagenerated_tool") || stack.func_77977_a().toLowerCase().contains("gt.metatool");
            EntityItem slot1Entity = new EntityItem(null, 0.0, 0.0, 0.0, stack);
            slot1Entity.field_70290_d = 0.0f;
            GL11.glPushMatrix();
            GL11.glTranslated((double)xAdjust, (double)yAdjust, (double)zAdjust);
            if (stack.func_77973_b().func_77658_a().contains("BiblioMapTool")) {
                GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-0.05f);
                if (this.degreeAngle == 90 || this.degreeAngle == 270) {
                    GL11.glTranslatef((float)0.0f, (float)0.0f, (float)0.05f);
                }
            }
            if (fancyGraphics || this.gregcheck) {
                GL11.glRotatef((float)(this.degreeAngle + 180), (float)0.0f, (float)1.0f, (float)0.0f);
            } else if (!stack.func_77973_b().func_77658_a().contains("BiblioMapTool")) {
                GL11.glRotatef((float)(this.yawValue + (float)this.degreeAngle + 180.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            } else {
                GL11.glRotatef((float)(this.degreeAngle + 180), (float)0.0f, (float)1.0f, (float)0.0f);
            }
            this.itemRenderer.func_76986_a(slot1Entity, 0.0, 0.0, 0.0, 0.0f, 0.0f);
            GL11.glPopMatrix();
        }
    }

    public void renderText(String text, double xadjust, double yadjust, double zadjust) {
        FontRenderer fontRender = this.func_147498_b();
        GL11.glDepthMask((boolean)false);
        GL11.glScalef((float)0.005f, (float)0.005f, (float)0.005f);
        GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslated((double)(0.0 + xadjust), (double)(100.0 + yadjust), (double)(-1.0 + zadjust));
        int adjust = fontRender.func_78256_a(text) / 2;
        fontRender.func_85187_a(text, -adjust, 0, Config.color, Config.textshadow);
        GL11.glDepthMask((boolean)true);
    }

    public ResourceLocation getModelTexture(int metadata) {
        switch (metadata) {
            case 0: {
                return CommonProxy.TOOLRACK0_PNG;
            }
            case 1: {
                return CommonProxy.TOOLRACK1_PNG;
            }
            case 2: {
                return CommonProxy.TOOLRACK2_PNG;
            }
            case 3: {
                return CommonProxy.TOOLRACK3_PNG;
            }
            case 4: {
                return CommonProxy.TOOLRACK4_PNG;
            }
            case 5: {
                return CommonProxy.TOOLRACK5_PNG;
            }
        }
        return CommonProxy.TOOLRACK0_PNG;
    }

    public ResourceLocation getVanillaWoodTexture(int meta) {
        switch (meta) {
            case 0: {
                return CommonProxy.PLANKSOAK;
            }
            case 1: {
                return CommonProxy.PLANKSSPRUCE;
            }
            case 2: {
                return CommonProxy.PLANKSBIRCH;
            }
            case 3: {
                return CommonProxy.PLANKSJUNGLE;
            }
            case 4: {
                return CommonProxy.PLANKSACACIA;
            }
            case 5: {
                return CommonProxy.PLANKSOLDOAK;
            }
        }
        return CommonProxy.PLANKSOAK;
    }

    public boolean usesTextureSheet() {
        return Config.useTextureSheet;
    }
}

