/*
 * Decompiled with CFR 0.152.
 */
package jds.bibliocraft.network;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import jds.bibliocraft.BiblioCraft;
import jds.bibliocraft.FileUtil;
import jds.bibliocraft.blocks.BlockLoader;
import jds.bibliocraft.items.ItemAtlas;
import jds.bibliocraft.tileentities.TileEntityClock;
import jds.bibliocraft.tileentities.TileEntityFancySign;
import jds.bibliocraft.tileentities.TileEntityFancyWorkbench;
import jds.bibliocraft.tileentities.TileEntityMapFrame;
import jds.bibliocraft.tileentities.TileEntityMarkerPole;
import jds.bibliocraft.tileentities.TileEntityPaintPress;
import jds.bibliocraft.tileentities.TileEntityPainting;
import jds.bibliocraft.tileentities.TileEntityTypeMachine;
import jds.bibliocraft.tileentities.TileEntityWritingDesk;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.ItemMap;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class ServerPacketHandler {
    @SubscribeEvent
    public void onServerPacket(FMLNetworkEvent.ServerCustomPacketEvent event) {
        EntityPlayerMP player = ((NetHandlerPlayServer)event.handler).field_147369_b;
        FMLProxyPacket packet = event.packet;
        if (packet != null) {
            if (packet.channel().equals("BiblioType")) {
                this.handleBookNameUpdate(packet.payload(), player);
            }
            if (packet.channel().equals("BiblioTypeFlag")) {
                this.handleBookFlagUpdate(packet.payload());
            }
            if (packet.channel().equals("BiblioTypeDelete")) {
                this.handleBookDeletion(packet.payload());
            }
            if (packet.channel().equals("BiblioTypeUpdate")) {
                this.handleTypsetUpdate(packet.payload(), player.field_70170_p);
            }
            if (packet.channel().equals("BiblioMCBEdit")) {
                this.handleBookEdit(packet.payload(), player);
            }
            if (packet.channel().equals("BiblioMCBPage")) {
                this.handleBookPageUpdate(packet.payload(), player);
            }
            if (packet.channel().equals("BiblioClipboard")) {
                this.handleInventoryStackUpdate(packet.payload(), player);
            }
            if (packet.channel().equals("BiblioMeasure")) {
                this.handleMarkerPoles(packet.payload(), player);
            }
            if (packet.channel().equals("BiblioMapPin")) {
                this.handleMapWaypoints(packet.payload(), player);
            }
            if (packet.channel().equals("BiblioRBook")) {
                this.handleRecipeBook(packet.payload(), player.field_70170_p);
            }
            if (packet.channel().equals("BiblioRBookLoad")) {
                this.handleRecipeLoad(packet.payload(), player.field_70170_p);
            }
            if (packet.channel().equals("BiblioSign")) {
                this.handleFancySignUpdate(packet.payload(), player.field_70170_p);
            }
            if (packet.channel().equals("BiblioClock")) {
                this.handleClockUpdate(packet.payload(), player.field_70170_p);
            }
            if (packet.channel().equals("BiblioPaintPress")) {
                this.handlePaintPressUpdate(packet.payload(), player.field_70170_p);
            }
            if (packet.channel().equals("BiblioPainting")) {
                this.handlePaintingUpdate(packet.payload(), player.field_70170_p);
            }
            if (packet.channel().equals("BiblioPaintingC")) {
                this.handlePaintingCustomAspectsUpdate(packet.payload(), player.field_70170_p);
            }
            if (packet.channel().equals("BiblioAtlas")) {
                this.handleAtlasUpdate(packet.payload(), player);
            }
            if (packet.channel().equals("BiblioAtlasSWP")) {
                this.handleAtlasSwapUpdate(packet.payload(), player);
            }
            if (packet.channel().equals("BiblioAtlasWPT")) {
                this.handleAtlasTransferUpdate(packet.payload(), player);
            }
        }
    }

    private void handlePaintingCustomAspectsUpdate(ByteBuf packet, World world) {
        int x = packet.readInt();
        int y = packet.readInt();
        int z = packet.readInt();
        int aspectX = packet.readInt();
        int aspectY = packet.readInt();
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile != null && tile instanceof TileEntityPainting) {
            TileEntityPainting painting = (TileEntityPainting)tile;
            painting.setPacketAspectsUpdate(aspectX, aspectY);
        }
    }

    private void handleAtlasTransferUpdate(ByteBuf packet, EntityPlayerMP player) {
        boolean toMapFrame = packet.readBoolean();
        int x = packet.readInt();
        int y = packet.readInt();
        int z = packet.readInt();
        ItemStack atlasStack = ByteBufUtils.readItemStack((ByteBuf)packet);
        TileEntity tile = player.field_70170_p.func_147438_o(x, y, z);
        if (tile != null && tile instanceof TileEntityMapFrame && atlasStack != null) {
            TileEntityMapFrame frameTile = (TileEntityMapFrame)tile;
            if (toMapFrame) {
                this.transferWaypointsToMapFrame(frameTile, atlasStack);
                player.field_70170_p.func_147471_g(frameTile.field_145851_c, frameTile.field_145848_d, frameTile.field_145849_e);
            } else {
                this.transferWaypointsToAtlas(frameTile, atlasStack, player);
            }
        }
    }

    private void transferWaypointsToAtlas(TileEntityMapFrame frameTile, ItemStack atlasStack, EntityPlayerMP player) {
        InventoryBasic inv = this.getInventory(atlasStack);
        ItemStack newMap = frameTile.func_70301_a(0);
        NBTTagCompound tags = atlasStack.func_77978_p();
        if (inv != null && tags != null) {
            String newMapName = "Map_" + newMap.func_77960_j();
            boolean foundMapData = false;
            NBTTagList atlasMapsDatas = new NBTTagList();
            int hasCurrentMapDatas = -1;
            if (tags.func_74764_b("maps")) {
                atlasMapsDatas = tags.func_150295_c("maps", 10);
                for (int i = 0; i < atlasMapsDatas.func_74745_c(); ++i) {
                    String oldMap;
                    NBTTagCompound testTag = atlasMapsDatas.func_150305_b(i);
                    if (testTag == null || !testTag.func_74764_b("mapName") || !(oldMap = testTag.func_74779_i("mapName")).contentEquals(newMapName)) continue;
                    atlasMapsDatas.func_74744_a(i);
                    foundMapData = true;
                }
            }
            atlasMapsDatas.func_74742_a((NBTBase)this.getNewMapDataCompound(frameTile, newMapName));
            tags.func_74782_a("maps", (NBTBase)atlasMapsDatas);
            atlasStack.func_77982_d(tags);
            player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, atlasStack);
        }
    }

    private void transferWaypointsToMapFrame(TileEntityMapFrame frameTile, ItemStack atlasStack) {
        InventoryBasic inv = this.getInventory(atlasStack);
        NBTTagCompound atlasTags = atlasStack.func_77978_p();
        ItemStack mapStack = this.getCurrentMapStack(atlasStack);
        if (atlasTags != null && inv != null && mapStack != null && atlasTags.func_74764_b("maps")) {
            NBTTagList maps = atlasTags.func_150295_c("maps", 10);
            NBTTagCompound mapTag = null;
            String mapName = "Map_" + mapStack.func_77960_j();
            for (int n = 0; n < maps.func_74745_c(); ++n) {
                mapTag = maps.func_150305_b(n);
                if (mapTag == null || !mapTag.func_74764_b("mapName") || !mapTag.func_74779_i("mapName").contentEquals(mapName)) continue;
                frameTile.addMapPinDataFromAtlas(mapTag);
                for (int i = 0; i < frameTile.getRotation(); ++i) {
                    frameTile.rotateWaypoints();
                }
            }
        }
    }

    private NBTTagCompound getNewMapDataCompound(TileEntityMapFrame tile, String newMapName) {
        int mapRotation = tile.getRotation();
        NBTTagCompound newMapData = new NBTTagCompound();
        newMapData.func_74778_a("mapName", newMapName);
        newMapData.func_74768_a("xCenter", tile.mapXCenter);
        newMapData.func_74768_a("zCenter", tile.mapZCenter);
        newMapData.func_74768_a("mapScale", tile.mapScale);
        int angle = tile.getAngle();
        int vertAngle = tile.getVertAngle();
        int rotations = 0;
        switch (mapRotation) {
            case 1: {
                rotations = 3;
                break;
            }
            case 2: {
                rotations = 2;
                break;
            }
            case 3: {
                rotations = 1;
            }
        }
        ArrayList xPins = new ArrayList();
        xPins = (ArrayList)tile.xPin.clone();
        ArrayList yPins = new ArrayList();
        yPins = (ArrayList)tile.yPin.clone();
        for (int i = 0; i < rotations; ++i) {
            int n;
            ArrayList xCurrent = xPins;
            ArrayList yCurrent = yPins;
            if ((angle == 0 || angle == 3) && vertAngle == 1 || vertAngle == 2) {
                xPins = yCurrent;
                yCurrent = yPins = xCurrent;
                for (n = 0; n < xCurrent.size(); ++n) {
                    yPins.set(n, Float.valueOf(1.0f - ((Float)yCurrent.get(n)).floatValue()));
                }
                continue;
            }
            xPins = yCurrent;
            yPins = xCurrent;
            xCurrent = xPins;
            for (n = 0; n < xCurrent.size(); ++n) {
                xPins.set(n, Float.valueOf(1.0f - ((Float)xCurrent.get(n)).floatValue()));
            }
        }
        NBTTagList mapXPins = new NBTTagList();
        for (int i = 0; i < xPins.size(); ++i) {
            float xpin = ((Float)xPins.get(i)).floatValue();
            if (tile.vertAngle == 1 && (tile.angle == 1 || tile.angle == 2)) {
                xpin = 1.0f - xpin;
            }
            mapXPins.func_74742_a((NBTBase)new NBTTagFloat(xpin));
        }
        newMapData.func_74782_a("xMapWaypoints", (NBTBase)mapXPins);
        NBTTagList mapYPins = new NBTTagList();
        for (int i = 0; i < yPins.size(); ++i) {
            float ypin = ((Float)yPins.get(i)).floatValue();
            if (tile.vertAngle == 2 || tile.vertAngle == 1) {
                ypin = 1.0f - ypin;
            }
            mapYPins.func_74742_a((NBTBase)new NBTTagFloat(ypin));
        }
        newMapData.func_74782_a("yMapWaypoints", (NBTBase)mapYPins);
        NBTTagList mapPinNames = new NBTTagList();
        for (int i = 0; i < tile.pinStrings.size(); ++i) {
            mapPinNames.func_74742_a((NBTBase)new NBTTagString((String)tile.pinStrings.get(i)));
        }
        newMapData.func_74782_a("MapWaypointNames", (NBTBase)mapPinNames);
        NBTTagList mapPinColors = new NBTTagList();
        for (int i = 0; i < tile.pinColors.size(); ++i) {
            mapPinColors.func_74742_a((NBTBase)new NBTTagFloat(((Float)tile.pinColors.get(i)).floatValue()));
        }
        newMapData.func_74782_a("MapWaypointColors", (NBTBase)mapPinColors);
        return newMapData;
    }

    private InventoryBasic getInventory(ItemStack stack) {
        NBTTagCompound tags = stack.func_77978_p();
        if (tags != null) {
            InventoryBasic atlasInventory = new InventoryBasic("AtlasInventory", true, 48);
            NBTTagList tagList = tags.func_150295_c("Inventory", 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                NBTTagCompound tag = tagList.func_150305_b(i);
                byte slot = tag.func_74771_c("Slot");
                if (slot < 0 || slot >= atlasInventory.func_70302_i_()) continue;
                ItemStack invStack = ItemStack.func_77949_a((NBTTagCompound)tag);
                atlasInventory.func_70299_a((int)slot, invStack);
            }
            return atlasInventory;
        }
        return null;
    }

    private ItemStack getCurrentMapStack(ItemStack stack) {
        ItemStack mapStack;
        int mapSlot;
        InventoryBasic inv = this.getInventory(stack);
        NBTTagCompound atlasTags = stack.func_77978_p();
        if (atlasTags != null && (mapSlot = atlasTags.func_74762_e("mapSlot")) != -1 && (mapStack = inv.func_70301_a(mapSlot)) != null && mapStack.func_77973_b() == Items.field_151098_aY) {
            return mapStack;
        }
        return null;
    }

    private void handleAtlasSwapUpdate(ByteBuf packet, EntityPlayerMP player) {
        this.handleInventoryStackUpdate(packet, player);
        player.func_71053_j();
        player.openGui((Object)BiblioCraft.instance, 100, player.field_70170_p, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
    }

    private void handleAtlasUpdate(ByteBuf packet, EntityPlayerMP player) {
        boolean autoCenter = packet.readBoolean();
        boolean autoCreate = packet.readBoolean();
        int zoomLevel = packet.readInt();
        int slot = packet.readInt();
        boolean changeGUI = packet.readBoolean();
        ItemStack atlas = player.func_70694_bm();
        if (atlas != null && atlas.func_77973_b() instanceof ItemAtlas) {
            NBTTagCompound tags = atlas.func_77978_p();
            if (tags != null) {
                int oldSlot = tags.func_74762_e("mapSlot");
                tags.func_74757_a("autoCenter", autoCenter);
                tags.func_74757_a("autoCreate", autoCreate);
                tags.func_74768_a("zoomLevel", zoomLevel);
                tags.func_74768_a("mapSlot", slot);
                tags.func_74768_a("lastGUImode", 0);
                if (changeGUI) {
                    // empty if block
                }
                atlas.func_77982_d(tags);
                atlas.func_77964_b(this.setAtlasDamage(atlas, slot));
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, atlas);
            }
            if (changeGUI) {
                ItemAtlas realAtlas = (ItemAtlas)atlas.func_77973_b();
                realAtlas.getAtlasInventory(atlas, player.field_70170_p, (EntityPlayer)player, autoCreate, autoCenter, zoomLevel, slot);
                player.func_71053_j();
                player.field_70125_A = 50.0f;
                ByteBuf buffer = Unpooled.buffer();
                ByteBufUtils.writeItemStack((ByteBuf)buffer, (ItemStack)player.func_70694_bm());
                BiblioCraft.ch_BiblioAtlasGUIswap.sendTo(new FMLProxyPacket(buffer, "BiblioAtlasSWP"), player);
            }
        }
    }

    private int setAtlasDamage(ItemStack atlas, int newslot) {
        NBTTagCompound tags = atlas.func_77978_p();
        InventoryBasic atlasInventory = new InventoryBasic("AtlasInventory", false, 48);
        NBTTagList tagList = tags.func_150295_c("Inventory", 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tag = tagList.func_150305_b(i);
            byte slot = tag.func_74771_c("Slot");
            if (slot < 0 || slot >= atlasInventory.func_70302_i_()) continue;
            ItemStack invStack = ItemStack.func_77949_a((NBTTagCompound)tag);
            atlasInventory.func_70299_a((int)slot, invStack);
        }
        ItemStack newmap = atlasInventory.func_70301_a(newslot);
        if (newmap != null && newmap.func_77973_b() instanceof ItemMap) {
            return newmap.func_77960_j();
        }
        return 0;
    }

    private void handlePaintingUpdate(ByteBuf packet, World world) {
        int x = packet.readInt();
        int y = packet.readInt();
        int z = packet.readInt();
        int corner = packet.readInt();
        int scale = packet.readInt();
        int res = packet.readInt();
        int aspect = packet.readInt();
        int rotation = packet.readInt();
        int customAspectX = packet.readInt();
        int customAspectY = packet.readInt();
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile != null && tile instanceof TileEntityPainting) {
            TileEntityPainting painting = (TileEntityPainting)tile;
            painting.setPacketUpdate(corner, scale, res, aspect, rotation, customAspectX, customAspectY);
        }
    }

    private void handlePaintPressUpdate(ByteBuf packet, World world) {
        int x = packet.readInt();
        int y = packet.readInt();
        int z = packet.readInt();
        int artType = packet.readInt();
        String artName = ByteBufUtils.readUTF8String((ByteBuf)packet);
        boolean applyToCanvas = packet.readBoolean();
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile != null && tile instanceof TileEntityPaintPress) {
            TileEntityPaintPress press = (TileEntityPaintPress)tile;
            press.setSelectedPainting(artType, artName);
            if (applyToCanvas) {
                press.setCycle(true);
            }
        }
    }

    private void handleClockUpdate(ByteBuf packet, World world) {
        NBTTagCompound tags = ByteBufUtils.readTag((ByteBuf)packet);
        if (tags != null) {
            int k;
            int j;
            int[] chimes = tags.func_74759_k("chimes");
            int[] redstone = tags.func_74759_k("redstone");
            boolean tick = packet.readBoolean();
            boolean chime = packet.readBoolean();
            boolean rsout = packet.readBoolean();
            int i = packet.readInt();
            TileEntity tile = world.func_147438_o(i, j = packet.readInt(), k = packet.readInt());
            if (tile != null && tile instanceof TileEntityClock) {
                TileEntityClock clock = (TileEntityClock)tile;
                clock.setSettingFromGui(chimes, redstone, tick, chime, rsout);
            }
        }
    }

    private void handleFancySignUpdate(ByteBuf packet, World world) {
        int z;
        int y;
        String[] text = new String[15];
        int[] textScales = new int[15];
        for (int n = 0; n < 15; ++n) {
            text[n] = ByteBufUtils.readUTF8String((ByteBuf)packet);
            textScales[n] = packet.readInt();
        }
        int numOfLines = packet.readInt();
        int s1Scale = packet.readInt();
        int s1Rot = packet.readInt();
        int s2Scale = packet.readInt();
        int s2Rot = packet.readInt();
        int s1x = packet.readInt();
        int s1y = packet.readInt();
        int s2x = packet.readInt();
        int s2y = packet.readInt();
        int x = packet.readInt();
        TileEntity tile = world.func_147438_o(x, y = packet.readInt(), z = packet.readInt());
        if (tile != null && tile instanceof TileEntityFancySign) {
            TileEntityFancySign sign = (TileEntityFancySign)tile;
            sign.updateFromPacket(text, textScales, numOfLines, s1Scale, s1Rot, s1x, s1y, s2Scale, s2Rot, s2x, s2y);
        }
    }

    private void handleRecipeLoad(ByteBuf packet, World world) {
        int x = packet.readInt();
        int y = packet.readInt();
        int z = packet.readInt();
        int id = packet.readInt();
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile != null && tile instanceof TileEntityFancyWorkbench) {
            TileEntityFancyWorkbench bench = (TileEntityFancyWorkbench)tile;
            bench.loadInvToGridForRecipe(id);
        }
    }

    private void handleRecipeBook(ByteBuf packet, World world) {
        int x = packet.readInt();
        int y = packet.readInt();
        int z = packet.readInt();
        int id = packet.readInt();
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile != null && tile instanceof TileEntityFancyWorkbench) {
            TileEntityFancyWorkbench bench = (TileEntityFancyWorkbench)tile;
            bench.setBookGrid(id);
        }
    }

    private void handleTypsetUpdate(ByteBuf packet, World world) {
        int z;
        int y;
        int x = packet.readInt();
        TileEntity tile = world.func_147438_o(x, y = packet.readInt(), z = packet.readInt());
        if (tile != null && tile instanceof TileEntityTypeMachine) {
            TileEntityTypeMachine typeTile = (TileEntityTypeMachine)tile;
            typeTile.booklistset();
        }
    }

    private void handleBookNameUpdate(ByteBuf packet, EntityPlayerMP player) {
        String bookname = ByteBufUtils.readUTF8String((ByteBuf)packet);
        int x = packet.readInt();
        int y = packet.readInt();
        int z = packet.readInt();
        this.updateTypeMachine(x, y, z, bookname, player);
    }

    private void updateTypeMachine(int x, int y, int z, String book, EntityPlayerMP player) {
        World world = player.field_70170_p;
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile != null) {
            TileEntityTypeMachine typetile = (TileEntityTypeMachine)tile;
            typetile.setBookname(book);
        }
    }

    private void handleBookFlagUpdate(ByteBuf packet) {
        String bookname = ByteBufUtils.readUTF8String((ByteBuf)packet);
        boolean newFlag = packet.readBoolean();
        FileUtil util = new FileUtil();
        boolean isServer = packet.readBoolean();
        if (util.updatePublicFlag(!isServer, bookname, newFlag)) {
            String fl = "private";
            if (newFlag) {
                fl = "public";
            }
        } else {
            FMLLog.warning((String)("Updating book flag for " + bookname + " failed"), (Object[])new Object[0]);
        }
    }

    private void handleBookDeletion(ByteBuf packet) {
        String bookname = ByteBufUtils.readUTF8String((ByteBuf)packet);
        FileUtil util = new FileUtil();
        boolean isServer = packet.readBoolean();
        if (util.deleteBook(!isServer, bookname)) {
            FMLLog.info((String)(bookname + " has been deleted Forever!"), (Object[])new Object[0]);
        } else {
            FMLLog.warning((String)("Deletion of " + bookname + " failed"), (Object[])new Object[0]);
        }
    }

    private void handleBookEdit(ByteBuf packet, EntityPlayerMP player) {
        TileEntityWritingDesk deskTile;
        ItemStack book = ByteBufUtils.readItemStack((ByteBuf)packet);
        int x = packet.readInt();
        int y = packet.readInt();
        int z = packet.readInt();
        int currentPage = packet.readInt();
        if (book != null && (deskTile = (TileEntityWritingDesk)player.field_70170_p.func_147438_o(x, y, z)) != null) {
            deskTile.overwriteWrittenBook(book);
            deskTile.setCurrentPage(currentPage);
        }
    }

    private void handleBookPageUpdate(ByteBuf packet, EntityPlayerMP player) {
        int x = packet.readInt();
        int y = packet.readInt();
        int z = packet.readInt();
        int currentPage = packet.readInt();
        TileEntityWritingDesk deskTile = (TileEntityWritingDesk)player.field_70170_p.func_147438_o(x, y, z);
        if (deskTile != null) {
            deskTile.setCurrentPage(currentPage);
        }
    }

    private void handleInventoryStackUpdate(ByteBuf packet, EntityPlayerMP player) {
        ItemStack stackostuff = ByteBufUtils.readItemStack((ByteBuf)packet);
        if (stackostuff != null) {
            player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, stackostuff);
        }
    }

    private void handleMarkerPoles(ByteBuf packet, EntityPlayerMP player) {
        int i = packet.readInt();
        int j = packet.readInt();
        int k = packet.readInt();
        boolean newTest = packet.readBoolean();
        int direction = packet.readInt();
        World world = player.field_70170_p;
        int iadj = 0;
        int jadj = 0;
        int kadj = 0;
        switch (direction) {
            case 0: {
                jadj = -1;
                break;
            }
            case 1: {
                jadj = 1;
                break;
            }
            case 2: {
                kadj = -1;
                break;
            }
            case 3: {
                kadj = 1;
                break;
            }
            case 4: {
                iadj = -1;
                break;
            }
            case 5: {
                iadj = 1;
                break;
            }
            default: {
                iadj = 1;
            }
        }
        if (newTest) {
            if (world.func_147437_c(i + iadj, j + jadj, k + kadj)) {
                world.func_147465_d(i + iadj, j + jadj, k + kadj, BlockLoader.stuffBlock, 1, 2);
                TileEntityMarkerPole poleTile = (TileEntityMarkerPole)world.func_147438_o(i + iadj, j + jadj, k + kadj);
                if (poleTile != null) {
                    poleTile.setDirection(direction);
                }
            }
        } else if (world.func_147439_a(i + iadj, j + jadj, k + kadj) == BlockLoader.stuffBlock && world.func_72805_g(i + iadj, j + jadj, k + kadj) == 1) {
            world.func_147480_a(i + iadj, j + jadj, k + kadj, false);
        }
    }

    private void handleMapWaypoints(ByteBuf packet, EntityPlayerMP player) {
        World world = player.field_70170_p;
        int i = packet.readInt();
        int j = packet.readInt();
        int k = packet.readInt();
        float xPin = packet.readFloat();
        float yPin = packet.readFloat();
        String name = ByteBufUtils.readUTF8String((ByteBuf)packet);
        int color = packet.readInt();
        int pinNum = packet.readInt();
        boolean remove = packet.readBoolean();
        boolean edit = packet.readBoolean();
        TileEntity tile = world.func_147438_o(i, j, k);
        if (tile != null && tile instanceof TileEntityMapFrame) {
            TileEntityMapFrame mapFrame = (TileEntityMapFrame)tile;
            if (!remove) {
                if (!edit) {
                    mapFrame.addPinCoords(xPin, yPin, name, color);
                } else {
                    mapFrame.editPinData(name, color, pinNum);
                }
            } else {
                mapFrame.removePin(pinNum);
            }
        }
    }
}

