/*
 * Decompiled with CFR 0.152.
 */
package jds.bibliocraft.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import jds.bibliocraft.ClientProxy;
import jds.bibliocraft.blocks.BlockLoader;
import jds.bibliocraft.entity.EntitySeat;
import jds.bibliocraft.items.ItemDrill;
import jds.bibliocraft.items.ItemSeatBack;
import jds.bibliocraft.items.ItemSeatBack2;
import jds.bibliocraft.items.ItemSeatBack3;
import jds.bibliocraft.items.ItemSeatBack4;
import jds.bibliocraft.items.ItemSeatBack5;
import jds.bibliocraft.tileentities.TileEntitySeat;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockSeat
extends Block {
    public BlockSeat() {
        super(Material.field_151575_d);
        this.func_149647_a(BlockLoader.biblioTab);
        this.func_149672_a(Block.field_149766_f);
    }

    public float func_149712_f(World world, int i, int j, int k) {
        return 3.0f;
    }

    public boolean func_149727_a(World world, int i, int j, int k, EntityPlayer player, int face, float hitX, float hitY, float hitZ) {
        ItemStack inhand;
        if (!world.field_72995_K) {
            TileEntitySeat seatTile = (TileEntitySeat)world.func_147438_o(i, j, k);
            if (player.func_70093_af()) {
                if (seatTile != null && seatTile.getHasSitter()) {
                    seatTile.dismountEntity();
                }
            } else if (seatTile != null) {
                ItemStack playerStack = player.func_70694_bm();
                if (playerStack != null) {
                    int returnStackSize;
                    Item playerItem;
                    if (playerStack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150404_cg)) {
                        if (face == 1 || face == 0) {
                            int returnStackSize2 = seatTile.addSeatCover(playerStack);
                            if (returnStackSize2 != -1) {
                                if (returnStackSize2 == 0) {
                                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
                                } else {
                                    playerStack.field_77994_a = returnStackSize2;
                                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, playerStack);
                                }
                                return true;
                            }
                        } else {
                            int returnStackSize3 = seatTile.setCarpet(playerStack);
                            if (returnStackSize3 != -1) {
                                if (returnStackSize3 == 0) {
                                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
                                } else {
                                    playerStack.field_77994_a = returnStackSize3;
                                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, playerStack);
                                }
                            }
                            return true;
                        }
                    }
                    if (((playerItem = playerStack.func_77973_b()) instanceof ItemSeatBack || playerItem instanceof ItemSeatBack2 || playerItem instanceof ItemSeatBack3 || playerItem instanceof ItemSeatBack4 || playerItem instanceof ItemSeatBack5) && (returnStackSize = seatTile.addSeatBack(playerStack)) != -1) {
                        if (returnStackSize == 0) {
                            player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
                        } else {
                            playerStack.field_77994_a = returnStackSize;
                            player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, playerStack);
                        }
                        return true;
                    }
                    if (playerStack.func_77973_b() instanceof ItemDrill) {
                        if (face == 1 && seatTile.func_70301_a(0) != null) {
                            this.dropSlot(world, i, j, k, 0);
                            seatTile.removeCover();
                            return false;
                        }
                        if (seatTile.hasBack > 0) {
                            this.dropSlot(world, i, j, k, 1);
                            seatTile.removeBack();
                            return false;
                        }
                        if (face != 1 && seatTile.isCarpetFull()) {
                            this.dropSlot(world, i, j, k, 2);
                            seatTile.setCarpet(null);
                            return false;
                        }
                    }
                }
                if (!seatTile.getHasSitter()) {
                    this.sitDown(player, world, i, j, k, seatTile);
                    seatTile.setSitter(true);
                }
            }
        }
        return !world.field_72995_K || (inhand = player.func_70694_bm()) == null || !(inhand.func_77973_b() instanceof ItemDrill);
    }

    public void sitDown(EntityPlayer player, World world, int i, int j, int k, TileEntitySeat tile) {
        EntitySeat seatEntity = new EntitySeat(world, i, (double)j + 1.0, k, tile);
        world.func_72838_d((Entity)seatEntity);
        player.func_70078_a((Entity)seatEntity);
    }

    public void func_149719_a(IBlockAccess blockAccess, int i, int j, int k) {
        TileEntity tileEntity = blockAccess.func_147438_o(i, j, k);
        if (tileEntity != null) {
            TileEntitySeat seatTile = (TileEntitySeat)tileEntity;
            this.func_149676_a(0.16f, 0.0f, 0.16f, 0.84f, 0.74f, 0.84f);
        }
    }

    public int func_149692_a(int metadata) {
        return metadata;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item par1, CreativeTabs tab, List subItems) {
        for (int x = 0; x <= 5; ++x) {
            subItems.add(new ItemStack((Block)this, 1, x));
        }
    }

    public void func_149743_a(World par1World, int par2, int par3, int par4, AxisAlignedBB par5AxisAlignedBB, List par6List, Entity par7Entity) {
        this.func_149719_a((IBlockAccess)par1World, par2, par3, par4);
        super.func_149743_a(par1World, par2, par3, par4, par5AxisAlignedBB, par6List, par7Entity);
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    public int func_149645_b() {
        return ClientProxy.seatRenderID;
    }

    public void func_149749_a(World world, int i, int j, int k, Block par5, int par6) {
        TileEntitySeat tileSeat = (TileEntitySeat)world.func_147438_o(i, j, k);
        if (tileSeat != null) {
            this.breakConnectsFix(world, i, j, k, tileSeat);
            TileEntitySeat seatTile = (TileEntitySeat)world.func_147438_o(i, j, k);
            seatTile.dismountEntity();
        }
        this.dropItems(world, i, j, k);
        world.func_147475_p(i, j, k);
        super.func_149749_a(world, i, j, k, par5, par6);
    }

    private void breakConnectsFix(World world, int i, int j, int k, TileEntitySeat tileSeat) {
        TileEntitySeat adjTile;
        TileEntity tile;
        boolean northConnect = tileSeat.getNorthConnect();
        boolean southConnect = tileSeat.getSouthConnect();
        boolean eastConnect = tileSeat.getEastConnect();
        boolean westConnect = tileSeat.getWestConnect();
        if (northConnect && (tile = world.func_147438_o(i, j, k - 1)) != null && tile instanceof TileEntitySeat) {
            adjTile = (TileEntitySeat)tile;
            adjTile.setSouthConnect(false);
        }
        if (southConnect && (tile = world.func_147438_o(i, j, k + 1)) != null && tile instanceof TileEntitySeat) {
            adjTile = (TileEntitySeat)tile;
            adjTile.setNorthConnect(false);
        }
        if (eastConnect && (tile = world.func_147438_o(i + 1, j, k)) != null && tile instanceof TileEntitySeat) {
            adjTile = (TileEntitySeat)tile;
            adjTile.setWestConnect(false);
        }
        if (westConnect && (tile = world.func_147438_o(i - 1, j, k)) != null && tile instanceof TileEntitySeat) {
            adjTile = (TileEntitySeat)tile;
            adjTile.setEastConnect(false);
        }
    }

    private void dropItems(World world, int i, int j, int k) {
        Random rando = new Random();
        TileEntity tileEntity = world.func_147438_o(i, j, k);
        if (!(tileEntity instanceof IInventory)) {
            return;
        }
        IInventory inventory = (IInventory)tileEntity;
        for (int x = 0; x < inventory.func_70302_i_(); ++x) {
            ItemStack item = inventory.func_70301_a(x);
            if (item == null || item.field_77994_a <= 0) continue;
            float ri = rando.nextFloat() * 0.8f + 0.1f;
            float rj = rando.nextFloat() * 0.8f + 0.1f;
            float rk = rando.nextFloat() * 0.8f + 0.1f;
            EntityItem entityItem = new EntityItem(world, (double)((float)i + ri), (double)((float)j + rj), (double)((float)k + rk), new ItemStack(item.func_77973_b(), item.field_77994_a, item.func_77960_j()));
            if (item.func_77942_o()) {
                entityItem.func_92059_d().func_77982_d((NBTTagCompound)item.func_77978_p().func_74737_b());
            }
            float factor = 0.05f;
            entityItem.field_70159_w = rando.nextGaussian() * (double)factor;
            entityItem.field_70181_x = rando.nextGaussian() * (double)factor + (double)0.2f;
            entityItem.field_70179_y = rando.nextGaussian() * (double)factor;
            world.func_72838_d((Entity)entityItem);
            item.field_77994_a = 0;
        }
    }

    private void dropSlot(World world, int i, int j, int k, int slot) {
        Random rando = new Random();
        TileEntity tileEntity = world.func_147438_o(i, j, k);
        if (!(tileEntity instanceof IInventory)) {
            return;
        }
        IInventory inventory = (IInventory)tileEntity;
        ItemStack item = inventory.func_70301_a(slot);
        if (item != null && item.field_77994_a > 0) {
            EntityItem entityItem = new EntityItem(world, (double)((float)i + 0.5f), (double)((float)j + 1.0f), (double)k + 0.5, new ItemStack(item.func_77973_b(), item.field_77994_a, item.func_77960_j()));
            if (item.func_77942_o()) {
                entityItem.func_92059_d().func_77982_d((NBTTagCompound)item.func_77978_p().func_74737_b());
            }
            entityItem.field_70159_w = 0.0;
            entityItem.field_70181_x = 0.0;
            entityItem.field_70179_y = 0.0;
            world.func_72838_d((Entity)entityItem);
        }
    }

    public boolean hasTileEntity(int metadata) {
        return true;
    }

    public TileEntity createTileEntity(World world, int metadata) {
        return new TileEntitySeat();
    }

    public void func_149651_a(IIconRegister par1IconRegister) {
        this.field_149761_L = par1IconRegister.func_94245_a("planks_spruce");
    }

    public void func_149689_a(World world, int i, int j, int k, EntityLivingBase player, ItemStack itemStack) {
        int angle = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        ++angle;
        angle %= 4;
        TileEntitySeat tile = (TileEntitySeat)world.func_147438_o(i, j, k);
        if (tile != null) {
            tile.setAngle(angle);
        }
    }

    public boolean func_149744_f() {
        return true;
    }

    public int func_149748_c(IBlockAccess blocka, int i, int j, int k, int face) {
        return this.func_149709_b(blocka, i, j, k, face);
    }

    public int func_149709_b(IBlockAccess blocka, int i, int j, int k, int face) {
        TileEntitySeat seat = (TileEntitySeat)blocka.func_147438_o(i, j, k);
        if (seat != null && seat.getHasSitter()) {
            return 15;
        }
        return 0;
    }

    public boolean rotateBlock(World world, int x, int y, int z, ForgeDirection axis) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile != null && tile instanceof TileEntitySeat) {
            TileEntitySeat te = (TileEntitySeat)tile;
            int angle = te.getAngle();
            switch (axis) {
                case NORTH: {
                    te.setAngle(1);
                    break;
                }
                case EAST: {
                    te.setAngle(2);
                    break;
                }
                case SOUTH: {
                    te.setAngle(3);
                    break;
                }
                case WEST: {
                    te.setAngle(0);
                    break;
                }
                case DOWN: {
                    if (angle <= 0) {
                        te.setAngle(3);
                    } else {
                        te.setAngle(angle - 1);
                    }
                    te.rotateConnections(true, angle);
                    break;
                }
                case UP: {
                    if (angle >= 3) {
                        te.setAngle(0);
                    } else {
                        te.setAngle(angle + 1);
                    }
                    te.rotateConnections(false, angle);
                    break;
                }
                case UNKNOWN: {
                    return false;
                }
                default: {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public ForgeDirection[] getValidRotations(World worldObj, int x, int y, int z) {
        ForgeDirection[] axises = new ForgeDirection[]{ForgeDirection.UP, ForgeDirection.DOWN};
        return axises;
    }
}

