/*
 * Decompiled with CFR 0.152.
 */
package net.bdew.lib.power;

import net.bdew.lib.data.DataSlotFloat;
import net.bdew.lib.data.DataSlotFloat$;
import net.bdew.lib.data.base.DataSlot;
import net.bdew.lib.data.base.DataSlotVal$;
import net.bdew.lib.data.base.TileDataSlots;
import net.bdew.lib.data.base.TileDataSlots$class;
import net.bdew.lib.data.base.UpdateKind$;
import net.bdew.lib.machine.PoweredMachine;
import net.bdew.lib.machine.ProcessorMachine;
import net.bdew.lib.power.DataSlotPower;
import net.bdew.lib.power.TilePoweredBase;
import net.bdew.lib.power.TilePoweredBase$class;
import net.bdew.lib.tile.TileExtended;
import net.bdew.lib.tile.inventory.BaseInventory$class;
import net.bdew.lib.tile.inventory.BreakableInventoryTile;
import net.bdew.lib.tile.inventory.BreakableInventoryTile$class;
import net.bdew.lib.tile.inventory.PersistentInventoryTile;
import net.bdew.lib.tile.inventory.PersistentInventoryTile$class;
import net.bdew.lib.tile.inventory.SidedInventory;
import net.bdew.lib.tile.inventory.SidedInventory$class;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import scala.Enumeration;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.mutable.HashMap;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001m3Q!\u0001\u0002\u0002\u0002-\u0011\u0011\u0003V5mK\n\u000b7/\u001a)s_\u000e,7o]8s\u0015\t\u0019A!A\u0003q_^,'O\u0003\u0002\u0006\r\u0005\u0019A.\u001b2\u000b\u0005\u001dA\u0011\u0001\u00022eK^T\u0011!C\u0001\u0004]\u0016$8\u0001A\n\b\u00011\u0011\"\u0004I\u0012'!\ti\u0001#D\u0001\u000f\u0015\tyA!\u0001\u0003uS2,\u0017BA\t\u000f\u00051!\u0016\u000e\\3FqR,g\u000eZ3e!\t\u0019\u0002$D\u0001\u0015\u0015\t)b#\u0001\u0003cCN,'BA\f\u0005\u0003\u0011!\u0017\r^1\n\u0005e!\"!\u0004+jY\u0016$\u0015\r^1TY>$8\u000f\u0005\u0002\u001c=5\tAD\u0003\u0002\u001e\u001d\u0005I\u0011N\u001c<f]R|'/_\u0005\u0003?q\u0011q\u0003U3sg&\u001cH/\u001a8u\u0013:4XM\u001c;pef$\u0016\u000e\\3\u0011\u0005m\t\u0013B\u0001\u0012\u001d\u0005Y\u0011%/Z1lC\ndW-\u00138wK:$xN]=US2,\u0007CA\u000e%\u0013\t)CD\u0001\bTS\u0012,G-\u00138wK:$xN]=\u0011\u0005\u001dBS\"\u0001\u0002\n\u0005%\u0012!a\u0004+jY\u0016\u0004vn^3sK\u0012\u0014\u0015m]3\t\u000b-\u0002A\u0011\u0001\u0017\u0002\rqJg.\u001b;?)\u0005i\u0003CA\u0014\u0001\u0011\u0015y\u0003A\"\u00011\u0003\r\u0019gmZ\u000b\u0002cA\u0011!'N\u0007\u0002g)\u0011A\u0007B\u0001\b[\u0006\u001c\u0007.\u001b8f\u0013\t14G\u0001\tQe>\u001cWm]:pe6\u000b7\r[5oK\"91\u0001\u0001b\u0001\n\u0003AT#A\u001d\u0011\u0005\u001dR\u0014BA\u001e\u0003\u00055!\u0015\r^1TY>$\bk\\<fe\"1Q\b\u0001Q\u0001\ne\na\u0001]8xKJ\u0004\u0003bB \u0001\u0005\u0004%\t\u0001Q\u0001\taJ|wM]3tgV\t\u0011\t\u0005\u0002C\u00076\ta#\u0003\u0002E-\tiA)\u0019;b'2|GO\u00127pCRDaA\u0012\u0001!\u0002\u0013\t\u0015!\u00039s_\u001e\u0014Xm]:!\u0011\u0015A\u0005\u0001\"\u0011J\u0003)!\u0018nY6TKJ4XM\u001d\u000b\u0002\u0015B\u00111JT\u0007\u0002\u0019*\tQ*A\u0003tG\u0006d\u0017-\u0003\u0002P\u0019\n!QK\\5u\u0011\u0015\t\u0006A\"\u0001S\u0003%I7oV8sW&tw-F\u0001T!\tYE+\u0003\u0002V\u0019\n9!i\\8mK\u0006t\u0007\"B,\u0001\r\u0003A\u0016\u0001\u0003;ssN#\u0018M\u001d;\u0015\u0003MCQA\u0017\u0001\u0007\u0002a\u000b\u0011\u0002\u001e:z\r&t\u0017n\u001d5")
public abstract class TileBaseProcessor
extends TileExtended
implements TileDataSlots,
PersistentInventoryTile,
BreakableInventoryTile,
SidedInventory,
TilePoweredBase {
    private final DataSlotPower power;
    private final DataSlotFloat progress;
    private boolean allowSided;
    private ItemStack[] inv;
    private final HashMap<String, DataSlot> dataSlots;
    private long lastChange;

    @Override
    public void configurePower(PoweredMachine cfg) {
        TilePoweredBase$class.configurePower(this, cfg);
    }

    @Override
    public boolean allowSided() {
        return this.allowSided;
    }

    @Override
    public void allowSided_$eq(boolean x$1) {
        this.allowSided = x$1;
    }

    @Override
    public int[] func_94128_d(int side) {
        return SidedInventory$class.getAccessibleSlotsFromSide(this, side);
    }

    @Override
    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        return SidedInventory$class.canInsertItem(this, slot, stack, side);
    }

    @Override
    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return SidedInventory$class.canExtractItem(this, slot, stack, side);
    }

    @Override
    public void dropItems() {
        BreakableInventoryTile$class.dropItems(this);
    }

    @Override
    public ItemStack[] inv() {
        return this.inv;
    }

    @Override
    public void inv_$eq(ItemStack[] x$1) {
        this.inv = x$1;
    }

    @Override
    public ItemStack func_70301_a(int i) {
        return BaseInventory$class.getStackInSlot(this, i);
    }

    @Override
    public String func_145825_b() {
        return BaseInventory$class.getInventoryName(this);
    }

    @Override
    public boolean func_145818_k_() {
        return BaseInventory$class.hasCustomInventoryName(this);
    }

    @Override
    public int func_70297_j_() {
        return BaseInventory$class.getInventoryStackLimit(this);
    }

    @Override
    public boolean func_70300_a(EntityPlayer player) {
        return BaseInventory$class.isUseableByPlayer(this, player);
    }

    @Override
    public void func_70295_k_() {
        BaseInventory$class.openInventory(this);
    }

    @Override
    public void func_70305_f() {
        BaseInventory$class.closeInventory(this);
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        return BaseInventory$class.isItemValidForSlot(this, slot, stack);
    }

    @Override
    public ItemStack func_70298_a(int slot, int n) {
        return BaseInventory$class.decrStackSize(this, slot, n);
    }

    @Override
    public ItemStack func_70304_b(int slot) {
        return BaseInventory$class.getStackInSlotOnClosing(this, slot);
    }

    @Override
    public void func_70299_a(int slot, ItemStack stack) {
        BaseInventory$class.setInventorySlotContents(this, slot, stack);
    }

    @Override
    public HashMap<String, DataSlot> dataSlots() {
        return this.dataSlots;
    }

    @Override
    public long lastChange() {
        return this.lastChange;
    }

    @Override
    @TraitSetter
    public void lastChange_$eq(long x$1) {
        this.lastChange = x$1;
    }

    @Override
    public final boolean TRACE() {
        return false;
    }

    @Override
    public /* synthetic */ void net$bdew$lib$data$base$TileDataSlots$$super$extDataPacket(int id, NBTTagCompound data) {
        super.extDataPacket(id, data);
    }

    @Override
    public void net$bdew$lib$data$base$TileDataSlots$_setter_$dataSlots_$eq(HashMap x$1) {
        this.dataSlots = x$1;
    }

    @Override
    public void doSave(Enumeration.Value kind, NBTTagCompound t) {
        TileDataSlots$class.doSave(this, kind, t);
    }

    @Override
    public void doLoad(Enumeration.Value kind, NBTTagCompound t) {
        TileDataSlots$class.doLoad(this, kind, t);
    }

    @Override
    public void dataSlotChanged(DataSlot slot) {
        TileDataSlots$class.dataSlotChanged(this, slot);
    }

    @Override
    public Packet getDataSlotPacket() {
        return TileDataSlots$class.getDataSlotPacket(this);
    }

    @Override
    public void extDataPacket(int id, NBTTagCompound data) {
        TileDataSlots$class.extDataPacket(this, id, data);
    }

    public abstract ProcessorMachine cfg();

    @Override
    public DataSlotPower power() {
        return this.power;
    }

    public DataSlotFloat progress() {
        return this.progress;
    }

    @Override
    public void tickServer() {
        if (this.power().stored() > this.cfg().activationEnergy()) {
            if (!this.isWorking() && this.tryStart()) {
                this.progress().$colon$eq(BoxesRunTime.boxToFloat((float)0.0f));
            }
            if (this.isWorking()) {
                if (BoxesRunTime.unboxToFloat((Object)DataSlotVal$.MODULE$.slot2val(this.progress())) < 1.0f && this.power().stored() > this.cfg().activationEnergy()) {
                    float maxConsume = Math.min(Math.max(this.cfg().powerUseRate() * this.power().stored(), this.cfg().activationEnergy()), this.cfg().mjPerItem() * (1.0f - BoxesRunTime.unboxToFloat((Object)DataSlotVal$.MODULE$.slot2val(this.progress()))));
                    float consumed = this.power().extract(maxConsume, false);
                    this.progress().$plus$eq(BoxesRunTime.boxToFloat((float)(consumed / this.cfg().mjPerItem())));
                }
                if (BoxesRunTime.unboxToFloat((Object)DataSlotVal$.MODULE$.slot2val(this.progress())) >= 1.0f && this.tryFinish()) {
                    this.progress().$colon$eq(BoxesRunTime.boxToFloat((float)0.0f));
                }
            }
        }
    }

    public abstract boolean isWorking();

    public abstract boolean tryStart();

    public abstract boolean tryFinish();

    public TileBaseProcessor() {
        TileDataSlots$class.$init$(this);
        BaseInventory$class.$init$(this);
        PersistentInventoryTile$class.$init$(this);
        BreakableInventoryTile$class.$init$(this);
        SidedInventory$class.$init$(this);
        TilePoweredBase$class.$init$(this);
        this.power = new DataSlotPower("power", this);
        this.progress = (DataSlotFloat)new DataSlotFloat("progress", this, DataSlotFloat$.MODULE$.apply$default$3()).setUpdate((Seq<Enumeration.Value>)Predef$.MODULE$.wrapRefArray((Object[])new Enumeration.Value[]{UpdateKind$.MODULE$.SAVE(), UpdateKind$.MODULE$.GUI()}));
        this.configurePower(this.cfg());
    }
}

