/*
 * Decompiled with CFR 0.152.
 */
package openmods.utils.render;

import java.util.EnumSet;
import net.minecraft.util.Vec3;
import net.minecraftforge.common.util.ForgeDirection;
import openmods.shapes.IShapeable;
import openmods.utils.MathUtils;

public class GeometryUtils {
    public static void makeLine(int startX, int startY, int startZ, ForgeDirection direction, int length, IShapeable shapeable) {
        if (length == 0) {
            return;
        }
        for (int offset = 0; offset <= length; ++offset) {
            shapeable.setBlock(startX + offset * direction.offsetX, startY + offset * direction.offsetY, startZ + offset * direction.offsetZ);
        }
    }

    public static void makePlane(int startX, int startY, int startZ, int width, int height, ForgeDirection right, ForgeDirection up, IShapeable shapeable) {
        if (width == 0 || height == 0) {
            return;
        }
        for (int h = 0; h <= height; ++h) {
            int lineOffsetX = startX + h * up.offsetX;
            int lineOffsetY = startY + h * up.offsetY;
            int lineOffsetZ = startZ + h * up.offsetZ;
            GeometryUtils.makeLine(lineOffsetX, lineOffsetY, lineOffsetZ, right, width, shapeable);
        }
    }

    public static void makeSphere(int radiusX, int radiusY, int radiusZ, IShapeable shapeable, EnumSet<Octant> octants) {
        double invRadiusX = 1.0 / ((double)radiusX + 0.5);
        double invRadiusY = 1.0 / ((double)radiusY + 0.5);
        double invRadiusZ = 1.0 / ((double)radiusZ + 0.5);
        EnumSet<Octant> octantSet = octants;
        double nextXn = 0.0;
        block0: for (int x = 0; x <= radiusX; ++x) {
            double xn = nextXn;
            nextXn = (double)(x + 1) * invRadiusX;
            double nextYn = 0.0;
            block1: for (int y = 0; y <= radiusY; ++y) {
                double yn = nextYn;
                nextYn = (double)(y + 1) * invRadiusY;
                double nextZn = 0.0;
                for (int z = 0; z <= radiusZ; ++z) {
                    double zn = nextZn;
                    nextZn = (double)(z + 1) * invRadiusZ;
                    double distanceSq = MathUtils.lengthSq(xn, yn, zn);
                    if (distanceSq > 1.0) {
                        if (z != 0) continue block1;
                        if (y != 0) continue block0;
                        break block0;
                    }
                    if (MathUtils.lengthSq(nextXn, yn, zn) <= 1.0 && MathUtils.lengthSq(xn, nextYn, zn) <= 1.0 && MathUtils.lengthSq(xn, yn, nextZn) <= 1.0) continue;
                    for (Octant octant : octantSet) {
                        shapeable.setBlock(x * octant.getXOffset(), y * octant.getYOffset(), z * octant.getZOffset());
                    }
                }
            }
        }
    }

    public static void line2D(int y, int x0, int z0, int x1, int z1, IShapeable shapeable) {
        int dx = Math.abs(x1 - x0);
        int sx = x0 < x1 ? 1 : -1;
        int dy = -Math.abs(z1 - z0);
        int sy = z0 < z1 ? 1 : -1;
        int err = dx + dy;
        while (true) {
            shapeable.setBlock(x0, y, z0);
            if (x0 == x1 && z0 == z1) break;
            int e2 = 2 * err;
            if (e2 >= dy) {
                err += dy;
                x0 += sx;
            }
            if (e2 > dx) continue;
            err += dx;
            z0 += sy;
        }
    }

    public static void line3D(Vec3 start, Vec3 end, IShapeable shapeable) {
        int dx = (int)(end.field_72450_a - start.field_72450_a);
        int dy = (int)(end.field_72448_b - start.field_72448_b);
        int dz = (int)(end.field_72449_c - start.field_72449_c);
        int ax = Math.abs(dx) << 1;
        int ay = Math.abs(dy) << 1;
        int az = Math.abs(dz) << 1;
        int signx = (int)Math.signum(dx);
        int signy = (int)Math.signum(dy);
        int signz = (int)Math.signum(dz);
        int x = (int)start.field_72450_a;
        int y = (int)start.field_72448_b;
        int z = (int)start.field_72449_c;
        if (ax >= Math.max(ay, az)) {
            int deltay = ay - (ax >> 1);
            int deltaz = az - (ax >> 1);
            while (true) {
                shapeable.setBlock(x, y, z);
                if (x == (int)end.field_72450_a) {
                    return;
                }
                if (deltay >= 0) {
                    y += signy;
                    deltay -= ax;
                }
                if (deltaz >= 0) {
                    z += signz;
                    deltaz -= ax;
                }
                x += signx;
                deltay += ay;
                deltaz += az;
            }
        }
        if (ay >= Math.max(ax, az)) {
            int deltax = ax - (ay >> 1);
            int deltaz = az - (ay >> 1);
            while (true) {
                shapeable.setBlock(x, y, z);
                if (y == (int)end.field_72448_b) {
                    return;
                }
                if (deltax >= 0) {
                    x += signx;
                    deltax -= ay;
                }
                if (deltaz >= 0) {
                    z += signz;
                    deltaz -= ay;
                }
                y += signy;
                deltax += ax;
                deltaz += az;
            }
        }
        if (az >= Math.max(ax, ay)) {
            int deltax = ax - (az >> 1);
            int deltay = ay - (az >> 1);
            while (true) {
                shapeable.setBlock(x, y, z);
                if (z == (int)end.field_72449_c) {
                    return;
                }
                if (deltax >= 0) {
                    x += signx;
                    deltax -= az;
                }
                if (deltay >= 0) {
                    y += signy;
                    deltay -= az;
                }
                z += signz;
                deltax += ax;
                deltay += ay;
            }
        }
    }

    public static double normalizeAngle(double angle) {
        while (angle > 180.0) {
            angle -= 360.0;
        }
        while (angle < -180.0) {
            angle += 360.0;
        }
        return angle;
    }

    public static double compareAngles(double current, double target) {
        current = GeometryUtils.normalizeAngle(current);
        target = GeometryUtils.normalizeAngle(target);
        return Math.signum(target - current);
    }

    public static double getAngleDistance(double current, double target) {
        double result = target - current;
        return Math.abs(result) > 180.0 ? 180.0 - result : result;
    }

    public static enum Octant {
        TopSouthWest(-1, 1, 1, "Top South West"),
        TopNorthEast(1, 1, -1, "Top North East"),
        TopNorthWest(1, 1, 1, "Top North West"),
        TopSouthEast(-1, 1, -1, "Top South East"),
        BottomSouthWest(-1, -1, 1, "Bottom South West"),
        BottomNorthEast(1, -1, -1, "Bottom North East"),
        BottomNorthWest(1, -1, 1, "Bottom North West"),
        BottomSouthEast(-1, -1, -1, "Bottom South East");

        public static final EnumSet<Octant> ALL;
        public static final EnumSet<Octant> TOP;
        public static final EnumSet<Octant> BOTTOM;
        private final int x;
        private final int y;
        private final int z;
        private final String name;

        public int getXOffset() {
            return this.x;
        }

        public int getYOffset() {
            return this.y;
        }

        public int getZOffset() {
            return this.z;
        }

        public String getFriendlyName() {
            return this.name;
        }

        private Octant(int x, int y, int z, String friendlyName) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.name = friendlyName;
        }

        static {
            ALL = EnumSet.allOf(Octant.class);
            TOP = EnumSet.of(TopSouthEast, TopSouthWest, TopNorthEast, TopNorthWest);
            BOTTOM = EnumSet.of(BottomSouthEast, BottomSouthWest, BottomNorthEast, BottomNorthWest);
        }
    }
}

