/*
 * Decompiled with CFR 0.152.
 */
package openmods.utils;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.InventoryLargeChest;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class InventoryUtils {
    public static boolean areItemAndTagEqual(ItemStack stackA, ItemStack stackB) {
        return stackA.func_77969_a(stackB) && ItemStack.func_77970_a((ItemStack)stackA, (ItemStack)stackB);
    }

    public static boolean areMergeCandidates(ItemStack source, ItemStack target) {
        return InventoryUtils.areItemAndTagEqual(source, target) && target.field_77994_a < target.func_77976_d();
    }

    public static ItemStack copyAndChange(ItemStack stack, int newSize) {
        ItemStack copy = stack.func_77946_l();
        copy.field_77994_a = newSize;
        return copy;
    }

    public static void removeFromSlot(IInventory inventory, int slot, int amount) {
        ItemStack sourceStack = inventory.func_70301_a(slot);
        sourceStack.field_77994_a -= amount;
        if (sourceStack.field_77994_a == 0) {
            inventory.func_70299_a(slot, null);
        } else {
            inventory.func_70299_a(slot, sourceStack);
        }
    }

    private static IInventory doubleChestFix(TileEntity te) {
        int z;
        int y;
        int x;
        World world = te.func_145831_w();
        if (world.func_147439_a((x = te.field_145851_c) - 1, y = te.field_145848_d, z = te.field_145849_e) == Blocks.field_150486_ae) {
            return new InventoryLargeChest("Large chest", (IInventory)world.func_147438_o(x - 1, y, z), (IInventory)te);
        }
        if (world.func_147439_a(x + 1, y, z) == Blocks.field_150486_ae) {
            return new InventoryLargeChest("Large chest", (IInventory)te, (IInventory)world.func_147438_o(x + 1, y, z));
        }
        if (world.func_147439_a(x, y, z - 1) == Blocks.field_150486_ae) {
            return new InventoryLargeChest("Large chest", (IInventory)world.func_147438_o(x, y, z - 1), (IInventory)te);
        }
        if (world.func_147439_a(x, y, z + 1) == Blocks.field_150486_ae) {
            return new InventoryLargeChest("Large chest", (IInventory)te, (IInventory)world.func_147438_o(x, y, z + 1));
        }
        return te instanceof IInventory ? (IInventory)te : null;
    }

    public static IInventory getInventory(World world, int x, int y, int z) {
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileEntity instanceof TileEntityChest) {
            return InventoryUtils.doubleChestFix(tileEntity);
        }
        if (tileEntity instanceof IInventory) {
            return (IInventory)tileEntity;
        }
        return null;
    }

    public static IInventory getInventory(World world, int x, int y, int z, ForgeDirection direction) {
        if (direction != null) {
            x += direction.offsetX;
            y += direction.offsetY;
            z += direction.offsetZ;
        }
        return InventoryUtils.getInventory(world, x, y, z);
    }

    public static IInventory getInventory(IInventory inventory) {
        if (inventory instanceof TileEntityChest) {
            return InventoryUtils.doubleChestFix((TileEntity)inventory);
        }
        return inventory;
    }

    public static List<ItemStack> getInventoryContents(IInventory inventory) {
        ArrayList result = Lists.newArrayList();
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack slot = inventory.func_70301_a(i);
            if (slot == null) continue;
            result.add(slot);
        }
        return result;
    }

    public static int getFirstSlotWithStack(IInventory inventory, ItemStack stack) {
        inventory = InventoryUtils.getInventory(inventory);
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stackInSlot = inventory.func_70301_a(i);
            if (stackInSlot == null || !stackInSlot.func_77969_a(stack)) continue;
            return i;
        }
        return -1;
    }

    public static Set<Integer> getAllSlotsWithStack(IInventory inventory, ItemStack stack) {
        inventory = InventoryUtils.getInventory(inventory);
        HashSet slots = Sets.newHashSet();
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stackInSlot = inventory.func_70301_a(i);
            if (stackInSlot == null || !stackInSlot.func_77969_a(stack)) continue;
            slots.add(i);
        }
        return slots;
    }

    public static int getFirstNonEmptySlot(IInventory inventory) {
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (stack == null) continue;
            return i;
        }
        return -1;
    }

    public static Set<Integer> getAllSlots(IInventory inventory) {
        inventory = InventoryUtils.getInventory(inventory);
        HashSet slots = Sets.newHashSet();
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            slots.add(i);
        }
        return slots;
    }

    public static Map<Integer, ItemStack> getAllItems(IInventory inventory) {
        HashMap result = Maps.newHashMap();
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (stack == null) continue;
            result.put(i, stack);
        }
        return result;
    }

    public static boolean inventoryIsEmpty(IInventory inventory) {
        int l = inventory.func_70302_i_();
        for (int i = 0; i < l; ++i) {
            if (inventory.func_70301_a(i) == null) continue;
            return false;
        }
        return true;
    }

    public static boolean tryMergeStacks(ItemStack stackToMerge, ItemStack stackInSlot) {
        if (stackInSlot == null || !stackInSlot.func_77969_a(stackToMerge) || !ItemStack.func_77970_a((ItemStack)stackToMerge, (ItemStack)stackInSlot)) {
            return false;
        }
        int newStackSize = stackInSlot.field_77994_a + stackToMerge.field_77994_a;
        int maxStackSize = stackToMerge.func_77976_d();
        if (newStackSize <= maxStackSize) {
            stackToMerge.field_77994_a = 0;
            stackInSlot.field_77994_a = newStackSize;
            return true;
        }
        if (stackInSlot.field_77994_a < maxStackSize) {
            stackToMerge.field_77994_a -= maxStackSize - stackInSlot.field_77994_a;
            stackInSlot.field_77994_a = maxStackSize;
            return true;
        }
        return false;
    }

    public static ItemStack returnItem(ItemStack stack) {
        return stack == null || stack.field_77994_a <= 0 ? null : stack.func_77946_l();
    }

    public static void swapStacks(IInventory inventory, int slot1, int slot2) {
        InventoryUtils.swapStacks(inventory, slot1, slot2, true, true);
    }

    public static void swapStacks(IInventory inventory, int slot1, int slot2, boolean copy, boolean validate) {
        Preconditions.checkElementIndex((int)slot1, (int)inventory.func_70302_i_(), (String)"input slot id");
        Preconditions.checkElementIndex((int)slot2, (int)inventory.func_70302_i_(), (String)"output slot id");
        ItemStack stack1 = inventory.func_70301_a(slot1);
        ItemStack stack2 = inventory.func_70301_a(slot2);
        if (validate) {
            InventoryUtils.isItemValid(inventory, slot2, stack1);
            InventoryUtils.isItemValid(inventory, slot1, stack2);
        }
        if (copy) {
            if (stack1 != null) {
                stack1 = stack1.func_77946_l();
            }
            if (stack2 != null) {
                stack2 = stack2.func_77946_l();
            }
        }
        inventory.func_70299_a(slot1, stack2);
        inventory.func_70299_a(slot2, stack1);
    }

    public static void swapStacks(ISidedInventory inventory, int slot1, ForgeDirection side1, int slot2, ForgeDirection side2) {
        InventoryUtils.swapStacks(inventory, slot1, side1, slot2, side2, true, true);
    }

    public static void swapStacks(ISidedInventory inventory, int slot1, ForgeDirection side1, int slot2, ForgeDirection side2, boolean copy, boolean validate) {
        Preconditions.checkElementIndex((int)slot1, (int)inventory.func_70302_i_(), (String)"input slot id");
        Preconditions.checkElementIndex((int)slot2, (int)inventory.func_70302_i_(), (String)"output slot id");
        ItemStack stack1 = inventory.func_70301_a(slot1);
        ItemStack stack2 = inventory.func_70301_a(slot2);
        if (validate) {
            InventoryUtils.isItemValid((IInventory)inventory, slot2, stack1);
            InventoryUtils.isItemValid((IInventory)inventory, slot1, stack2);
            InventoryUtils.canExtract(inventory, slot1, side1, stack1);
            InventoryUtils.canInsert(inventory, slot2, side2, stack1);
            InventoryUtils.canExtract(inventory, slot2, side2, stack2);
            InventoryUtils.canInsert(inventory, slot1, side1, stack2);
        }
        if (copy) {
            if (stack1 != null) {
                stack1 = stack1.func_77946_l();
            }
            if (stack2 != null) {
                stack2 = stack2.func_77946_l();
            }
        }
        inventory.func_70299_a(slot1, stack2);
        inventory.func_70299_a(slot2, stack1);
    }

    protected static void isItemValid(IInventory inventory, int slot, ItemStack stack) {
        Preconditions.checkArgument((boolean)inventory.func_94041_b(slot, stack), (String)"Slot %s cannot accept item", (Object[])new Object[]{slot});
    }

    protected static void canInsert(ISidedInventory inventory, int slot, ForgeDirection side, ItemStack stack) {
        Preconditions.checkArgument((boolean)inventory.func_102007_a(slot, stack, side.ordinal()), (String)"Item cannot be inserted into slot %s on side %s", (Object[])new Object[]{slot, side});
    }

    protected static void canExtract(ISidedInventory inventory, int slot, ForgeDirection side, ItemStack stack) {
        Preconditions.checkArgument((boolean)inventory.func_102008_b(slot, stack, side.ordinal()), (String)"Item cannot be extracted from slot %s on side %s", (Object[])new Object[]{slot, side});
    }
}

