/*
 * Decompiled with CFR 0.152.
 */
package openmods.structured;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.SortedSet;
import openmods.utils.ByteUtils;
import openmods.utils.CollectionUtils;

public abstract class Command {
    public static final Comparator<Command> COMPARATOR = new Comparator<Command>(){

        @Override
        public int compare(Command o1, Command o2) {
            return o1.type().compareTo(o2.type());
        }
    };
    static final Reset RESET_INST = new Reset();
    private static final EmptyCommand END_INST = new EmptyCommand(){

        @Override
        public Type type() {
            return Type.END;
        }

        @Override
        public boolean isEnd() {
            return true;
        }
    };

    public abstract Type type();

    protected abstract void readDataFromStream(DataInput var1) throws IOException;

    protected abstract void writeDataToStream(DataOutput var1) throws IOException;

    public static Command createFromStream(DataInput input) throws IOException {
        int id = ByteUtils.readVLI(input);
        Type type = Type.TYPES[id];
        Command command = type.create();
        command.readDataFromStream(input);
        return command;
    }

    public void writeToStream(DataOutput output) throws IOException {
        ByteUtils.writeVLI(output, this.type().ordinal());
        this.writeDataToStream(output);
    }

    protected boolean isEnd() {
        return false;
    }

    public int versionChange() {
        return 0;
    }

    public String dumpContents() {
        return "";
    }

    public String toString() {
        return (Object)((Object)this.type()) + ": " + this.dumpContents();
    }

    public static class UpdateBulk
    extends Update {
        @Override
        public Type type() {
            return Type.UPDATE_BULK;
        }

        @Override
        protected void readDataFromStream(DataInput input) throws IOException {
            super.readDataFromStream(input);
        }

        @Override
        protected void writeDataToStream(DataOutput output) throws IOException {
            super.writeDataToStream(output);
        }
    }

    public static class UpdateSingle
    extends Update {
        @Override
        public Type type() {
            return Type.UPDATE_SINGLE;
        }

        @Override
        protected void readDataFromStream(DataInput input) throws IOException {
            CollectionUtils.readSortedIdList(input, this.idList);
            super.readDataFromStream(input);
        }

        @Override
        protected void writeDataToStream(DataOutput output) throws IOException {
            CollectionUtils.writeSortedIdList(output, this.idList);
            super.writeDataToStream(output);
        }

        @Override
        public String dumpContents() {
            return String.format("%s -> %s", this.idList, this.payload == null ? "<null>" : Integer.toString(this.payload.length));
        }

        @Override
        public int versionChange() {
            return this.idList.size();
        }
    }

    public static abstract class Update
    extends PayloadCommand {
        public final SortedSet<Integer> idList = Sets.newTreeSet();
    }

    public static class Create
    extends PayloadCommand {
        public final List<ContainerInfo> containers = Lists.newArrayList();

        @Override
        public Type type() {
            return Type.CREATE;
        }

        @Override
        protected void readDataFromStream(DataInput input) throws IOException {
            int elemCount = ByteUtils.readVLI(input);
            int currentContainerId = 0;
            int currentElementId = 0;
            for (int i = 0; i < elemCount; ++i) {
                int type = ByteUtils.readVLI(input);
                this.containers.add(new ContainerInfo(currentContainerId += ByteUtils.readVLI(input), type, currentElementId += ByteUtils.readVLI(input)));
            }
            super.readDataFromStream(input);
        }

        @Override
        protected void writeDataToStream(DataOutput output) throws IOException {
            ByteUtils.writeVLI(output, this.containers.size());
            int prevContainerId = 0;
            int prevElementId = 0;
            for (ContainerInfo info : this.containers) {
                int deltaContainerId = info.id - prevContainerId;
                Preconditions.checkArgument((deltaContainerId >= 0 ? 1 : 0) != 0, (Object)"Container ids must be sorted in ascending order");
                int deltaElementId = info.start - prevElementId;
                Preconditions.checkArgument((deltaElementId >= 0 ? 1 : 0) != 0, (Object)"Element ids must be sorted in ascending order");
                ByteUtils.writeVLI(output, deltaContainerId);
                ByteUtils.writeVLI(output, info.type);
                ByteUtils.writeVLI(output, deltaElementId);
                prevContainerId = info.id;
                prevElementId = info.start;
            }
            super.writeDataToStream(output);
        }

        @Override
        public String dumpContents() {
            return String.format("%s -> %s", this.containers, this.payload == null ? "<null>" : Integer.toString(this.payload.length));
        }

        @Override
        public int versionChange() {
            return this.containers.size();
        }
    }

    public static abstract class PayloadCommand
    extends Command {
        byte[] payload;

        @Override
        protected void readDataFromStream(DataInput input) throws IOException {
            int payloadSize = ByteUtils.readVLI(input);
            this.payload = new byte[payloadSize];
            input.readFully(this.payload);
        }

        @Override
        protected void writeDataToStream(DataOutput output) throws IOException {
            ByteUtils.writeVLI(output, this.payload.length);
            output.write(this.payload);
        }

        @Override
        public String dumpContents() {
            return this.payload == null ? "<null>" : Integer.toString(this.payload.length);
        }
    }

    public static class Delete
    extends Command {
        public final SortedSet<Integer> idList = Sets.newTreeSet();

        @Override
        public Type type() {
            return Type.DELETE;
        }

        @Override
        protected void readDataFromStream(DataInput input) {
            CollectionUtils.readSortedIdList(input, this.idList);
        }

        @Override
        protected void writeDataToStream(DataOutput output) {
            CollectionUtils.writeSortedIdList(output, this.idList);
        }

        @Override
        public String dumpContents() {
            return String.valueOf(this.idList);
        }

        @Override
        public int versionChange() {
            return this.idList.size();
        }
    }

    public static class ContainerInfo {
        public final int id;
        public final int type;
        public final int start;

        public ContainerInfo(int id, int type, int start) {
            this.id = id;
            this.type = type;
            this.start = start;
        }

        public String toString() {
            return "[id=" + this.id + ", type=" + this.type + ", start=" + this.start + "]";
        }
    }

    public static final class Reset
    extends EmptyCommand {
        @Override
        public Type type() {
            return Type.RESET;
        }
    }

    public static abstract class EmptyCommand
    extends Command {
        @Override
        protected void readDataFromStream(DataInput input) {
        }

        @Override
        protected void writeDataToStream(DataOutput output) {
        }
    }

    public static class SetVersion
    extends Command {
        public byte version;

        @Override
        public Type type() {
            return Type.SET_VERSION;
        }

        @Override
        protected void readDataFromStream(DataInput input) throws IOException {
            this.version = input.readByte();
        }

        @Override
        protected void writeDataToStream(DataOutput output) throws IOException {
            output.writeByte(this.version);
        }

        @Override
        public String dumpContents() {
            return Byte.toString(this.version);
        }
    }

    public static class ConsistencyCheck
    extends Command {
        public byte version;
        public int elementCount;
        public int maxElementId;
        public int containerCount;
        public int maxContainerId;

        @Override
        public Type type() {
            return Type.CONSISTENCY_CHECK;
        }

        @Override
        protected void readDataFromStream(DataInput input) throws IOException {
            this.version = input.readByte();
            this.elementCount = ByteUtils.readVLI(input);
            this.maxElementId = ByteUtils.readVLI(input);
            this.containerCount = ByteUtils.readVLI(input);
            this.maxContainerId = ByteUtils.readVLI(input);
        }

        @Override
        protected void writeDataToStream(DataOutput output) throws IOException {
            output.writeByte(this.version);
            ByteUtils.writeVLI(output, this.elementCount);
            ByteUtils.writeVLI(output, this.maxElementId);
            ByteUtils.writeVLI(output, this.containerCount);
            ByteUtils.writeVLI(output, this.maxContainerId);
        }

        @Override
        public String dumpContents() {
            return "[version=" + this.version + ", elementCount=" + this.elementCount + ", maxElementId=" + this.maxElementId + ", containerCount=" + this.containerCount + ", maxContainerId=" + this.maxContainerId + "]";
        }
    }

    private static enum Type {
        RESET{

            @Override
            public Reset create() {
                return RESET_INST;
            }
        }
        ,
        DELETE{

            @Override
            public Delete create() {
                return new Delete();
            }
        }
        ,
        CREATE{

            @Override
            public Create create() {
                return new Create();
            }
        }
        ,
        UPDATE_SINGLE{

            @Override
            public PayloadCommand create() {
                return new UpdateSingle();
            }
        }
        ,
        UPDATE_BULK{

            @Override
            public PayloadCommand create() {
                return new UpdateBulk();
            }
        }
        ,
        SET_VERSION{

            @Override
            public SetVersion create() {
                return new SetVersion();
            }
        }
        ,
        CONSISTENCY_CHECK{

            @Override
            public ConsistencyCheck create() {
                return new ConsistencyCheck();
            }
        }
        ,
        END{

            @Override
            public EmptyCommand create() {
                return END_INST;
            }
        };

        public static final Type[] TYPES;

        public abstract Command create();

        static {
            TYPES = Type.values();
        }
    }

    public static class CommandList
    extends ArrayList<Command> {
        private static final long serialVersionUID = 8317603452787461684L;

        public void readFromStream(DataInput input) throws IOException {
            Command command;
            while (!(command = Command.createFromStream(input)).isEnd()) {
                this.add(command);
            }
            return;
        }

        public void writeToStream(DataOutput output) throws IOException {
            Collections.sort(this, COMPARATOR);
            for (Command c : this) {
                c.writeToStream(output);
                if (!c.isEnd()) continue;
                return;
            }
            END_INST.writeToStream(output);
        }
    }
}

