/*
 * Decompiled with CFR 0.152.
 */
package openmods.inventory.legacy;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import openmods.inventory.GenericInventory;
import openmods.inventory.legacy.CustomSinks;
import openmods.utils.BlockUtils;
import openmods.utils.InventoryUtils;

public class ItemDistribution {
    public static boolean consumeFirstInventoryItem(IInventory inventory, ItemStack stack) {
        int slotWithStack = InventoryUtils.getFirstSlotWithStack(inventory, stack);
        if (slotWithStack > -1) {
            ItemStack stackInSlot = inventory.func_70301_a(slotWithStack);
            --stackInSlot.field_77994_a;
            if (stackInSlot.field_77994_a == 0) {
                inventory.func_70299_a(slotWithStack, null);
            }
            return true;
        }
        return false;
    }

    public static boolean insertItemIntoInventory(IInventory inventory, ItemStack stack) {
        return ItemDistribution.insertItemIntoInventory(inventory, stack, ForgeDirection.UNKNOWN, -1);
    }

    public static boolean insertItemIntoInventory(IInventory inventory, ItemStack stack, ForgeDirection side, int intoSlot) {
        return ItemDistribution.insertItemIntoInventory(inventory, stack, side, intoSlot, true);
    }

    public static boolean insertItemIntoInventory(IInventory inventory, ItemStack stack, ForgeDirection side, int intoSlot, boolean doMove) {
        return ItemDistribution.insertItemIntoInventory(inventory, stack, side, intoSlot, doMove, true);
    }

    public static boolean insertItemIntoInventory(IInventory inventory, ItemStack stack, ForgeDirection side, int intoSlot, boolean doMove, boolean canStack) {
        boolean isSidedInventory;
        if (stack == null) {
            return false;
        }
        int sideId = side.ordinal();
        IInventory targetInventory = inventory;
        if (!doMove) {
            GenericInventory copy = new GenericInventory("temporary.inventory", false, targetInventory.func_70302_i_());
            copy.copyFrom(inventory);
            targetInventory = copy;
        }
        TreeSet attemptSlots = Sets.newTreeSet();
        boolean bl = isSidedInventory = inventory instanceof ISidedInventory && side != ForgeDirection.UNKNOWN;
        if (isSidedInventory) {
            int[] accessibleSlots;
            for (int slot : accessibleSlots = ((ISidedInventory)inventory).func_94128_d(sideId)) {
                attemptSlots.add(slot);
            }
        } else {
            for (int a = 0; a < inventory.func_70302_i_(); ++a) {
                attemptSlots.add(a);
            }
        }
        if (intoSlot > -1) {
            attemptSlots.retainAll((Collection<?>)ImmutableSet.of((Object)intoSlot));
        }
        if (attemptSlots.isEmpty()) {
            return false;
        }
        boolean result = false;
        for (Integer slot : attemptSlots) {
            if (stack.field_77994_a <= 0) break;
            if (isSidedInventory && !((ISidedInventory)inventory).func_102007_a(slot.intValue(), stack, sideId)) continue;
            result |= ItemDistribution.tryInsertStack(targetInventory, slot, stack, canStack);
        }
        return result;
    }

    public static int moveItemInto(IInventory fromInventory, int fromSlot, CustomSinks.ICustomSink sink, int maxAmount, ForgeDirection direction, boolean doMove) {
        ItemStack sourceStack = (fromInventory = InventoryUtils.getInventory(fromInventory)).func_70301_a(fromSlot);
        if (sourceStack == null || maxAmount <= 0) {
            return 0;
        }
        if (fromInventory instanceof ISidedInventory && !((ISidedInventory)fromInventory).func_102008_b(fromSlot, sourceStack, direction.ordinal())) {
            return 0;
        }
        int amountToMove = Math.min(sourceStack.field_77994_a, maxAmount);
        ItemStack clonedSourceStack = InventoryUtils.copyAndChange(sourceStack, amountToMove);
        int inserted = sink.accept(clonedSourceStack, doMove, direction);
        if (doMove) {
            InventoryUtils.removeFromSlot(fromInventory, fromSlot, inserted);
        }
        return inserted;
    }

    public static boolean insertItemInto(ItemStack stack, CustomSinks.ICustomSink sink, ForgeDirection intoSide, boolean doMove) {
        ItemStack clonedSourceStack = stack.func_77946_l();
        int inserted = sink.accept(clonedSourceStack, doMove, intoSide);
        if (inserted > 0) {
            stack.field_77994_a -= inserted;
            return true;
        }
        return false;
    }

    public static int moveItemInto(IInventory fromInventory, int fromSlot, IInventory target, int intoSlot, int maxAmount, ForgeDirection direction, boolean doMove) {
        return ItemDistribution.moveItemInto(fromInventory, fromSlot, target, intoSlot, maxAmount, direction, doMove, true);
    }

    public static int moveItemInto(IInventory fromInventory, int fromSlot, IInventory toInventory, int intoSlot, int maxAmount, ForgeDirection direction, boolean doMove, boolean canStack) {
        ItemStack sourceStack = (fromInventory = InventoryUtils.getInventory(fromInventory)).func_70301_a(fromSlot);
        if (sourceStack == null || maxAmount <= 0) {
            return 0;
        }
        if (fromInventory instanceof ISidedInventory && !((ISidedInventory)fromInventory).func_102008_b(fromSlot, sourceStack, direction.ordinal())) {
            return 0;
        }
        int amountToMove = Math.min(sourceStack.field_77994_a, maxAmount);
        ItemStack insertedStack = InventoryUtils.copyAndChange(sourceStack, amountToMove);
        IInventory targetInventory = InventoryUtils.getInventory(toInventory);
        ForgeDirection side = direction.getOpposite();
        ItemDistribution.insertItemIntoInventory(targetInventory, insertedStack, side, intoSlot, doMove, canStack);
        int inserted = amountToMove - insertedStack.field_77994_a;
        if (doMove) {
            InventoryUtils.removeFromSlot(fromInventory, fromSlot, inserted);
        }
        return inserted;
    }

    public static int moveItemInto(IInventory fromInventory, int fromSlot, TileEntity te, ForgeDirection intoSide, int maxAmount, boolean doMove) {
        if (te == null) {
            return 0;
        }
        if (te instanceof IInventory) {
            IInventory toInventory = (IInventory)te;
            int moved = ItemDistribution.moveItemInto(fromInventory, fromSlot, toInventory, -1, maxAmount, intoSide, doMove);
            if (moved > 0) {
                toInventory.func_70296_d();
            }
            return moved;
        }
        CustomSinks.ICustomSink adapter = CustomSinks.createSink(te);
        if (adapter != null) {
            return ItemDistribution.moveItemInto(fromInventory, fromSlot, adapter, maxAmount, intoSide, doMove);
        }
        return 0;
    }

    public static boolean insertItemInto(ItemStack stack, TileEntity te, ForgeDirection intoSide, boolean doMove) {
        if (te == null) {
            return false;
        }
        if (te instanceof IInventory) {
            IInventory toInventory = (IInventory)te;
            boolean changed = ItemDistribution.insertItemIntoInventory(toInventory, stack, intoSide, -1, doMove);
            if (changed) {
                toInventory.func_70296_d();
            }
            return changed;
        }
        CustomSinks.ICustomSink adapter = CustomSinks.createSink(te);
        if (adapter != null) {
            return ItemDistribution.insertItemInto(stack, adapter, intoSide, doMove);
        }
        return false;
    }

    public static int moveItemsFromOneOfSides(TileEntity te, IInventory inv, int maxAmount, int intoSlot, Iterable<ForgeDirection> sides, boolean randomize) {
        return ItemDistribution.moveItemsFromOneOfSides(te, inv, null, maxAmount, intoSlot, sides, randomize);
    }

    public static int moveItemsFromOneOfSides(TileEntity te, IInventory inv, ItemStack filterStack, int maxAmount, int intoSlot, Iterable<ForgeDirection> sides, boolean randomize) {
        if (randomize) {
            ArrayList shuffledSides = Lists.newArrayList(sides);
            Collections.shuffle(shuffledSides);
            sides = shuffledSides;
        }
        IInventory ourInventory = InventoryUtils.getInventory(inv);
        for (ForgeDirection dir : sides) {
            TileEntity tileOnSurface = BlockUtils.getTileInDirection(te, dir);
            if (!(tileOnSurface instanceof IInventory)) continue;
            IInventory neighbor = (IInventory)tileOnSurface;
            Set<Integer> slots = filterStack == null ? InventoryUtils.getAllSlots(neighbor) : InventoryUtils.getAllSlotsWithStack(neighbor, filterStack);
            for (Integer slot : slots) {
                int moved = ItemDistribution.moveItemInto(neighbor, slot, ourInventory, intoSlot, maxAmount, dir.getOpposite(), true);
                if (moved <= 0) continue;
                ourInventory.func_70296_d();
                neighbor.func_70296_d();
                return moved;
            }
        }
        return 0;
    }

    public static int moveItemsToOneOfSides(TileEntity te, IInventory inv, int fromSlot, int maxAmount, Iterable<ForgeDirection> sides, boolean randomize) {
        IInventory inventory = InventoryUtils.getInventory(inv);
        if (inventory.func_70301_a(fromSlot) == null) {
            return 0;
        }
        if (randomize) {
            ArrayList shuffledSides = Lists.newArrayList(sides);
            Collections.shuffle(shuffledSides);
            sides = shuffledSides;
        }
        for (ForgeDirection dir : sides) {
            TileEntity tileOnSurface = BlockUtils.getTileInDirection(te, dir);
            int inserted = ItemDistribution.moveItemInto(inventory, fromSlot, tileOnSurface, dir, maxAmount, true);
            if (inserted <= 0) continue;
            return inserted;
        }
        return 0;
    }

    public static ItemStack removeFromFirstNonEmptySlot(IInventory invent) {
        int nextFilledSlot = InventoryUtils.getFirstNonEmptySlot(invent);
        if (nextFilledSlot > -1) {
            ItemStack copy = invent.func_70301_a(nextFilledSlot).func_77946_l();
            invent.func_70299_a(nextFilledSlot, null);
            return copy;
        }
        return null;
    }

    public static int testInventoryInsertion(IInventory inventory, ItemStack item) {
        if (item == null || item.field_77994_a == 0) {
            return 0;
        }
        if (inventory == null) {
            return 0;
        }
        int slotCount = inventory.func_70302_i_();
        int itemSizeCounter = item.field_77994_a;
        for (int i = 0; i < slotCount && itemSizeCounter > 0; ++i) {
            if (!inventory.func_94041_b(i, item)) continue;
            ItemStack inventorySlot = inventory.func_70301_a(i);
            if (inventorySlot == null) {
                itemSizeCounter -= Math.min(Math.min(itemSizeCounter, inventory.func_70297_j_()), item.func_77976_d());
                continue;
            }
            if (!InventoryUtils.areMergeCandidates(item, inventorySlot)) continue;
            int space = inventorySlot.func_77976_d() - inventorySlot.field_77994_a;
            itemSizeCounter -= Math.min(itemSizeCounter, space);
        }
        if (itemSizeCounter != item.field_77994_a) {
            itemSizeCounter = Math.max(itemSizeCounter, 0);
            return item.field_77994_a - itemSizeCounter;
        }
        return 0;
    }

    public static boolean tryInsertStack(IInventory targetInventory, int slot, ItemStack stack, boolean canMerge) {
        if (targetInventory.func_94041_b(slot, stack)) {
            ItemStack targetStack = targetInventory.func_70301_a(slot);
            if (targetStack == null) {
                int limit = targetInventory.func_70297_j_();
                if (limit < stack.field_77994_a) {
                    targetInventory.func_70299_a(slot, stack.func_77979_a(limit));
                } else {
                    targetInventory.func_70299_a(slot, stack.func_77946_l());
                    stack.field_77994_a = 0;
                }
                return true;
            }
            if (canMerge && targetInventory.func_94041_b(slot, stack) && InventoryUtils.areMergeCandidates(stack, targetStack)) {
                int space = targetStack.func_77976_d() - targetStack.field_77994_a;
                int mergeAmount = Math.min(space, stack.field_77994_a);
                ItemStack copy = targetStack.func_77946_l();
                copy.field_77994_a += mergeAmount;
                targetInventory.func_70299_a(slot, copy);
                stack.field_77994_a -= mergeAmount;
                return true;
            }
        }
        return false;
    }
}

