/*
 * Decompiled with CFR 0.152.
 */
package openmods.infobook;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.Maps;
import cpw.mods.fml.common.registry.FMLControlledNamespacedRegistry;
import cpw.mods.fml.common.registry.GameData;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import openmods.gui.component.BaseComponent;
import openmods.gui.component.GuiComponentBook;
import openmods.gui.component.page.StandardRecipePage;
import openmods.infobook.BookDocumentation;
import openmods.infobook.ICustomBookEntryProvider;

public class PageBuilder {
    private static final Map<Class<? extends ICustomBookEntryProvider>, ICustomBookEntryProvider> PROVIDERS = Maps.newHashMap();
    private final SortedMap<String, BaseComponent> pages = Maps.newTreeMap();

    private static ICustomBookEntryProvider getProvider(Class<? extends ICustomBookEntryProvider> cls) {
        ICustomBookEntryProvider provider = PROVIDERS.get(cls);
        if (provider == null) {
            try {
                provider = cls.newInstance();
            }
            catch (Throwable t) {
                throw Throwables.propagate((Throwable)t);
            }
            PROVIDERS.put(cls, provider);
        }
        return provider;
    }

    public <T> void addPages(String modId, String type, FMLControlledNamespacedRegistry<T> registry, StackProvider<T> provider) {
        Set ids = registry.func_148742_b();
        Splitter splitter = Splitter.on((char)':');
        for (String id : ids) {
            BookDocumentation doc;
            Object obj = registry.func_82594_a(id);
            if (obj == null || (doc = obj.getClass().getAnnotation(BookDocumentation.class)) == null) continue;
            Iterator components = splitter.split((CharSequence)id).iterator();
            String itemModId = (String)components.next();
            String itemName = (String)components.next();
            Class<? extends ICustomBookEntryProvider> customProviderCls = doc.customProvider();
            if (customProviderCls == BookDocumentation.EMPTY.class) {
                ItemStack stack = provider.createStack(itemModId, itemName, obj);
                if (stack == null) continue;
                String customName = doc.customName();
                this.addPage(Strings.isNullOrEmpty((String)customName) ? itemName : customName, itemModId.toLowerCase(), type, stack);
                continue;
            }
            ICustomBookEntryProvider customProvider = PageBuilder.getProvider(customProviderCls);
            for (ICustomBookEntryProvider.Entry e : customProvider.getBookEntries()) {
                this.addPage(e.name, itemModId.toLowerCase(), type, e.stack);
            }
        }
    }

    public void addPages(GuiComponentBook book) {
        for (BaseComponent page : this.pages.values()) {
            book.addPage(page);
        }
        this.pages.clear();
    }

    private void addPage(String id, String modId, String type, ItemStack stack) {
        String nameKey = this.getTranslationKey(id, modId, type, "name");
        String descriptionKey = this.getTranslationKey(id, modId, type, "description");
        String mediaKey = this.getTranslationKey(id, modId, type, "video");
        String translatedName = StatCollector.func_74838_a((String)nameKey);
        this.pages.put(translatedName + ":" + id, new StandardRecipePage(nameKey, descriptionKey, mediaKey, stack));
    }

    protected String getTranslationKey(String name, String modId, String type, String category) {
        return String.format("%s.%s.%s.%s", type, modId, name, category);
    }

    public void addItemPages(String modId, StackProvider<Item> provider) {
        this.addPages(modId, "item", GameData.getItemRegistry(), provider);
    }

    public void addItemPages(final String modId) {
        this.addItemPages(modId, new StackProvider<Item>(){

            @Override
            public ItemStack createStack(String itemModId, String itemName, Item item) {
                return modId.equals(itemModId) ? new ItemStack(item) : null;
            }
        });
    }

    public void addBlockPages(String modId, StackProvider<Block> provider) {
        this.addPages(modId, "tile", GameData.getBlockRegistry(), provider);
    }

    public void addBlockPages(final String modId) {
        this.addBlockPages(modId, new StackProvider<Block>(){

            @Override
            public ItemStack createStack(String blockModId, String blockName, Block block) {
                return modId.equals(blockModId) ? new ItemStack(block) : null;
            }
        });
    }

    public static interface StackProvider<T> {
        public ItemStack createStack(String var1, String var2, T var3);
    }
}

