/*
 * Decompiled with CFR 0.152.
 */
package openmods.config.simple;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import openmods.Log;

public class ConfigProcessor {
    private Map<String, EntryMeta> entries = Maps.newHashMap();

    public void addEntry(String name, int version, String defaultValue, UpdateListener listener, String ... comment) {
        Preconditions.checkNotNull((Object)listener);
        this.addEntry(name, new EntryMeta(defaultValue, version, listener, comment));
    }

    public void addEntry(String name, int version, String defaultValue, UpdateListener listener) {
        Preconditions.checkNotNull((Object)listener);
        this.addEntry(name, new EntryMeta(defaultValue, version, listener));
    }

    private void addEntry(String name, EntryMeta meta) {
        EntryMeta prev = this.entries.put(name, meta);
        Preconditions.checkState((prev == null ? 1 : 0) != 0, (String)"Duplicate property '%s': [%s, %s]", (Object[])new Object[]{name, prev, meta});
    }

    public void process(File config) {
        Sets.SetView added;
        boolean modified = false;
        Log.info("Parsing config file '%s'", config);
        HashMap values = ConfigProcessor.readFile(config);
        if (values == null) {
            values = Maps.newHashMap();
        }
        for (String key : Sets.intersection(values.keySet(), this.entries.keySet())) {
            EntryMeta defaultEntry = this.entries.get(key);
            EntryMeta actualEntry = (EntryMeta)values.get(key);
            if (defaultEntry.version > actualEntry.version) {
                Log.warn("Config value '%s' replaced with newer version", key);
                values.put(key, defaultEntry);
                modified = true;
                continue;
            }
            if (!Arrays.equals(defaultEntry.comment, actualEntry.comment)) {
                actualEntry.comment = defaultEntry.comment;
                modified = true;
            }
            defaultEntry.listener.valueSet(actualEntry.value);
        }
        Sets.SetView removed = Sets.difference(values.keySet(), this.entries.keySet());
        if (!removed.isEmpty()) {
            Log.warn("Removing obsolete values: '%s'", removed);
            modified = true;
            for (String key : ImmutableSet.copyOf((Collection)removed)) {
                values.remove(key);
            }
        }
        if (!(added = Sets.difference(this.entries.keySet(), values.keySet())).isEmpty()) {
            Log.warn("Adding new values: '%s'", added);
            modified = true;
            for (String key : added) {
                EntryMeta entry = this.entries.get(key);
                values.put(key, entry);
                entry.listener.valueSet(entry.value);
            }
        }
        if (modified) {
            ConfigProcessor.writeFile(config, values);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeFile(File output, Map<String, EntryMeta> values) {
        try {
            FileOutputStream stream = new FileOutputStream(output);
            try {
                OutputStreamWriter writer = new OutputStreamWriter((OutputStream)stream, Charsets.UTF_8);
                try {
                    Gson gson = new GsonBuilder().setPrettyPrinting().create();
                    gson.toJson(values, (Appendable)writer);
                }
                finally {
                    ((Writer)writer).close();
                }
            }
            finally {
                ((OutputStream)stream).close();
            }
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, EntryMeta> readFile(File input) {
        Map map;
        if (!input.exists()) {
            return null;
        }
        FileInputStream stream = new FileInputStream(input);
        try {
            InputStreamReader reader = new InputStreamReader((InputStream)stream, Charsets.UTF_8);
            Gson gson = new Gson();
            map = (Map)gson.fromJson((Reader)reader, EntryCollection.class);
        }
        catch (Throwable throwable) {
            try {
                ((InputStream)stream).close();
                throw throwable;
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
        ((InputStream)stream).close();
        return map;
    }

    private static class EntryCollection
    extends HashMap<String, EntryMeta> {
        private static final long serialVersionUID = -3851628207393131247L;

        private EntryCollection() {
        }
    }

    private static class EntryMeta {
        public final int version;
        public final String value;
        public String[] comment;
        public final transient UpdateListener listener;

        public EntryMeta(String value, int version, UpdateListener listener) {
            this.version = version;
            this.value = value;
            this.listener = listener;
            this.comment = null;
        }

        public EntryMeta(String value, int version, UpdateListener listener, String ... comment) {
            this.version = version;
            this.value = value;
            this.listener = listener;
            this.comment = comment;
        }

        public String toString() {
            return "[value=" + this.value + ", version=" + this.version + ", comment=" + Arrays.toString(this.comment) + "]";
        }
    }

    public static interface UpdateListener {
        public void valueSet(String var1);
    }
}

