/*
 * Decompiled with CFR 0.152.
 */
package openmods.block;

import com.google.common.collect.Lists;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import openmods.Log;
import openmods.api.IActivateAwareTile;
import openmods.api.IBreakAwareTile;
import openmods.api.ICustomBreakDrops;
import openmods.api.ICustomHarvestDrops;
import openmods.api.IHasGui;
import openmods.api.IIconProvider;
import openmods.api.INeighbourAwareTile;
import openmods.api.IPlaceAwareTile;
import openmods.api.ISurfaceAttachment;
import openmods.block.BlockRotationMode;
import openmods.block.RotationAxis;
import openmods.block.RotationHelper;
import openmods.config.game.IRegisterableBlock;
import openmods.context.ContextManager;
import openmods.context.VariableKey;
import openmods.tileentity.OpenTileEntity;
import openmods.utils.BlockUtils;

public abstract class OpenBlock
extends Block
implements IRegisterableBlock {
    public static final int OPEN_MODS_TE_GUI = -1;
    private static final VariableKey<ArrayList<ItemStack>> DROP_OVERRIDE = VariableKey.create();
    private String blockName;
    private String modId;
    private Class<? extends TileEntity> teClass = null;
    protected BlockRotationMode blockRotationMode = BlockRotationMode.NONE;
    protected BlockPlacementMode blockPlacementMode = BlockPlacementMode.ENTITY_ANGLE;
    protected ForgeDirection inventoryRenderRotation = ForgeDirection.WEST;
    protected RenderMode renderMode = RenderMode.BLOCK_ONLY;
    public IIcon[] textures = new IIcon[6];

    protected OpenBlock(Material material) {
        super(material);
        this.func_149711_c(1.0f);
        this.field_149758_A = false;
    }

    protected void setPlacementMode(BlockPlacementMode mode) {
        this.blockPlacementMode = mode;
    }

    protected void setRotationMode(BlockRotationMode mode) {
        this.blockRotationMode = mode;
    }

    public BlockRotationMode getRotationMode() {
        return this.blockRotationMode;
    }

    protected BlockPlacementMode getPlacementMode() {
        return this.blockPlacementMode;
    }

    protected void setInventoryRenderRotation(ForgeDirection rotation) {
        this.inventoryRenderRotation = rotation;
    }

    protected void setRenderMode(RenderMode renderMode) {
        this.renderMode = renderMode;
    }

    public ForgeDirection getRotation(int metadata) {
        return this.blockRotationMode.fromValue(metadata & this.blockRotationMode.mask);
    }

    @SideOnly(value=Side.CLIENT)
    public ForgeDirection getInventoryRenderRotation() {
        return this.inventoryRenderRotation;
    }

    public boolean shouldDropFromTeAfterBreak() {
        return true;
    }

    public boolean shouldOverrideHarvestWithTeLogic() {
        return false;
    }

    public void setBoundsBasedOnRotation(ForgeDirection direction) {
    }

    public static OpenBlock getOpenBlock(IBlockAccess world, int x, int y, int z) {
        if (world == null) {
            return null;
        }
        Block block = world.func_147439_a(x, y, z);
        if (block instanceof OpenBlock) {
            return (OpenBlock)block;
        }
        return null;
    }

    public TileEntity createTileEntity(World world, int metadata) {
        TileEntity te = this.createTileEntity();
        te.field_145854_h = this;
        if (te instanceof OpenTileEntity) {
            ((OpenTileEntity)te).setup();
        }
        return te;
    }

    public TileEntity createTileEntityForRender() {
        TileEntity te = this.createTileEntity();
        te.field_145854_h = this;
        te.field_145847_g = 0;
        return te;
    }

    protected TileEntity createTileEntity() {
        try {
            if (this.teClass != null) {
                return this.teClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
        }
        catch (NoSuchMethodException nsm) {
            Log.warn(nsm, "Notice: Cannot create TE automatically due to constructor requirements", new Object[0]);
        }
        catch (Exception ex) {
            Log.warn(ex, "Notice: Error creating tile entity", new Object[0]);
        }
        return null;
    }

    public Class<? extends TileEntity> getTileClass() {
        return this.teClass;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister registry) {
        this.field_149761_L = registry.func_94245_a(String.format("%s:%s", this.modId, this.blockName));
    }

    private static List<ItemStack> getTileBreakDrops(TileEntity te) {
        ArrayList breakDrops = Lists.newArrayList();
        BlockUtils.getTileInventoryDrops(te, breakDrops);
        if (te instanceof ICustomBreakDrops) {
            ((ICustomBreakDrops)te).addDrops(breakDrops);
        }
        return breakDrops;
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        TileEntity te;
        if (this.shouldDropFromTeAfterBreak() && (te = world.func_147438_o(x, y, z)) != null) {
            if (te instanceof IBreakAwareTile) {
                ((IBreakAwareTile)te).onBlockBroken();
            }
            for (ItemStack stack : OpenBlock.getTileBreakDrops(te)) {
                BlockUtils.dropItemStackInWorld(world, x, y, z, stack);
            }
            world.func_147475_p(x, y, z);
        }
        super.func_149749_a(world, x, y, z, block, meta);
    }

    protected ArrayList<ItemStack> getDropsWithTileEntity(World world, EntityPlayer player, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof ICustomHarvestDrops) {
            ArrayList drops;
            ICustomHarvestDrops dropper = (ICustomHarvestDrops)te;
            if (!dropper.suppressNormalHarvestDrops()) {
                int metadata = world.func_72805_g(x, y, z);
                int fortune = EnchantmentHelper.func_77517_e((EntityLivingBase)player);
                drops = super.getDrops(world, x, y, z, metadata, fortune);
            } else {
                drops = Lists.newArrayList();
            }
            dropper.addHarvestDrops(player, drops);
            return drops;
        }
        return null;
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z, boolean willHarvest) {
        ArrayList<ItemStack> drops;
        if (willHarvest && this.shouldOverrideHarvestWithTeLogic() && (drops = this.getDropsWithTileEntity(world, player, x, y, z)) != null) {
            ContextManager.set(DROP_OVERRIDE, drops);
        }
        return super.removedByPlayer(world, player, x, y, z, willHarvest);
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> result = ContextManager.remove(DROP_OVERRIDE);
        if (result != null) {
            return result;
        }
        result = this.getDropsWithTileEntity(world, null, x, y, z);
        if (result != null) {
            return result;
        }
        return super.getDrops(world, x, y, z, metadata, fortune);
    }

    @Override
    public void setupBlock(String modId, String blockName, Class<? extends TileEntity> tileEntity, Class<? extends ItemBlock> itemClass) {
        this.blockName = blockName;
        this.modId = modId;
        if (tileEntity != null) {
            this.teClass = tileEntity;
            this.field_149758_A = true;
        }
    }

    public boolean hasTileEntity(int metadata) {
        return this.teClass != null;
    }

    public static final boolean isNeighborBlockSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        return world.isSideSolid(x += side.offsetX, y += side.offsetY, z += side.offsetZ, side.getOpposite(), false);
    }

    public static final boolean areNeighborBlocksSolid(World world, int x, int y, int z, ForgeDirection ... sides) {
        for (ForgeDirection side : sides) {
            if (!OpenBlock.isNeighborBlockSolid((IBlockAccess)world, x, y, z, side)) continue;
            return true;
        }
        return false;
    }

    public void func_149695_a(World world, int x, int y, int z, Block neighbour) {
        ForgeDirection direction;
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof INeighbourAwareTile) {
            ((INeighbourAwareTile)te).onNeighbourChanged(neighbour);
        }
        if (te instanceof ISurfaceAttachment && !OpenBlock.isNeighborBlockSolid((IBlockAccess)world, x, y, z, direction = ((ISurfaceAttachment)te).getSurfaceDirection())) {
            world.func_147480_a(x, y, z, true);
        }
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof IHasGui && ((IHasGui)te).canOpenGui(player) && !player.func_70093_af()) {
            if (!world.field_72995_K) {
                this.openGui(player, world, x, y, z);
            }
            return true;
        }
        if (te instanceof IActivateAwareTile) {
            return ((IActivateAwareTile)te).onBlockActivated(player, side, hitX, hitY, hitZ);
        }
        return false;
    }

    public boolean func_149686_d() {
        return this.func_149662_c();
    }

    public boolean func_149696_a(World world, int x, int y, int z, int eventId, int eventParam) {
        super.func_149696_a(world, x, y, z, eventId, eventParam);
        TileEntity te = OpenBlock.getTileEntity((IBlockAccess)world, x, y, z, TileEntity.class);
        if (te != null) {
            return te.func_145842_c(eventId, eventParam);
        }
        return false;
    }

    protected void setupDimensionsFromCenter(float x, float y, float z, float width, float height, float depth) {
        this.setupDimensions(x - width, y, z - depth, x + width, y + height, z + depth);
    }

    protected void setupDimensions(float minX, float minY, float minZ, float maxX, float maxY, float maxZ) {
        this.field_149759_B = minX;
        this.field_149760_C = minY;
        this.field_149754_D = minZ;
        this.field_149755_E = maxX;
        this.field_149756_F = maxY;
        this.field_149757_G = maxZ;
    }

    public AxisAlignedBB func_149633_g(World world, int x, int y, int z) {
        this.func_149719_a((IBlockAccess)world, x, y, z);
        return super.func_149633_g(world, x, y, z);
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        this.func_149719_a((IBlockAccess)world, x, y, z);
        return super.func_149668_a(world, x, y, z);
    }

    public static <U> U getTileEntity(IBlockAccess world, int x, int y, int z, Class<U> T) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te != null && T.isAssignableFrom(te.getClass())) {
            return (U)te;
        }
        return null;
    }

    public boolean canPlaceBlock(World world, EntityPlayer player, ItemStack stack, int x, int y, int z, ForgeDirection sideDir, ForgeDirection blockDirection, float hitX, float hitY, float hitZ, int newMeta) {
        return this.blockRotationMode.isValid(blockDirection);
    }

    public void afterBlockPlaced(World world, EntityPlayer player, ItemStack stack, int x, int y, int z, ForgeDirection side, ForgeDirection blockDir, float hitX, float hitY, float hitZ, int itemMeta) {
        int blockMeta = this.blockRotationMode.toValue(blockDir);
        world.func_72921_c(x, y, z, blockMeta, 0);
        this.notifyTileEntity(world, player, stack, x, y, z, side, hitX, hitY, hitZ);
        world.func_147471_g(x, y, z);
        if (!world.field_72995_K) {
            world.func_147444_c(x, y, z, (Block)this);
        }
    }

    protected void notifyTileEntity(World world, EntityPlayer player, ItemStack stack, int x, int y, int z, ForgeDirection side, float hitX, float hitY, float hitZ) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof IPlaceAwareTile) {
            ((IPlaceAwareTile)te).onBlockPlacedBy(player, side, stack, hitX, hitY, hitZ);
        }
    }

    protected void setRotationMeta(World world, int x, int y, int z, ForgeDirection blockDir) {
        int blockMeta = this.blockRotationMode.toValue(blockDir);
        world.func_72921_c(x, y, z, blockMeta, 3);
    }

    public ForgeDirection calculateSide(EntityPlayer player, ForgeDirection side) {
        if (this.blockPlacementMode == BlockPlacementMode.SURFACE) {
            return side.getOpposite();
        }
        switch (this.getRotationMode()) {
            case TWO_DIRECTIONS: {
                ForgeDirection normalDir = BlockUtils.get2dOrientation((EntityLivingBase)player);
                switch (normalDir) {
                    case EAST: 
                    case WEST: {
                        return ForgeDirection.WEST;
                    }
                }
                return ForgeDirection.NORTH;
            }
            case FOUR_DIRECTIONS: {
                return BlockUtils.get2dOrientation((EntityLivingBase)player);
            }
            case SIX_DIRECTIONS: {
                return BlockUtils.get3dOrientation((EntityLivingBase)player);
            }
        }
        return ForgeDirection.UNKNOWN;
    }

    public final boolean func_149707_d(World world, int x, int y, int z, int side) {
        return this.canPlaceBlockOnSide(world, x, y, z, ForgeDirection.getOrientation((int)side).getOpposite());
    }

    public boolean canPlaceBlockOnSide(World world, int x, int y, int z, ForgeDirection side) {
        return this.func_149742_c(world, x, y, z);
    }

    protected boolean isOnTopOfSolidBlock(World world, int x, int y, int z, ForgeDirection side) {
        return side == ForgeDirection.DOWN && OpenBlock.isNeighborBlockSolid((IBlockAccess)world, x, y, z, ForgeDirection.DOWN);
    }

    public void setTexture(ForgeDirection direction, IIcon icon) {
        this.textures[direction.ordinal()] = icon;
    }

    protected IIcon getUnrotatedTexture(ForgeDirection direction) {
        int directionId;
        if (direction != ForgeDirection.UNKNOWN && this.textures[directionId = direction.ordinal()] != null) {
            return this.textures[directionId];
        }
        return this.field_149761_L;
    }

    public IIcon getUnrotatedTexture(ForgeDirection direction, IBlockAccess world, int x, int y, int z) {
        return this.getUnrotatedTexture(direction);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        ForgeDirection direction = this.rotateSideByMetadata(side, world.func_72805_g(x, y, z));
        IIconProvider provider = OpenBlock.getTileEntity(world, x, y, z, IIconProvider.class);
        IIcon teIcon = null;
        if (provider != null) {
            teIcon = provider.getIcon(direction);
        }
        return teIcon != null ? teIcon : this.getUnrotatedTexture(direction, world, x, y, z);
    }

    @SideOnly(value=Side.CLIENT)
    public final IIcon func_149691_a(int side, int metadata) {
        ForgeDirection newRotation = this.rotateSideByMetadata(side, metadata);
        return this.getUnrotatedTexture(newRotation);
    }

    public ForgeDirection rotateSideByMetadata(int side, int metadata) {
        ForgeDirection rotation = ForgeDirection.getOrientation((int)metadata);
        ForgeDirection dir = ForgeDirection.getOrientation((int)side);
        switch (this.getRotationMode()) {
            case FOUR_DIRECTIONS: 
            case NONE: {
                switch (rotation) {
                    case EAST: {
                        dir = dir.getRotation(ForgeDirection.DOWN);
                        break;
                    }
                    case SOUTH: {
                        dir = dir.getRotation(ForgeDirection.UP);
                        dir = dir.getRotation(ForgeDirection.UP);
                        break;
                    }
                    case WEST: {
                        dir = dir.getRotation(ForgeDirection.UP);
                        break;
                    }
                }
                return dir;
            }
        }
        switch (rotation) {
            case DOWN: {
                dir = dir.getRotation(ForgeDirection.SOUTH);
                dir = dir.getRotation(ForgeDirection.SOUTH);
                break;
            }
            case EAST: {
                dir = dir.getRotation(ForgeDirection.NORTH);
                break;
            }
            case NORTH: {
                dir = dir.getRotation(ForgeDirection.WEST);
                break;
            }
            case SOUTH: {
                dir = dir.getRotation(ForgeDirection.EAST);
                break;
            }
            case WEST: {
                dir = dir.getRotation(ForgeDirection.SOUTH);
                break;
            }
        }
        return dir;
    }

    public void setDefaultTexture(IIcon icon) {
        this.field_149761_L = icon;
    }

    protected abstract Object getModInstance();

    public void openGui(EntityPlayer player, World world, int x, int y, int z) {
        player.openGui(this.getModInstance(), -1, world, x, y, z);
    }

    public final boolean shouldRenderBlock() {
        return this.renderMode != RenderMode.TESR_ONLY;
    }

    public final boolean shouldRenderTesrInInventory() {
        return this.renderMode != RenderMode.BLOCK_ONLY;
    }

    public boolean canRotateWithTool() {
        return true;
    }

    public boolean rotateBlock(World worldObj, int x, int y, int z, ForgeDirection axis) {
        return this.canRotateWithTool() && RotationHelper.rotate(this.blockRotationMode, worldObj, x, y, z, axis);
    }

    public ForgeDirection[] getValidRotations(World worldObj, int x, int y, int z) {
        if (!this.canRotateWithTool()) {
            return RotationAxis.NO_AXIS;
        }
        return this.blockRotationMode.rotations;
    }

    public static enum RenderMode {
        TESR_ONLY,
        BLOCK_ONLY,
        BOTH;

    }

    public static enum BlockPlacementMode {
        ENTITY_ANGLE,
        SURFACE;

    }
}

