/*
 * Decompiled with CFR 0.152.
 */
package com.nauktis.solarflux.blocks;

import cofh.api.energy.IEnergyHandler;
import cofh.api.energy.IEnergyStorage;
import com.google.common.base.Objects;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public class StatefulEnergyStorage
implements IEnergyStorage {
    public static final String NBT_ENERGY = "SFESEnergy";
    protected static final String NBT_CAPACITY = "SFESCapacity";
    protected static final String NBT_MAX_TRANSFER_RECEIVE = "SFESMaxTransferReceive";
    protected static final String NBT_MAX_TRANSFER_EXTRACT = "SFESMaxTransferExtract";
    protected int mEnergy;
    protected int mCapacity;
    protected int mMaxTransferReceive;
    protected int mMaxTransferExtract;

    public StatefulEnergyStorage(int pCapacity) {
        this(pCapacity, pCapacity, pCapacity);
    }

    public StatefulEnergyStorage(int pCapacity, int pMaxTransfer) {
        this(pCapacity, pMaxTransfer, pMaxTransfer);
    }

    public StatefulEnergyStorage(int pCapacity, int pMaxTransferReceive, int pMaxTransferExtract) {
        this.mCapacity = pCapacity;
        this.mMaxTransferReceive = pMaxTransferReceive;
        this.mMaxTransferExtract = pMaxTransferExtract;
    }

    public void readFromNBT(NBTTagCompound pNbt) {
        this.setMaxEnergyStored(pNbt.func_74762_e(NBT_CAPACITY));
        this.setEnergyStored(pNbt.func_74762_e(NBT_ENERGY));
        this.setMaxTransferReceive(pNbt.func_74762_e(NBT_MAX_TRANSFER_RECEIVE));
        this.setMaxTransferExtract(pNbt.func_74762_e(NBT_MAX_TRANSFER_EXTRACT));
    }

    public void writeToNBT(NBTTagCompound pNbt) {
        pNbt.func_74768_a(NBT_CAPACITY, this.getMaxEnergyStored());
        pNbt.func_74768_a(NBT_ENERGY, this.getEnergyStored());
        pNbt.func_74768_a(NBT_MAX_TRANSFER_RECEIVE, this.getMaxTransferReceive());
        pNbt.func_74768_a(NBT_MAX_TRANSFER_EXTRACT, this.getMaxTransferExtract());
    }

    public int getMaxReceive() {
        return Math.min(this.mCapacity - this.mEnergy, this.mMaxTransferReceive);
    }

    public int getMaxExtract() {
        return Math.min(this.mEnergy, this.mMaxTransferExtract);
    }

    public int receiveEnergy(int pMaxReceive, boolean pSimulate) {
        int energyReceived = Math.min(this.getMaxReceive(), Math.max(pMaxReceive, 0));
        if (!pSimulate) {
            this.mEnergy += energyReceived;
        }
        return energyReceived;
    }

    public int extractEnergy(int pMaxExtract, boolean pSimulate) {
        int energyExtracted = Math.min(this.getMaxExtract(), Math.max(pMaxExtract, 0));
        if (!pSimulate) {
            this.mEnergy -= energyExtracted;
        }
        return energyExtracted;
    }

    public int sendMaxTo(IEnergyHandler pEnergyHandler, ForgeDirection pFrom) {
        return this.extractEnergy(pEnergyHandler.receiveEnergy(pFrom, this.getMaxExtract(), false), false);
    }

    public int autoBalanceEnergy(StatefulEnergyStorage pOtherEnergyStorage) {
        int delta = this.getEnergyStored() - pOtherEnergyStorage.getEnergyStored();
        if (delta < 0) {
            return pOtherEnergyStorage.autoBalanceEnergy(this);
        }
        if (delta > 0 && !pOtherEnergyStorage.isFull()) {
            return this.extractEnergy(pOtherEnergyStorage.receiveEnergy(delta / 2, false), false);
        }
        return 0;
    }

    public int autoBalanceEnergy(StatefulEnergyStorage pOtherEnergyStorage, int pTransferSpeed) {
        this.mMaxTransferExtract *= pTransferSpeed;
        this.mMaxTransferReceive *= pTransferSpeed;
        pOtherEnergyStorage.mMaxTransferExtract *= pTransferSpeed;
        pOtherEnergyStorage.mMaxTransferReceive *= pTransferSpeed;
        int result = this.autoBalanceEnergy(pOtherEnergyStorage);
        this.mMaxTransferExtract /= pTransferSpeed;
        this.mMaxTransferReceive /= pTransferSpeed;
        pOtherEnergyStorage.mMaxTransferExtract /= pTransferSpeed;
        pOtherEnergyStorage.mMaxTransferReceive /= pTransferSpeed;
        return result;
    }

    public int getEnergyStored() {
        return this.mEnergy;
    }

    public void setEnergyStored(int pEnergy) {
        this.mEnergy = pEnergy;
        if (this.mEnergy > this.mCapacity) {
            this.mEnergy = this.mCapacity;
        } else if (this.mEnergy < 0) {
            this.mEnergy = 0;
        }
    }

    public int getMaxEnergyStored() {
        return this.mCapacity;
    }

    public void setMaxEnergyStored(int pCapacity) {
        this.mCapacity = pCapacity;
        if (this.mEnergy > this.mCapacity) {
            this.mEnergy = this.mCapacity;
        }
    }

    public boolean isFull() {
        return this.getEnergyStored() == this.getMaxEnergyStored();
    }

    public int getMaxTransferReceive() {
        return this.mMaxTransferReceive;
    }

    public void setMaxTransferReceive(int pMaxTransferReceive) {
        this.mMaxTransferReceive = pMaxTransferReceive;
    }

    public int getMaxTransferExtract() {
        return this.mMaxTransferExtract;
    }

    public void setMaxTransferExtract(int pMaxTransferExtract) {
        this.mMaxTransferExtract = pMaxTransferExtract;
    }

    public void setMaxTransfer(int pMaxTransfer) {
        this.setMaxTransferReceive(pMaxTransfer);
        this.setMaxTransferExtract(pMaxTransfer);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("energy", this.getEnergyStored()).add("capacity", this.getMaxEnergyStored()).add("maxTransferReceive", this.getMaxTransferReceive()).add("maxTransferExtract", this.getMaxTransferExtract()).toString();
    }
}

