/*
 * Decompiled with CFR 0.152.
 */
package com.nauktis.solarflux.blocks;

import cofh.api.energy.IEnergyHandler;
import com.google.common.base.Objects;
import com.nauktis.core.tileentity.BaseModTileEntity;
import com.nauktis.solarflux.blocks.StatefulEnergyStorage;
import com.nauktis.solarflux.config.ModConfiguration;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraftforge.common.util.ForgeDirection;

public class SolarPanelTileEntity
extends BaseModTileEntity
implements IEnergyHandler {
    private static final String NBT_MAXIMUM_ENERGY_GENERATION = "SFMaximumEnergyGeneration";
    private static final int DISTRIBUTION_TICK_RATE = 100;
    private StatefulEnergyStorage mEnergyStorage;
    private int mMaximumEnergyGeneration;

    public SolarPanelTileEntity() {
        this(0, 0, 0);
    }

    public SolarPanelTileEntity(int pMaximumEnergyGeneration, int pMaximumEnergyTransfer, int pCapacity) {
        this.mMaximumEnergyGeneration = pMaximumEnergyGeneration;
        this.mEnergyStorage = new StatefulEnergyStorage(pCapacity, pMaximumEnergyTransfer);
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (this.isServer()) {
            this.generateEnergy();
            if (this.shouldTransferEnergy()) {
                this.transferEnergy();
            }
            if (this.shouldAutoBalanceEnergy()) {
                this.tryAutoBalanceEnergyAt(this.x() + 1, this.y(), this.z());
                this.tryAutoBalanceEnergyAt(this.x(), this.y(), this.z() + 1);
            }
        }
    }

    private void tryAutoBalanceEnergyAt(int pX, int pY, int pZ) {
        TileEntity tile = this.func_145831_w().func_147438_o(pX, pY, pZ);
        if (tile instanceof SolarPanelTileEntity) {
            SolarPanelTileEntity neighbor = (SolarPanelTileEntity)tile;
            this.mEnergyStorage.autoBalanceEnergy(neighbor.mEnergyStorage, 100);
        }
    }

    private boolean shouldAutoBalanceEnergy() {
        return ModConfiguration.doesAutoBalanceEnergy() && this.func_145831_w().func_82737_E() % 100L == 0L;
    }

    public int getEnergyProduced() {
        int sunProduction;
        if (this.field_145850_b.func_72937_j(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e) && (sunProduction = this.getSunProduction()) > 0) {
            if (this.field_145850_b.func_72896_J()) {
                sunProduction = (int)((float)sunProduction * ModConfiguration.getRainGenerationFactor());
            }
            if (this.field_145850_b.func_72911_I()) {
                sunProduction = (int)((float)sunProduction * ModConfiguration.getThunderGenerationFactor());
            }
            return Math.min(this.mMaximumEnergyGeneration, sunProduction);
        }
        return 0;
    }

    private int getSunProduction() {
        float multiplicator = 1.5f;
        float displacement = 1.2f;
        float celestialAngleRadians = this.field_145850_b.func_72929_e(1.0f);
        if ((double)celestialAngleRadians > Math.PI) {
            celestialAngleRadians = 6.283184f - celestialAngleRadians;
        }
        return Math.round((float)this.mMaximumEnergyGeneration * multiplicator * MathHelper.func_76134_b((float)(celestialAngleRadians / displacement)));
    }

    protected void generateEnergy() {
        int produced = this.getEnergyProduced();
        if (produced > 0) {
            this.mEnergyStorage.receiveEnergy(produced, false);
        }
    }

    protected boolean shouldTransferEnergy() {
        return this.mEnergyStorage.getEnergyStored() > 0;
    }

    protected void transferEnergy() {
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity tile = this.func_145831_w().func_147438_o(this.field_145851_c + direction.offsetX, this.field_145848_d + direction.offsetY, this.field_145849_e + direction.offsetZ);
            if (tile instanceof SolarPanelTileEntity || !(tile instanceof IEnergyHandler)) continue;
            IEnergyHandler receiver = (IEnergyHandler)tile;
            this.mEnergyStorage.sendMaxTo(receiver, direction.getOpposite());
        }
    }

    @Override
    protected void loadDataFromNBT(NBTTagCompound pNBT) {
        super.loadDataFromNBT(pNBT);
        this.mMaximumEnergyGeneration = pNBT.func_74762_e(NBT_MAXIMUM_ENERGY_GENERATION);
        this.mEnergyStorage.readFromNBT(pNBT);
    }

    @Override
    protected void addDataToNBT(NBTTagCompound pNBT) {
        super.addDataToNBT(pNBT);
        pNBT.func_74768_a(NBT_MAXIMUM_ENERGY_GENERATION, this.mMaximumEnergyGeneration);
        this.mEnergyStorage.writeToNBT(pNBT);
    }

    public boolean canConnectEnergy(ForgeDirection pFrom) {
        return pFrom != ForgeDirection.UP;
    }

    public int receiveEnergy(ForgeDirection pFrom, int pMaxReceive, boolean pSimulate) {
        return 0;
    }

    public int extractEnergy(ForgeDirection pFrom, int pMaxExtract, boolean pSimulate) {
        return this.mEnergyStorage.extractEnergy(this.mEnergyStorage.getMaxExtract(), pSimulate);
    }

    public int getEnergyStored() {
        return this.getEnergyStored(ForgeDirection.DOWN);
    }

    public void setEnergyStored(int pEnergy) {
        this.mEnergyStorage.setEnergyStored(pEnergy);
    }

    public int getPercentageEnergyStored() {
        long v = this.getEnergyStored();
        return (int)(100L * v / (long)this.getMaxEnergyStored());
    }

    public int getEnergyStored(ForgeDirection pFrom) {
        return this.mEnergyStorage.getEnergyStored();
    }

    public int getMaxEnergyStored() {
        return this.getMaxEnergyStored(ForgeDirection.DOWN);
    }

    public int getMaxEnergyStored(ForgeDirection pFrom) {
        return this.mEnergyStorage.getMaxEnergyStored();
    }

    public String toString() {
        return Objects.toStringHelper((Object)((Object)this)).add("hash", ((Object)((Object)this)).hashCode()).add("MaxProduction", this.mMaximumEnergyGeneration).add("energyStorage", (Object)this.mEnergyStorage).toString();
    }
}

