/*
 * Decompiled with CFR 0.152.
 */
package org.github.trainerguy22.jtoml.impl;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.github.trainerguy22.jtoml.TomlWriter;

public class SimpleTomlWriter
implements TomlWriter {
    private File file;

    public SimpleTomlWriter(File file) {
        this.file = file;
    }

    @Override
    public void write(Map<String, Object> config) throws IOException {
        this.file.createNewFile();
        StringBuilder builder = new StringBuilder();
        builder.append("# Autogenerated by jTOML.\n\n");
        for (String key : config.keySet()) {
            Object result = config.get(key);
            if (result instanceof Map) {
                builder.append("[" + key + "]\n");
                Map map = (Map)result;
                for (String key1 : map.keySet()) {
                    Object result1 = map.get(key1);
                    builder.append(key1 + " = " + this.parse(result1) + "\n");
                }
                builder.append("\n\n");
                continue;
            }
            builder.insert(0, key + " = " + this.parse(result) + "\n");
        }
        BufferedWriter writer = new BufferedWriter(new FileWriter(this.file.getAbsoluteFile()));
        writer.write(builder.toString());
        writer.close();
    }

    private String parse(Object result) {
        if (result instanceof String) {
            return '\"' + result.toString() + '\"';
        }
        if (result instanceof List) {
            StringBuilder builder = new StringBuilder();
            builder.append("[");
            for (Object item : (List)result) {
                builder.append(this.parse(item));
                if (((List)result).indexOf(item) == ((List)result).size() - 1) continue;
                builder.append(", ");
            }
            builder.append("]");
            return builder.toString();
        }
        return result.toString();
    }
}

