/*
 * Decompiled with CFR 0.152.
 */
package org.github.trainerguy22.jtoml.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.github.trainerguy22.jtoml.TomlParser;
import org.github.trainerguy22.jtoml.Util;

public class SimpleTomlParser
implements TomlParser {
    private static final String SPACES = "\\s*";
    private static final String POSSIBLE_COMMENT = "(#.*)?";
    private static final String KEY_EQUALS = "(\\s*(\\w[a-zA-Z_0-9\\-]+)\\s*=\\s*)?";
    private static final String ARRAY = "\\s*\\[\\s*(.*)\\s*\\]\\s*";
    private static final String DATE = "(\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}.*)";
    private static final String DOUBLE = "([-+]?\\d*\\.\\d+([eE][-+]?\\d+)?)";
    private static final String DIGITS = "(\\d+)";
    private static final String STRING = "\"(.*)\"";
    private static final String BOOLEAN = "(true|false)";
    private static final Pattern ARRAY_LINE_PATTERN = Pattern.compile("(\\s*(\\w[a-zA-Z_0-9\\-]+)\\s*=\\s*)?\\s*\\[\\s*(.*)\\s*\\]\\s*", 32);
    private static final Pattern GROUP_PATTERN = Pattern.compile("\\s*\\[(.*)\\]\\s*");
    private static final Pattern COMMENT_PATTERN = Pattern.compile("(,|\"|\\])\\s*(#.*)");
    private static final Pattern LINES_PATTERN = Pattern.compile("([^\n]+)\n?");
    private final Matcher arrayLineMatcher = ARRAY_LINE_PATTERN.matcher("");
    private final Matcher groupMatcher = GROUP_PATTERN.matcher("");
    private final Matcher commentMatcher = COMMENT_PATTERN.matcher("");
    private final Matcher lineMatcher = LINES_PATTERN.matcher("");
    private final List<Handler> handlers = new ArrayList<Handler>(){
        {
            this.add(new Handler("(\\s*(\\w[a-zA-Z_0-9\\-]+)\\s*=\\s*)?(\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}.*)"){

                @Override
                Object cast(String v) {
                    try {
                        return Util.ISO8601.toCalendar(v);
                    }
                    catch (Exception e) {
                        return null;
                    }
                }
            });
            this.add(new Handler("(\\s*(\\w[a-zA-Z_0-9\\-]+)\\s*=\\s*)?([-+]?\\d*\\.\\d+([eE][-+]?\\d+)?)\\s*(#.*)?"){

                @Override
                Object cast(String v) {
                    return Double.valueOf(v);
                }
            });
            this.add(new Handler("(\\s*(\\w[a-zA-Z_0-9\\-]+)\\s*=\\s*)?(\\d+)\\s*(#.*)?"){

                @Override
                Object cast(String v) {
                    return (int)Math.max(Math.min(Integer.MAX_VALUE, Long.valueOf(v)), Integer.MIN_VALUE);
                }
            });
            this.add(new Handler("(\\s*(\\w[a-zA-Z_0-9\\-]+)\\s*=\\s*)?\"(.*)\"\\s*"){

                @Override
                Object cast(String v) {
                    return Util.TomlString.unescape(v.trim());
                }
            });
            this.add(new Handler("(\\s*(\\w[a-zA-Z_0-9\\-]+)\\s*=\\s*)?(true|false)\\s*(#.*)?"){

                @Override
                Object cast(String v) {
                    return Boolean.parseBoolean(v);
                }
            });
        }
    };

    @Override
    public Map<String, Object> parse(String tomlString) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        Map<String, Object> context = result;
        tomlString = this.prepareArrays(tomlString);
        this.lineMatcher.reset(tomlString);
        while (this.lineMatcher.find()) {
            Object[] val;
            String line = this.lineMatcher.group().trim();
            if (this.commentMatcher.reset(line).find()) {
                line = line.replace(this.commentMatcher.group(2), "");
            }
            if (this.groupMatcher.reset(line).matches()) {
                context = this.createContextIfNeeded(result, this.groupMatcher.group(1));
            }
            if ((val = this.readObject(line)) == null || val[0] == null) continue;
            context.put((String)val[0], val[1]);
        }
        return result;
    }

    private String prepareArrays(String s) {
        StringBuffer buffer = new StringBuffer();
        String currentLine = "";
        for (String l : s.split("\n")) {
            if (Util.TomlString.countOccurrences(currentLine = currentLine + l, "[") != Util.TomlString.countOccurrences(currentLine, "]")) continue;
            if (l.equals(currentLine)) {
                buffer.append(currentLine);
            } else {
                buffer.append(currentLine.replaceAll("#[^],]+", "").replaceAll("\\[\\s*", "[").replaceAll("\\s*\\]", "]").replaceAll(",\\s*", ",").replaceAll(",,", ","));
            }
            buffer.append("\n");
            currentLine = "";
        }
        return buffer.toString();
    }

    private Map<String, Object> createContextIfNeeded(Map<String, Object> context, String key) {
        Map visitor = context;
        for (String part : key.split("[.]")) {
            if (!visitor.containsKey(part)) {
                visitor.put((String)part, new LinkedHashMap());
            }
            if (!(visitor.get(part) instanceof Map)) {
                throw new IllegalArgumentException("Overwriting a previous key is forbidden. Trying to overwrite key `" + key + "` having value `" + visitor.get(part) + "`");
            }
            visitor = (Map)visitor.get(part);
        }
        return visitor;
    }

    /*
     * WARNING - void declaration
     */
    private Object[] readObject(String line) {
        for (Handler handler : this.handlers) {
            if (!handler.matcher().reset(line).matches()) continue;
            String key = handler.matcher().group(2);
            Object value = handler.cast(handler.matcher().group(3));
            return new Object[]{key, value};
        }
        if (this.arrayLineMatcher.reset(line).matches()) {
            int len$;
            String[] arr$;
            String key = this.arrayLineMatcher.group(2);
            String array = this.arrayLineMatcher.group(3);
            ArrayList<Object> values = new ArrayList<Object>();
            if (array.matches(".*(?:\\]),.*")) {
                void var7_11;
                arr$ = array.split("(?:\\]),");
                len$ = arr$.length;
                boolean bl = false;
                while (var7_11 < len$) {
                    String nested = arr$[var7_11];
                    Object[] nestedArray = this.readObject((nested = nested + "]").trim());
                    if (nestedArray != null) {
                        values.add(nestedArray[1]);
                    }
                    ++var7_11;
                }
            } else {
                void var7_13;
                arr$ = array.split(",");
                len$ = arr$.length;
                boolean bl = false;
                while (var7_13 < len$) {
                    Object[] nested;
                    String value = arr$[var7_13];
                    if ((value = value.trim()).endsWith("]")) {
                        value = value.substring(0, value.length() - 1);
                    }
                    if ((nested = this.readObject(value.trim())) != null) {
                        values.add(nested[1]);
                    }
                    ++var7_13;
                }
            }
            if (values != null && values.size() > 0) {
                HashSet types = new HashSet();
                for (Object e : values) {
                    types.add(e.getClass());
                }
                if (types.size() > 1) {
                    throw new IllegalArgumentException("Inconsistent types found while parsing array. Found all the following types in the same array declaration: " + types);
                }
            }
            return new Object[]{key, values};
        }
        return null;
    }

    static abstract class Handler {
        static final Map<String, Pattern> PATTERNS = new HashMap<String, Pattern>();
        final Matcher matcher;

        public Handler(String regex) {
            this.matcher = this.getPattern(regex).matcher("");
        }

        public Pattern getPattern(String regex) {
            if (!PATTERNS.containsKey(regex)) {
                PATTERNS.put(regex, Pattern.compile(regex));
            }
            return PATTERNS.get(regex);
        }

        Matcher matcher() {
            return this.matcher;
        }

        abstract Object cast(String var1);
    }
}

