/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.common;

import cpw.mods.fml.common.Loader;
import java.util.Arrays;
import java.util.Collections;
import net.machinemuse.api.ModuleManager;
import net.machinemuse.numina.general.MuseLogger;
import net.machinemuse.powersuits.common.Config;
import net.machinemuse.powersuits.common.MPSItems;
import net.machinemuse.powersuits.powermodule.armor.ApiaristArmorModule;
import net.machinemuse.powersuits.powermodule.armor.HazmatModule;
import net.machinemuse.powersuits.powermodule.misc.AirtightSealModule;
import net.machinemuse.powersuits.powermodule.misc.ThaumGogglesModule;
import net.machinemuse.powersuits.powermodule.tool.GrafterModule;
import net.machinemuse.powersuits.powermodule.tool.MFFSFieldTeleporterModule;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class ModCompatability {
    private static Class Ic2Items;

    public static boolean isGregTechLoaded() {
        return Loader.isModLoaded((String)"gregtech_addon");
    }

    public static boolean isBasicComponentsLoaded() {
        return Loader.isModLoaded((String)"BasicComponents");
    }

    public static boolean isIndustrialCraftLoaded() {
        return Loader.isModLoaded((String)"IC2");
    }

    public static boolean isThaumCraftLoaded() {
        return Loader.isModLoaded((String)"Thaumcraft");
    }

    public static boolean isThermalExpansionLoaded() {
        return Loader.isModLoaded((String)"ThermalExpansion");
    }

    public static boolean isGalacticraftLoaded() {
        return Loader.isModLoaded((String)"GalacticraftCore");
    }

    public static boolean isCoFHCoreLoaded() {
        return Loader.isModLoaded((String)"CoFHCore");
    }

    public static boolean isForestryLoaded() {
        return Loader.isModLoaded((String)"Forestry");
    }

    public static boolean isOmniToolsLoaded() {
        return Loader.isModLoaded((String)"OmniTools");
    }

    public static boolean enableThaumGogglesModule() {
        boolean defaultval = ModCompatability.isThaumCraftLoaded();
        return Config.getConfig().get("Special Modules", "Thaumcraft Goggles Module", defaultval).getBoolean(defaultval);
    }

    public static boolean vanillaRecipesEnabled() {
        boolean defaultval = !ModCompatability.isBasicComponentsLoaded() && !ModCompatability.isIndustrialCraftLoaded();
        return Config.getConfig().get("general", "Vanilla Recipes", defaultval).getBoolean(defaultval);
    }

    private static boolean isAtomicScienceLoaded() {
        return Loader.isModLoaded((String)"AtomicScience");
    }

    public static boolean UERecipesEnabled() {
        boolean defaultval = ModCompatability.isBasicComponentsLoaded();
        return Config.getConfig().get("general", "Universal Electricity Recipes", defaultval).getBoolean(defaultval);
    }

    public static boolean IC2RecipesEnabled() {
        boolean defaultval = ModCompatability.isIndustrialCraftLoaded() && !ModCompatability.isGregTechLoaded();
        return Config.getConfig().get("general", "IndustrialCraft Recipes", defaultval).getBoolean(defaultval);
    }

    public static boolean GregTechRecipesEnabled() {
        boolean defaultval = ModCompatability.isGregTechLoaded();
        return Config.getConfig().get("general", "Gregtech Recipes", defaultval).getBoolean(defaultval);
    }

    public static boolean ThermalExpansionRecipesEnabled() {
        boolean defaultval = ModCompatability.isThermalExpansionLoaded();
        return Config.getConfig().get("general", "Thermal Expansion Recipes", defaultval).getBoolean(defaultval);
    }

    public static double getUERatio() {
        return Config.getConfig().get("general", "Energy per UEJ", 1.0).getDouble(1.0);
    }

    public static double getIC2Ratio() {
        return Config.getConfig().get("general", "Energy per IC2 EU", 0.4).getDouble(0.4);
    }

    public static double getBCRatio() {
        return Config.getConfig().get("general", "Energy per MJ", 1.0).getDouble(1.0);
    }

    public static double getRFRatio() {
        return Config.getConfig().get("general", "Energy per RF", 0.1).getDouble(0.1);
    }

    public static ItemStack getIC2Item(String name) {
        try {
            Object ret;
            if (Ic2Items == null) {
                Ic2Items = Class.forName("ic2.core.Ic2Items");
            }
            if ((ret = Ic2Items.getField(name).get(null)) instanceof ItemStack) {
                return ((ItemStack)ret).func_77946_l();
            }
            return null;
        }
        catch (Exception e) {
            MuseLogger.logError((String)("IC2 API: Call getItem failed for " + name));
            return null;
        }
    }

    public static ItemStack getGregtechItem(int aIndex, int aAmount, int aMeta) {
        try {
            return (ItemStack)Class.forName("gregtechmod.api.GregTech_API").getMethod("getGregTechItem", Integer.TYPE, Integer.TYPE, Integer.TYPE).invoke(null, aIndex, aAmount, aMeta);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void registerModSpecificModules() {
        ModCompatability.getBCRatio();
        ModCompatability.getIC2Ratio();
        ModCompatability.getRFRatio();
        ModCompatability.getUERatio();
        if (ModCompatability.isThaumCraftLoaded() && ModCompatability.enableThaumGogglesModule()) {
            ModuleManager.addModule(new ThaumGogglesModule(Collections.singletonList(MPSItems.powerArmorHead())));
        }
        if (ModCompatability.isAtomicScienceLoaded()) {
            ModuleManager.addModule(new HazmatModule(Arrays.asList(MPSItems.powerArmorHead(), MPSItems.powerArmorTorso(), MPSItems.powerArmorLegs(), MPSItems.powerArmorFeet())));
        }
        if (ModCompatability.isGalacticraftLoaded()) {
            ModuleManager.addModule(new AirtightSealModule(Collections.singletonList(MPSItems.powerArmorHead())));
        }
        if (ModCompatability.isForestryLoaded()) {
            ModuleManager.addModule(new GrafterModule(Collections.singletonList(MPSItems.powerTool())));
            ModuleManager.addModule(new ApiaristArmorModule(Arrays.asList(MPSItems.powerArmorHead(), MPSItems.powerArmorTorso(), MPSItems.powerArmorLegs(), MPSItems.powerArmorFeet())));
        }
        try {
            ModuleManager.addModule(new MFFSFieldTeleporterModule(Collections.singletonList(MPSItems.powerTool())));
        }
        catch (Throwable e) {
            MuseLogger.logError((String)"Failed to get MFFS item!");
        }
    }

    public static ItemStack getMFFSItem(String name, int quantity) throws ClassNotFoundException, NoSuchFieldException, IllegalAccessException {
        Object obj = Class.forName("mods.mffs.common.ModularForceFieldSystem").getField("MFFSitemFieldTeleporter").get(null);
        ItemStack stack = new ItemStack((Item)obj, quantity);
        return stack;
    }
}

