/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.general.gui.frame;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.machinemuse.api.IPowerModule;
import net.machinemuse.api.ModuleManager;
import net.machinemuse.general.gui.clickable.ClickableItem;
import net.machinemuse.general.gui.clickable.ClickableModule;
import net.machinemuse.general.gui.frame.ItemSelectionFrame;
import net.machinemuse.general.gui.frame.ModuleSelectionSubFrame;
import net.machinemuse.general.gui.frame.ScrollableFrame;
import net.machinemuse.numina.geometry.Colour;
import net.machinemuse.numina.geometry.MusePoint2D;
import net.machinemuse.numina.geometry.MuseRect;
import net.machinemuse.numina.geometry.MuseRelativeRect;
import net.machinemuse.utils.render.MuseRenderer;
import org.lwjgl.opengl.GL11;

public class ModuleSelectionFrame
extends ScrollableFrame {
    protected ItemSelectionFrame target;
    protected Map<String, ModuleSelectionSubFrame> categories;
    protected List<ClickableModule> moduleButtons;
    protected int selectedModule = -1;
    protected IPowerModule prevSelection;
    protected ClickableItem lastItem;
    protected MuseRect lastPosition;

    public ModuleSelectionFrame(MusePoint2D topleft, MusePoint2D bottomright, Colour borderColour, Colour insideColour, ItemSelectionFrame target) {
        super(topleft, bottomright, borderColour, insideColour);
        this.target = target;
        this.moduleButtons = new ArrayList<ClickableModule>();
        this.categories = new HashMap<String, ModuleSelectionSubFrame>();
    }

    @Override
    public void update(double mousex, double mousey) {
        super.update(mousex, mousey);
    }

    @Override
    public void draw() {
        for (ModuleSelectionSubFrame frame : this.categories.values()) {
            frame.refreshButtonPositions();
        }
        if (this.target.getSelectedItem() != null) {
            if (this.lastItem != this.target.getSelectedItem()) {
                this.loadModules();
            }
            this.totalsize = 0;
            for (ModuleSelectionSubFrame frame : this.categories.values()) {
                this.totalsize = (int)Math.max(frame.border.bottom() - this.border.top(), (double)this.totalsize);
            }
            this.currentscrollpixels = Math.min(this.currentscrollpixels, this.getMaxScrollPixels());
            super.preDraw();
            GL11.glPushMatrix();
            GL11.glTranslatef((float)0.0f, (float)(-this.currentscrollpixels), (float)0.0f);
            this.drawItems();
            this.drawSelection();
            GL11.glPopMatrix();
            super.postDraw();
        }
    }

    private void drawItems() {
        for (ModuleSelectionSubFrame frame : this.categories.values()) {
            frame.drawPartial((int)((double)this.currentscrollpixels + this.border.top() + 4.0), (int)((double)this.currentscrollpixels + this.border.top() + this.border.height() - 4.0));
        }
    }

    private void drawSelection() {
        MusePoint2D pos;
        ClickableModule module = this.getSelectedModule();
        if (module != null && (pos = this.moduleButtons.get(this.selectedModule).getPosition()).y() > (double)this.currentscrollpixels + this.border.top() + 4.0 && pos.y() < (double)this.currentscrollpixels + this.border.top() + this.border.height() - 4.0) {
            MuseRenderer.drawCircleAround(pos.x(), pos.y(), 10.0);
        }
    }

    public ClickableModule getSelectedModule() {
        if (this.moduleButtons.size() > this.selectedModule && this.selectedModule != -1) {
            return this.moduleButtons.get(this.selectedModule);
        }
        return null;
    }

    public void loadModules() {
        this.lastPosition = null;
        ClickableItem selectedItem = this.target.getSelectedItem();
        if (selectedItem != null) {
            this.moduleButtons = new ArrayList<ClickableModule>();
            this.categories = new HashMap<String, ModuleSelectionSubFrame>();
            List<IPowerModule> workingModules = ModuleManager.getValidModulesForItem(null, selectedItem.getItem());
            Iterator<IPowerModule> it = workingModules.iterator();
            while (it.hasNext()) {
                IPowerModule module = it.next();
                if (module.isAllowed() || ModuleManager.itemHasModule(selectedItem.getItem(), module.getDataName())) continue;
                it.remove();
            }
            if (workingModules.size() > 0) {
                this.selectedModule = -1;
                for (IPowerModule module : workingModules) {
                    ModuleSelectionSubFrame frame = this.getOrCreateCategory(module.getCategory());
                    ClickableModule moduleClickable = frame.addModule(module);
                    if (!module.isAllowed()) {
                        moduleClickable.setAllowed(false);
                    } else if (ModuleManager.itemHasModule(selectedItem.getItem(), module.getDataName())) {
                        moduleClickable.setInstalled(true);
                    }
                    if (moduleClickable.getModule().equals(this.prevSelection)) {
                        this.selectedModule = this.moduleButtons.size();
                    }
                    this.moduleButtons.add(moduleClickable);
                }
            }
            for (ModuleSelectionSubFrame frame : this.categories.values()) {
                frame.refreshButtonPositions();
            }
        }
    }

    private ModuleSelectionSubFrame getOrCreateCategory(String category) {
        if (this.categories.containsKey(category)) {
            return this.categories.get(category);
        }
        MuseRelativeRect position = new MuseRelativeRect(this.border.left() + 4.0, this.border.top() + 4.0, this.border.right() - 4.0, this.border.top() + 32.0);
        position.setBelow(this.lastPosition);
        this.lastPosition = position;
        ModuleSelectionSubFrame frame = new ModuleSelectionSubFrame(category, position);
        this.categories.put(category, frame);
        return frame;
    }

    @Override
    public void onMouseDown(double x, double y, int button) {
        super.onMouseDown(x, y, button);
        if (this.border.left() < x && this.border.right() > x && this.border.top() < y && this.border.bottom() > y) {
            y += (double)this.currentscrollpixels;
            int i = 0;
            for (ClickableModule module : this.moduleButtons) {
                if (module.hitBox(x, y)) {
                    this.selectedModule = i;
                    this.prevSelection = module.getModule();
                    break;
                }
                ++i;
            }
        }
    }

    @Override
    public List<String> getToolTip(int x, int y) {
        if (this.border.left() < (double)x && this.border.right() > (double)x && this.border.top() < (double)y && this.border.bottom() > (double)y) {
            y += this.currentscrollpixels;
            if (this.moduleButtons != null) {
                int moduleHover = -1;
                int i = 0;
                for (ClickableModule module : this.moduleButtons) {
                    if (module.hitBox(x, y)) {
                        moduleHover = i;
                        break;
                    }
                    ++i;
                }
                if (moduleHover > -1) {
                    return this.moduleButtons.get(moduleHover).getToolTip();
                }
                return null;
            }
        }
        return null;
    }
}

