/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.general.gui.frame;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.machinemuse.general.gui.clickable.ClickableItem;
import net.machinemuse.general.gui.frame.ScrollableFrame;
import net.machinemuse.numina.geometry.Colour;
import net.machinemuse.numina.geometry.FlyFromPointToPoint2D;
import net.machinemuse.numina.geometry.GradientAndArcCalculator;
import net.machinemuse.numina.geometry.MusePoint2D;
import net.machinemuse.utils.MuseItemUtils;
import net.machinemuse.utils.render.MuseRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;

public class ItemSelectionFrame
extends ScrollableFrame {
    protected List<ClickableItem> itemButtons;
    protected int selectedItemStack = -1;
    protected EntityPlayer player;
    protected List<MusePoint2D> itemPoints;

    public ItemSelectionFrame(MusePoint2D topleft, MusePoint2D bottomright, Colour borderColour, Colour insideColour, EntityPlayer player) {
        super(topleft, bottomright, borderColour, insideColour);
        this.player = player;
        List<Integer> slots = MuseItemUtils.getModularItemSlotsInInventory((IInventory)player.field_71071_by);
        this.loadPoints(slots.size());
        this.loadItems();
    }

    private void loadPoints(int num) {
        double centerx = (this.border.left() + this.border.right()) / 2.0;
        double centery = (this.border.top() + this.border.bottom()) / 2.0;
        this.itemPoints = new ArrayList<MusePoint2D>();
        List targetPoints = GradientAndArcCalculator.pointsInLine((int)num, (MusePoint2D)new MusePoint2D(centerx, this.border.bottom()), (MusePoint2D)new MusePoint2D(centerx, this.border.top()));
        for (MusePoint2D point : targetPoints) {
            this.itemPoints.add((MusePoint2D)new FlyFromPointToPoint2D(new MusePoint2D(centerx, centery), point, 200.0));
        }
    }

    private void loadItems() {
        if (this.player != null) {
            this.itemButtons = new ArrayList<ClickableItem>();
            double centerx = (this.border.left() + this.border.right()) / 2.0;
            double centery = (this.border.top() + this.border.bottom()) / 2.0;
            List<Integer> slots = MuseItemUtils.getModularItemSlotsInInventory((IInventory)this.player.field_71071_by);
            if (slots.size() > this.itemPoints.size()) {
                this.loadPoints(slots.size());
            }
            if (slots.size() > 0) {
                Iterator<MusePoint2D> pointiterator = this.itemPoints.iterator();
                for (int slot : slots) {
                    ClickableItem clickie = new ClickableItem(this.player.field_71071_by.func_70301_a(slot), pointiterator.next(), slot);
                    this.itemButtons.add(clickie);
                }
            }
        }
    }

    @Override
    public void update(double mousex, double mousey) {
        this.loadItems();
    }

    @Override
    public void draw() {
        this.drawBackground();
        this.drawItems();
        this.drawSelection();
    }

    private void drawBackground() {
        super.draw();
    }

    private void drawItems() {
        for (ClickableItem item : this.itemButtons) {
            item.draw();
        }
    }

    private void drawSelection() {
        if (this.selectedItemStack != -1) {
            MuseRenderer.drawCircleAround(Math.floor(this.itemButtons.get(this.selectedItemStack).getPosition().x()), Math.floor(this.itemButtons.get(this.selectedItemStack).getPosition().y()), 10.0);
        }
    }

    public boolean hasNoItems() {
        return this.itemButtons.size() == 0;
    }

    public ClickableItem getSelectedItem() {
        if (this.itemButtons.size() > this.selectedItemStack && this.selectedItemStack != -1) {
            return this.itemButtons.get(this.selectedItemStack);
        }
        return null;
    }

    @Override
    public void onMouseDown(double x, double y, int button) {
        int i = 0;
        for (ClickableItem item : this.itemButtons) {
            if (item.hitBox(x, y)) {
                this.selectedItemStack = i;
                break;
            }
            ++i;
        }
    }

    @Override
    public List<String> getToolTip(int x, int y) {
        int itemHover = -1;
        int i = 0;
        for (ClickableItem item : this.itemButtons) {
            if (item.hitBox(x, y)) {
                itemHover = i;
                break;
            }
            ++i;
        }
        if (itemHover > -1) {
            return this.itemButtons.get(itemHover).getToolTip();
        }
        return null;
    }
}

