/*
 * Decompiled with CFR 0.152.
 */
package kihira.tails.common.network;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import kihira.tails.common.PartsData;
import kihira.tails.common.Tails;

public class PlayerDataMessage
implements IMessage {
    private PartsData partsData;
    private boolean shouldRemove;

    public PlayerDataMessage() {
    }

    public PlayerDataMessage(PartsData partsData, boolean shouldRemove) {
        this.partsData = partsData;
        this.shouldRemove = shouldRemove;
    }

    public void fromBytes(ByteBuf buf) {
        String tailInfoJson = ByteBufUtils.readUTF8String((ByteBuf)buf);
        try {
            this.partsData = (PartsData)new GsonBuilder().excludeFieldsWithoutExposeAnnotation().create().fromJson(tailInfoJson, PartsData.class);
        }
        catch (JsonSyntaxException e) {
            Tails.logger.warn((Object)e);
        }
    }

    public void toBytes(ByteBuf buf) {
        String tailInfoJson = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().create().toJson((Object)this.partsData);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)tailInfoJson);
    }

    public static class Handler
    implements IMessageHandler<PlayerDataMessage, IMessage> {
        public IMessage onMessage(PlayerDataMessage message, MessageContext ctx) {
            if (message.partsData != null) {
                if (message.shouldRemove) {
                    Tails.proxy.removePartsData(((PlayerDataMessage)message).partsData.uuid);
                } else {
                    Tails.proxy.addPartsData(((PlayerDataMessage)message).partsData.uuid, message.partsData);
                    if (ctx.side.isServer()) {
                        Tails.networkWrapper.sendToAll((IMessage)new PlayerDataMessage(message.partsData, false));
                    }
                }
            }
            return null;
        }
    }
}

