/*
 * Decompiled with CFR 0.152.
 */
package kihira.tails.client.gui;

import com.google.common.base.Strings;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.imageio.ImageIO;
import kihira.foxlib.client.gui.GuiBaseScreen;
import kihira.foxlib.client.gui.GuiIconButton;
import kihira.foxlib.client.gui.GuiList;
import kihira.foxlib.client.gui.IListCallback;
import kihira.foxlib.client.toast.ToastManager;
import kihira.tails.client.FakeEntity;
import kihira.tails.client.PartRegistry;
import kihira.tails.client.gui.GuiExport;
import kihira.tails.client.gui.controls.GuiHSBSlider;
import kihira.tails.client.render.RenderPart;
import kihira.tails.client.texture.TextureHelper;
import kihira.tails.common.PartInfo;
import kihira.tails.common.PartsData;
import kihira.tails.common.Tails;
import kihira.tails.common.network.PlayerDataMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiListExtended;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLException;
import org.lwjgl.input.Cursor;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiEditor
extends GuiBaseScreen
implements IListCallback,
GuiHSBSlider.IHSBSliderCallback {
    private float yaw = 0.0f;
    private float pitch = 10.0f;
    private int prevMouseX = -1;
    private int currTintEdit = 0;
    private int currTintColour = 0xFFFFFF;
    private GuiTextField hexText;
    private GuiHSBSlider[] hsbSliders;
    private GuiHSBSlider[] rgbSliders;
    private GuiIconButton tintReset;
    private GuiIconButton colourPicker;
    private int textureID;
    private IntBuffer pixelBuffer;
    private boolean selectingColour = false;
    private ScaledResolution scaledRes;
    private int previewWindowLeft;
    private int previewWindowRight;
    private int previewWindowBottom;
    private int editPaneTop;
    private PartsData.PartType partType;
    private PartsData partsData;
    private PartInfo partInfo;
    private PartInfo originalPartInfo;
    private GuiButton partTypeButton;
    private GuiList partList;
    private FakeEntity fakeEntity;

    public GuiEditor() {
        if (Tails.localPartsData == null) {
            Tails.setLocalPartsData(new PartsData(Minecraft.func_71410_x().field_71439_g.getPersistentID()));
        }
        this.partType = PartsData.PartType.TAIL;
        for (PartsData.PartType partType : PartsData.PartType.values()) {
            if (Tails.localPartsData.hasPartInfo(partType)) continue;
            Tails.localPartsData.setPartInfo(partType, new PartInfo(Minecraft.func_71410_x().field_71439_g.getPersistentID(), false, 0, 0, 0, -65536, -16711936, -16776961, null, partType));
        }
        PartInfo partInfo = Tails.localPartsData.getPartInfo(this.partType);
        this.originalPartInfo = partInfo.deepCopy();
        this.partsData = Tails.localPartsData.deepCopy();
        this.partInfo = this.originalPartInfo.deepCopy();
        this.fakeEntity = new FakeEntity((World)Minecraft.func_71410_x().field_71441_e);
    }

    public void func_73866_w_() {
        int previewWindowEdgeOffset;
        this.scaledRes = new ScaledResolution(this.field_146297_k, this.field_146297_k.field_71443_c, this.field_146297_k.field_71440_d);
        this.previewWindowLeft = previewWindowEdgeOffset = 110;
        this.previewWindowRight = this.field_146294_l - previewWindowEdgeOffset;
        this.previewWindowBottom = this.field_146295_m - 30;
        this.editPaneTop = this.field_146295_m - 107;
        int topOffset = 20;
        for (int i = 2; i <= 4; ++i) {
            this.field_146292_n.add(new GuiButton(i, this.previewWindowRight + 30, topOffset, 40, 20, I18n.func_135052_a((String)"gui.button.edit", (Object[])new Object[0])));
            topOffset += 35;
        }
        this.hexText = new GuiTextField(this.field_146289_q, this.previewWindowRight + 30, this.editPaneTop + 20, 73, 10);
        this.hexText.func_146203_f(6);
        this.hexText.func_146180_a(Integer.toHexString(this.currTintColour));
        this.rgbSliders = new GuiHSBSlider[3];
        this.rgbSliders[0] = new GuiHSBSlider(5, this.previewWindowRight + 5, this.editPaneTop + 70, 100, 10, this, GuiHSBSlider.HSBSliderType.SATURATION, I18n.func_135052_a((String)"gui.slider.red.tooltip", (Object[])new Object[0]));
        this.rgbSliders[1] = new GuiHSBSlider(6, this.previewWindowRight + 5, this.editPaneTop + 80, 100, 10, this, GuiHSBSlider.HSBSliderType.SATURATION, I18n.func_135052_a((String)"gui.slider.green.tooltip", (Object[])new Object[0]));
        this.rgbSliders[2] = new GuiHSBSlider(7, this.previewWindowRight + 5, this.editPaneTop + 90, 100, 10, this, GuiHSBSlider.HSBSliderType.SATURATION, I18n.func_135052_a((String)"gui.slider.blue.tooltip", (Object[])new Object[0]));
        this.rgbSliders[0].setHue(0.0f);
        this.rgbSliders[1].setHue(0.33333334f);
        this.rgbSliders[2].setHue(0.6666667f);
        this.field_146292_n.add(this.rgbSliders[0]);
        this.field_146292_n.add(this.rgbSliders[1]);
        this.field_146292_n.add(this.rgbSliders[2]);
        this.hsbSliders = new GuiHSBSlider[3];
        this.hsbSliders[0] = new GuiHSBSlider(15, this.previewWindowRight + 5, this.editPaneTop + 35, 100, 10, this, GuiHSBSlider.HSBSliderType.HUE, I18n.func_135052_a((String)"gui.slider.hue.tooltip", (Object[])new Object[0]));
        this.hsbSliders[1] = new GuiHSBSlider(16, this.previewWindowRight + 5, this.editPaneTop + 45, 100, 10, this, GuiHSBSlider.HSBSliderType.SATURATION, I18n.func_135052_a((String)"gui.slider.saturation.tooltip", (Object[])new Object[0]));
        this.hsbSliders[2] = new GuiHSBSlider(17, this.previewWindowRight + 5, this.editPaneTop + 55, 100, 10, this, GuiHSBSlider.HSBSliderType.BRIGHTNESS, I18n.func_135052_a((String)"gui.slider.brightness.tooltip", (Object[])new Object[0]));
        this.field_146292_n.add(this.hsbSliders[0]);
        this.field_146292_n.add(this.hsbSliders[1]);
        this.field_146292_n.add(this.hsbSliders[2]);
        this.tintReset = new GuiIconButton(8, this.field_146294_l - 20, this.editPaneTop + 2, GuiIconButton.Icons.UNDO, new String[]{I18n.func_135052_a((String)"gui.button.reset", (Object[])new Object[0])});
        this.field_146292_n.add(this.tintReset);
        this.tintReset.field_146124_l = false;
        this.field_146292_n.add(new GuiButton(12, this.previewWindowRight - 83, this.field_146295_m - 25, 40, 20, I18n.func_135052_a((String)"gui.button.reset", (Object[])new Object[0])));
        this.field_146292_n.add(new GuiButton(13, this.previewWindowRight - 43, this.field_146295_m - 25, 40, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0])));
        this.field_146292_n.add(new GuiBaseScreen.GuiButtonTooltip((GuiBaseScreen)this, 14, this.field_146294_l / 2 - 20, this.field_146295_m - 25, 40, 20, I18n.func_135052_a((String)"gui.button.export", (Object[])new Object[0]), this.scaledRes.func_78326_a() / 3, new String[]{I18n.func_135052_a((String)"gui.button.export.0.tooltip", (Object[])new Object[0])}));
        this.field_146292_n.add(new GuiButton(18, 5, this.field_146295_m - 25, 15, 20, "<"));
        this.field_146292_n.add(new GuiButton(19, this.previewWindowLeft - 20, this.field_146295_m - 25, 15, 20, ">"));
        this.textureID = this.partInfo.textureID;
        this.partTypeButton = new GuiButton(20, this.previewWindowLeft + 3, this.field_146295_m - 25, 40, 20, this.partType.name());
        this.field_146292_n.add(this.partTypeButton);
        this.colourPicker = new GuiIconButton(21, this.field_146294_l - 36, this.editPaneTop + 1, GuiIconButton.Icons.EYEDROPPER, new String[]{I18n.func_135052_a((String)"gui.button.picker.0", (Object[])new Object[0]), I18n.func_135052_a((String)"gui.button.picker.1", (Object[])new Object[0])});
        this.field_146292_n.add(this.colourPicker);
        this.colourPicker.field_146125_m = false;
        this.field_146292_n.add(new GuiIconButton(22, this.previewWindowRight - 18, 22, GuiIconButton.Icons.UNDO, new String[]{I18n.func_135052_a((String)"gui.button.reset.camera", (Object[])new Object[0])}));
        this.field_146292_n.add(new GuiIconButton(500, this.previewWindowRight - 18, 4, GuiIconButton.Icons.QUESTION, new String[]{I18n.func_135052_a((String)"gui.button.help.camera.0", (Object[])new Object[0]), I18n.func_135052_a((String)"gui.button.help.camera.1", (Object[])new Object[0])}));
        this.initPartList();
        this.refreshTintPane();
    }

    private void initPartList() {
        ArrayList<PartEntry> partList = new ArrayList<PartEntry>();
        UUID uuid = UUID.fromString("18040390-23b0-11e4-8c21-0800200c9a66");
        partList.add(new PartEntry(new PartInfo(uuid, false, 0, 0, 0, -65536, -16711936, -16776961, null, this.partType)));
        List<RenderPart> parts = PartRegistry.getParts(this.partType);
        for (int type = 0; type < parts.size(); ++type) {
            for (int subType = 0; subType <= parts.get(type).getAvailableSubTypes(); ++subType) {
                PartInfo partInfo = new PartInfo(uuid, true, type, subType, 0, -65536, -16711936, -16776961, null, this.partType);
                partList.add(new PartEntry(partInfo));
            }
        }
        this.partList = new GuiList((IListCallback)this, this.previewWindowLeft, this.field_146295_m - 43, 0, this.field_146295_m - 43, 55, partList);
        this.selectDefaultListEntry();
    }

    public void func_73863_a(int mouseX, int mouseY, float p_73863_3_) {
        this.field_73735_i = -1000.0f;
        this.func_73733_a(0, 0, this.previewWindowLeft, this.field_146295_m, -872415232, -872415232);
        this.func_73733_a(this.previewWindowLeft, 0, this.previewWindowRight, this.previewWindowBottom, -301989888, -301989888);
        this.func_73733_a(this.previewWindowRight, 0, this.field_146294_l, this.field_146295_m, -872415232, -872415232);
        this.func_73733_a(this.previewWindowLeft, this.previewWindowBottom, this.previewWindowRight, this.field_146295_m, -587202560, -587202560);
        int topOffset = 10;
        for (int tint = 1; tint <= 3; ++tint) {
            String s = I18n.func_135052_a((String)"gui.tint", (Object[])new Object[]{tint});
            this.field_146289_q.func_78276_b(s, this.previewWindowRight + 5, topOffset, 0xFFFFFF);
            int colour = this.partInfo.tints[tint - 1] | 0xFF000000;
            this.func_73733_a(this.previewWindowRight + 5, topOffset + 10, this.previewWindowRight + 25, topOffset + 30, colour, colour);
            topOffset += 35;
        }
        if (this.currTintEdit > 0) {
            this.func_73730_a(this.previewWindowRight, this.field_146294_l, this.editPaneTop, -16777216);
            this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"gui.tint.edit", (Object[])new Object[]{this.currTintEdit}), this.previewWindowRight + 5, this.editPaneTop + 5, 0xFFFFFF);
            this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"gui.hex", (Object[])new Object[0]) + ":", this.previewWindowRight + 5, this.editPaneTop + 21, 0xFFFFFF);
            this.hexText.func_146194_f();
        }
        this.drawEntity(this.field_146294_l / 2, this.previewWindowBottom / 2 + this.scaledRes.func_78328_b() / 4, this.scaledRes.func_78328_b() / 4, this.yaw, this.pitch, (EntityLivingBase)this.field_146297_k.field_71439_g);
        this.field_73735_i = 0.0f;
        this.partList.func_148128_a(mouseX, mouseY, p_73863_3_);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"gui.texture", (Object[])new Object[0]) + ":", 7, this.field_146295_m - 37, 0xFFFFFF);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)(this.partType.name().toLowerCase() + ".texture." + PartRegistry.getRenderPart(this.partType, this.partInfo.typeid).getTextureNames(this.partInfo.subid)[this.textureID] + ".name"), (Object[])new Object[0]), 25, this.field_146295_m - 19, 0xFFFFFF);
        super.func_73863_a(mouseX, mouseY, p_73863_3_);
    }

    protected void func_146284_a(GuiButton button) {
        RenderPart part = PartRegistry.getRenderPart(this.partType, this.partInfo.typeid);
        if (button.field_146127_k >= 2 && button.field_146127_k <= 4) {
            this.currTintEdit = button.field_146127_k - 1;
            this.currTintColour = this.partInfo.tints[this.currTintEdit - 1] & 0xFFFFFF;
            this.hexText.func_146180_a(Integer.toHexString(this.currTintColour));
            this.refreshTintPane();
            this.tintReset.field_146124_l = false;
            this.colourPicker.field_146124_l = true;
        } else if (button.field_146127_k == 8) {
            this.currTintColour = this.originalPartInfo.tints[this.currTintEdit - 1] & 0xFFFFFF;
            this.hexText.func_146180_a(Integer.toHexString(this.currTintColour));
            this.refreshTintPane();
            this.tintReset.field_146124_l = false;
        } else if (button.field_146127_k == 12) {
            this.partInfo = this.originalPartInfo.deepCopy();
            this.selectDefaultListEntry();
            this.currTintEdit = 0;
            this.refreshTintPane();
            this.updatePartsData();
        } else if (button.field_146127_k == 13) {
            this.updatePartsData();
            Tails.setLocalPartsData(this.partsData);
            Tails.proxy.addPartsData(this.partsData.uuid, this.partsData);
            Tails.networkWrapper.sendToServer((IMessage)new PlayerDataMessage(this.partsData, false));
            ToastManager.INSTANCE.createCenteredToast(this.field_146294_l / 2, this.previewWindowBottom - 20, 100, EnumChatFormatting.GREEN + "Saved!");
            this.field_146297_k.func_147108_a(null);
        } else if (button.field_146127_k == 14) {
            this.updatePartsData();
            this.field_146297_k.func_147108_a((GuiScreen)new GuiExport(this, this.partsData));
        } else if (button.field_146127_k == 18) {
            this.textureID = this.textureID - 1 >= 0 ? --this.textureID : part.getTextureNames(this.partInfo.subid).length - 1;
            this.updatePartsData();
        } else if (button.field_146127_k == 19) {
            this.textureID = part.getTextureNames(this.partInfo.subid).length > this.textureID + 1 ? ++this.textureID : 0;
            this.updatePartsData();
        } else if (button.field_146127_k == 20) {
            this.partType = this.partType.ordinal() + 1 >= PartsData.PartType.values().length ? PartsData.PartType.values()[0] : PartsData.PartType.values()[this.partType.ordinal() + 1];
            PartInfo newPartInfo = this.partsData.getPartInfo(this.partType);
            if (newPartInfo == null) {
                newPartInfo = new PartInfo(this.partsData.uuid, false, 0, 0, 0, -65536, -16711936, -16776961, null, this.partType);
            }
            this.originalPartInfo = newPartInfo.deepCopy();
            this.partInfo = this.originalPartInfo.deepCopy();
            this.textureID = this.partInfo.textureID;
            this.partTypeButton.field_146126_j = this.partType.name();
            this.initPartList();
            this.refreshTintPane();
        } else if (button.field_146127_k == 21) {
            this.setSelectingColour(true);
        } else if (button.field_146127_k == 22) {
            this.yaw = 0.0f;
            this.pitch = 10.0f;
        }
    }

    protected void func_73869_a(char letter, int keyCode) {
        this.hexText.func_146201_a(letter, keyCode);
        try {
            if (!Strings.isNullOrEmpty((String)this.hexText.func_146179_b())) {
                this.currTintColour = Integer.parseInt(this.hexText.func_146179_b(), 16);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.refreshTintPane();
        if (keyCode == 1 && this.selectingColour) {
            this.setSelectingColour(false);
        } else {
            super.func_73869_a(letter, keyCode);
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseEvent) {
        if (this.selectingColour && mouseEvent == 0) {
            this.currTintColour = this.getColourAtPoint(Mouse.getEventX(), this.field_146297_k.field_71440_d - Mouse.getEventY()) & 0xFFFFFF;
            this.setSelectingColour(false);
            this.refreshTintPane();
        } else {
            super.func_73864_a(mouseX, mouseY, mouseEvent);
            this.hexText.func_146192_a(mouseX, mouseY, mouseEvent);
        }
    }

    protected void func_146273_a(int mouseX, int mouseY, int lastButtonClicked, long timeSinceMouseClick) {
        if (lastButtonClicked == 0 && mouseY < this.previewWindowBottom && mouseX > this.previewWindowLeft && mouseX < this.previewWindowRight) {
            if (this.prevMouseX == -1) {
                this.prevMouseX = mouseX;
            } else {
                this.yaw += (float)(mouseX - this.prevMouseX) * 1.5f;
                this.prevMouseX = mouseX;
            }
        }
    }

    protected void func_146286_b(int mouseX, int mouseY, int mouseEvent) {
        this.prevMouseX = -1;
        super.func_146286_b(mouseX, mouseY, mouseEvent);
    }

    public void func_146281_b() {
        for (GuiListExtended.IGuiListEntry entry : this.partList.getEntries()) {
            PartEntry tailEntry = (PartEntry)entry;
            tailEntry.partInfo.setTexture(null);
        }
        Tails.proxy.addPartsData(this.field_146297_k.field_71439_g.getPersistentID(), Tails.localPartsData);
    }

    private void refreshTintPane() {
        this.hexText.func_146193_g(this.currTintColour);
        Color c = new Color(this.currTintColour);
        this.rgbSliders[0].setValue((float)c.getRed() / 255.0f);
        this.rgbSliders[1].setValue((float)c.getGreen() / 255.0f);
        this.rgbSliders[2].setValue((float)c.getBlue() / 255.0f);
        float[] hsbvals = Color.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), null);
        this.hsbSliders[0].setValue(hsbvals[0]);
        this.hsbSliders[1].setValue(hsbvals[1]);
        this.hsbSliders[2].setValue(hsbvals[2]);
        this.hsbSliders[1].setHue((float)this.hsbSliders[0].getValue());
        this.hsbSliders[1].setBrightness((float)this.hsbSliders[2].getValue());
        if (this.currTintEdit > 0) {
            this.rgbSliders[2].field_146125_m = true;
            this.rgbSliders[1].field_146125_m = true;
            this.rgbSliders[0].field_146125_m = true;
            this.hsbSliders[2].field_146125_m = true;
            this.hsbSliders[1].field_146125_m = true;
            this.hsbSliders[0].field_146125_m = true;
            this.tintReset.field_146125_m = true;
            this.colourPicker.field_146125_m = true;
        } else {
            this.rgbSliders[2].field_146125_m = false;
            this.rgbSliders[1].field_146125_m = false;
            this.rgbSliders[0].field_146125_m = false;
            this.hsbSliders[2].field_146125_m = false;
            this.hsbSliders[1].field_146125_m = false;
            this.hsbSliders[0].field_146125_m = false;
            this.tintReset.field_146125_m = false;
            this.colourPicker.field_146125_m = false;
        }
        this.tintReset.field_146124_l = true;
        this.updatePartsData();
    }

    private void drawEntity(int x, int y, int scale, float yaw, float pitch, EntityLivingBase entity) {
        float prevHeadYaw = entity.field_70759_as;
        float prevRotYaw = entity.field_70177_z;
        float prevRotPitch = entity.field_70125_A;
        ItemStack prevItemStack = entity.func_70694_bm();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)x, (float)y, (float)-10.0f);
        GL11.glScalef((float)(-scale), (float)scale, (float)scale);
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glTranslatef((float)0.0f, (float)entity.field_70129_M, (float)0.0f);
        GL11.glRotatef((float)pitch, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)yaw, (float)0.0f, (float)1.0f, (float)0.0f);
        entity.field_70759_as = 0.0f;
        entity.field_70177_z = 0.0f;
        entity.field_70125_A = 0.0f;
        entity.field_70761_aq = 0.0f;
        entity.func_70095_a(false);
        entity.func_70062_b(0, null);
        RenderHelper.func_74519_b();
        RenderManager.field_78727_a.field_78735_i = 180.0f;
        RenderManager.field_78727_a.func_147940_a((Entity)entity, 0.0, 0.0, 0.0, 0.0f, 1.0f);
        RenderHelper.func_74518_a();
        OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77476_b);
        GL11.glDisable((int)3553);
        OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77478_a);
        entity.field_70759_as = prevHeadYaw;
        entity.field_70177_z = prevRotYaw;
        entity.field_70125_A = prevRotPitch;
        entity.func_70062_b(0, prevItemStack);
        GL11.glPopMatrix();
    }

    private void renderPart(int x, int y, int scale, PartInfo partInfo) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)x, (float)y, (float)10.0f);
        GL11.glScalef((float)(-scale), (float)scale, (float)1.0f);
        RenderHelper.func_74519_b();
        RenderManager.field_78727_a.field_78735_i = 180.0f;
        PartRegistry.getRenderPart(partInfo.partType, partInfo.typeid).render((EntityLivingBase)this.fakeEntity, partInfo, 0.0, 0.0, 0.0, 0.0f);
        RenderHelper.func_74518_a();
        OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77476_b);
        GL11.glDisable((int)3553);
        OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77478_a);
        GL11.glPopMatrix();
    }

    @Override
    public void onValueChangeHSBSlider(GuiHSBSlider source, double sliderValue) {
        if (source == this.rgbSliders[0] || source == this.rgbSliders[1] || source == this.rgbSliders[2]) {
            this.currTintColour = new Color((int)(this.rgbSliders[0].getValue() * 255.0), (int)(this.rgbSliders[1].getValue() * 255.0), (int)(this.rgbSliders[2].getValue() * 255.0)).getRGB();
        } else {
            float[] hsbvals = new float[]{(float)this.hsbSliders[0].getValue(), (float)this.hsbSliders[1].getValue(), (float)this.hsbSliders[2].getValue()};
            hsbvals[source.getType().ordinal()] = (float)sliderValue;
            this.currTintColour = Color.getHSBColor(hsbvals[0], hsbvals[1], hsbvals[2]).getRGB();
        }
        this.hexText.func_146180_a(Integer.toHexString(this.currTintColour));
        this.refreshTintPane();
    }

    private void updatePartsData() {
        UUID uuid = this.field_146297_k.field_71439_g.getPersistentID();
        PartEntry tailEntry = (PartEntry)this.partList.func_148180_b(this.partList.getCurrrentIndex());
        this.partInfo.setTexture(null);
        if (this.currTintEdit > 0) {
            this.partInfo.tints[this.currTintEdit - 1] = this.currTintColour | 0xFF000000;
        }
        this.partInfo = new PartInfo(uuid, tailEntry.partInfo.hasPart, tailEntry.partInfo.typeid, tailEntry.partInfo.subid, this.textureID, this.partInfo.tints, this.partType, null);
        if (this.partInfo.hasPart) {
            this.partInfo.setTexture(TextureHelper.generateTexture(this.partInfo));
        }
        this.partsData.setPartInfo(this.partType, this.partInfo);
        Tails.proxy.addPartsData(uuid, this.partsData);
    }

    private void selectDefaultListEntry() {
        for (GuiListExtended.IGuiListEntry entry : this.partList.getEntries()) {
            PartEntry partEntry = (PartEntry)entry;
            if ((partEntry.partInfo.hasPart || this.partInfo.hasPart) && (!this.partInfo.hasPart || !partEntry.partInfo.hasPart || partEntry.partInfo.typeid != this.partInfo.typeid || partEntry.partInfo.subid != this.partInfo.subid)) continue;
            this.partList.setCurrrentIndex(this.partList.getEntries().indexOf(partEntry));
            break;
        }
    }

    private int getColourAtPoint(int x, int y) {
        int pixels = 1;
        if (this.pixelBuffer == null) {
            this.pixelBuffer = BufferUtils.createIntBuffer((int)pixels);
        }
        int[] pixelData = new int[pixels];
        GL11.glPixelStorei((int)3333, (int)1);
        GL11.glPixelStorei((int)3317, (int)1);
        this.pixelBuffer.clear();
        GL11.glReadPixels((int)x, (int)(this.field_146297_k.field_71440_d - y), (int)1, (int)1, (int)32993, (int)33639, (IntBuffer)this.pixelBuffer);
        this.pixelBuffer.get(pixelData);
        return pixelData[0];
    }

    private void setSelectingColour(boolean selectingColour) {
        this.selectingColour = selectingColour;
        if (selectingColour) {
            try {
                BufferedImage bufferedImage = ImageIO.read(this.field_146297_k.func_110442_L().func_110536_a(GuiIconButton.iconsTextures).func_110527_b());
                int pixels = 256;
                int[] pixelData = new int[pixels];
                IntBuffer buffer = IntBuffer.wrap(bufferedImage.getRGB(GuiIconButton.Icons.EYEDROPPER.u, GuiIconButton.Icons.EYEDROPPER.v + 16, 16, 16, pixelData, 0, 16));
                Cursor cursor = new Cursor(16, 16, 0, 15, 1, buffer, null);
                Mouse.setNativeCursor((Cursor)cursor);
            }
            catch (LWJGLException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            try {
                Mouse.setNativeCursor(null);
            }
            catch (LWJGLException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean onEntrySelected(GuiList guiList, int index, GuiListExtended.IGuiListEntry entry) {
        this.textureID = 0;
        this.updatePartsData();
        return true;
    }

    public class PartEntry
    implements GuiListExtended.IGuiListEntry {
        public final PartInfo partInfo;

        public PartEntry(PartInfo partInfo) {
            this.partInfo = partInfo;
        }

        public void func_148279_a(int index, int x, int y, int listWidth, int p_148279_5_, Tessellator tessellator, int mouseX, int mouseY, boolean mouseOver) {
            if (this.partInfo.hasPart) {
                GuiEditor.this.renderPart(GuiEditor.this.previewWindowLeft - 25, y - 25, 50, this.partInfo);
                GuiEditor.this.field_146289_q.func_78276_b(I18n.func_135052_a((String)PartRegistry.getRenderPart(this.partInfo.partType, this.partInfo.typeid).getUnlocalisedName(this.partInfo.subid), (Object[])new Object[0]), 5, y + ((GuiEditor)GuiEditor.this).partList.field_148149_f / 2 - 5, 0xFFFFFF);
            } else {
                GuiEditor.this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"tail.none.name", (Object[])new Object[0]), 5, y + ((GuiEditor)GuiEditor.this).partList.field_148149_f / 2 - 5, 0xFFFFFF);
            }
        }

        public boolean func_148278_a(int index, int mouseX, int mouseY, int p_148278_4_, int mouseSlotX, int mouseSlotY) {
            return true;
        }

        public void func_148277_b(int index, int mouseX, int mouseY, int p_148278_4_, int mouseSlotX, int mouseSlotY) {
        }
    }
}

