/*
 * Decompiled with CFR 0.152.
 */
package exnihilo.items.hammers;

import com.google.common.collect.Sets;
import exnihilo.registries.HammerRegistry;
import exnihilo.registries.helpers.Smashable;
import java.util.ArrayList;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.world.World;

public class ItemHammerBase
extends ItemTool {
    public static Set blocksEffectiveAgainst = Sets.newHashSet((Object[])new Block[0]);

    public ItemHammerBase(Item.ToolMaterial material) {
        super(3.0f, material, blocksEffectiveAgainst);
    }

    public boolean func_150897_b(Block block) {
        Block[] blocks = HammerRegistry.getBlocks();
        for (int i = 0; i < blocks.length; ++i) {
            if (blocks[i] != block) continue;
            return true;
        }
        return false;
    }

    public float getDigSpeed(ItemStack item, Block block, int meta) {
        Block[] blocks = HammerRegistry.getBlocks();
        for (int i = 0; i < blocks.length; ++i) {
            if (blocks[i] != block || block.getHarvestLevel(meta) > this.field_77862_b.func_77996_d()) continue;
            return this.field_77864_a * 0.75f;
        }
        return 0.8f;
    }

    public boolean onBlockStartBreak(ItemStack item, int X, int Y, int Z, EntityPlayer player) {
        World world = player.field_70170_p;
        Block block = world.func_147439_a(X, Y, Z);
        int blockMeta = world.func_72805_g(X, Y, Z);
        int fortune = EnchantmentHelper.func_77517_e((EntityLivingBase)player);
        boolean valid = false;
        ArrayList<Smashable> rewards = HammerRegistry.getRewards(block, blockMeta);
        if (rewards.size() > 0 && block.getHarvestLevel(blockMeta) <= this.field_77862_b.func_77996_d()) {
            for (Smashable reward : rewards) {
                if (!world.field_72995_K && world.field_73012_v.nextFloat() <= reward.chance + reward.luckMultiplier * (float)fortune) {
                    EntityItem entityitem = new EntityItem(world, (double)X + 0.5, (double)Y + 0.5, (double)Z + 0.5, new ItemStack(reward.item, 1, reward.meta));
                    double f3 = 0.05f;
                    entityitem.field_70159_w = world.field_73012_v.nextGaussian() * f3;
                    entityitem.field_70181_x = 0.2;
                    entityitem.field_70179_y = world.field_73012_v.nextGaussian() * f3;
                    world.func_72838_d((Entity)entityitem);
                }
                valid = true;
            }
        } else if (block.func_149688_o().func_76229_l() || block.getHarvestTool(blockMeta) == null) {
            return false;
        }
        item.func_77972_a(1, (EntityLivingBase)player);
        if (item.field_77994_a == 0) {
            player.func_71028_bD();
        }
        if (!world.field_72995_K) {
            world.func_147480_a(X, Y, Z, false);
        }
        return valid;
    }
}

