/*
 * Decompiled with CFR 0.152.
 */
package exnihilo.blocks.renderers;

import exnihilo.blocks.BlockSieve;
import exnihilo.blocks.models.ModelSieve;
import exnihilo.blocks.models.ModelSieveContents;
import exnihilo.blocks.models.ModelSieveMesh;
import exnihilo.blocks.tileentities.TileEntitySieve;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import org.lwjgl.opengl.GL11;

public class RenderSieve
extends TileEntitySpecialRenderer {
    private ModelSieve model;
    private ModelSieveMesh mesh;
    private ModelSieveContents contents;

    public RenderSieve(ModelSieve model, ModelSieveMesh mesh) {
        this.model = model;
        this.mesh = mesh;
        this.contents = new ModelSieveContents();
    }

    public void func_147500_a(TileEntity tileentity, double x, double y, double z, float f) {
        this.renderTable(tileentity, x, y, z, f);
        this.renderMesh(tileentity, x, y, z, f);
        this.renderContents(tileentity, x, y, z, f);
    }

    private void renderTable(TileEntity tileentity, double x, double y, double z, float f) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 1.5f), (float)((float)z + 0.5f));
        GL11.glScalef((float)-1.0f, (float)-1.0f, (float)1.0f);
        this.bindSieveTexture(tileentity.func_145832_p());
        this.model.simpleRender(0.0625f);
        GL11.glPopMatrix();
    }

    private void renderMesh(TileEntity tileentity, double x, double y, double z, float f) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 0.69f), (float)((float)z + 0.5f));
        this.func_147499_a(TextureMap.field_110575_b);
        this.mesh.render(BlockSieve.meshIcon);
        GL11.glPopMatrix();
    }

    private void renderContents(TileEntity tileentity, double x, double y, double z, float f) {
        TileEntitySieve sieve = (TileEntitySieve)tileentity;
        IIcon icon = null;
        switch (sieve.mode) {
            case FILLED: {
                icon = sieve.content.func_149691_a(0, sieve.contentMeta);
                break;
            }
        }
        if (sieve.mode != TileEntitySieve.SieveMode.EMPTY) {
            this.func_147499_a(TextureMap.field_110575_b);
            GL11.glPushMatrix();
            GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + sieve.getAdjustedVolume()), (float)((float)z + 0.5f));
            this.contents.renderTop(icon);
            GL11.glPopMatrix();
            GL11.glPushMatrix();
            GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 0.7f), (float)((float)z + 0.5f));
            this.contents.renderBottom(icon);
            GL11.glPopMatrix();
        }
    }

    public void bindSieveTexture(int meta) {
        if (meta >= 0) {
            this.func_147499_a(ModelSieve.textures[meta]);
        }
    }
}

