/*
 * Decompiled with CFR 0.152.
 */
package myrathi.flatsigns;

import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import myrathi.flatsigns.block.BlockFlatSign;
import myrathi.flatsigns.event.EventHandlers;
import myrathi.flatsigns.item.ItemSpongeWipe;
import myrathi.flatsigns.proxy.CommonProxy;
import myrathi.flatsigns.tileentity.TileEntityFlatSign;
import myrathi.flatsigns.util.Config;
import myrathi.flatsigns.util.Log;
import myrathi.flatsigns.util.Version;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;

@Mod(modid="FlatSigns", name="Flat Signs", useMetadata=true, version="2.1.0.19", certificateFingerprint="")
public class FlatSigns {
    @Mod.Instance(value="FlatSigns")
    private static FlatSigns _instance;
    @SidedProxy(clientSide="myrathi.flatsigns.proxy.ClientProxy", serverSide="myrathi.flatsigns.proxy.CommonProxy")
    public static CommonProxy _proxy;
    public static final Log log;
    public static BlockFlatSign blockFlatSign;
    public static ItemSpongeWipe itemSpongeWipe;

    public static FlatSigns instance() {
        return _instance;
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent evt) {
        Version.init(evt.getVersionProperties());
        evt.getModMetadata().version = Version.version();
        Config.load(evt.getSuggestedConfigurationFile());
        this.registerStuff();
        MinecraftForge.EVENT_BUS.register((Object)new EventHandlers());
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent evt) {
        GameRegistry.registerTileEntity(TileEntityFlatSign.class, (String)"Sign.Flat");
        _proxy.registerRenderInformation();
        this.registerRecipes();
    }

    private void registerStuff() {
        blockFlatSign = new BlockFlatSign();
        GameRegistry.registerBlock((Block)blockFlatSign, (String)"blockFlatSign");
        itemSpongeWipe = new ItemSpongeWipe();
        GameRegistry.registerItem((Item)itemSpongeWipe, (String)itemSpongeWipe.func_77658_a());
    }

    private void registerRecipes() {
        itemSpongeWipe.registerRecipes();
        ItemStack waterbottle = new ItemStack((Item)Items.field_151068_bn);
        boolean bottles = Config.allowRecipeSpongeBottles();
        boolean bucket = Config.allowRecipeSpongeBucket();
        if (bottles) {
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(Blocks.field_150360_v), (Object[])new Object[]{new ItemStack(Blocks.field_150325_L, 1, 4), waterbottle, waterbottle, waterbottle});
        }
        if (bucket) {
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(Blocks.field_150360_v), (Object[])new Object[]{new ItemStack(Blocks.field_150325_L, 1, 4), Items.field_151131_as});
        }
        log.info("[Recipes] Sponge: w/ bottles (%s), w/ bucket (%s)", bottles ? "on" : "off", bucket ? "on" : "off");
    }

    static {
        log = new Log("Flat Signs");
    }
}

