/*
 * Decompiled with CFR 0.152.
 */
package crazypants.util;

import crazypants.vecmath.Vector3d;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class EntityUtil {
    public static String getDisplayNameForEntity(String mobName) {
        return StatCollector.func_74838_a((String)("entity." + mobName + ".name"));
    }

    public static List<String> getAllRegisteredMobNames(boolean excludeBosses) {
        ArrayList<String> result = new ArrayList<String>();
        Set entries = EntityList.field_75626_c.entrySet();
        for (Map.Entry entry : entries) {
            if (!EntityLiving.class.isAssignableFrom((Class)entry.getKey()) || excludeBosses && IBossDisplayData.class.isAssignableFrom((Class)entry.getKey())) continue;
            result.add((String)entry.getValue());
        }
        return result;
    }

    private EntityUtil() {
    }

    public static Vector3d getEntityPosition(Entity ent) {
        return new Vector3d(ent.field_70165_t, ent.field_70163_u, ent.field_70161_v);
    }

    public static List<AxisAlignedBB> getCollidingBlockGeometry(World world, Entity entity) {
        AxisAlignedBB entityBounds = entity.field_70121_D;
        ArrayList<AxisAlignedBB> collidingBoundingBoxes = new ArrayList<AxisAlignedBB>();
        int minX = MathHelper.func_76128_c((double)entityBounds.field_72340_a);
        int minY = MathHelper.func_76128_c((double)entityBounds.field_72338_b);
        int minZ = MathHelper.func_76128_c((double)entityBounds.field_72339_c);
        int maxX = MathHelper.func_76128_c((double)(entityBounds.field_72336_d + 1.0));
        int maxY = MathHelper.func_76128_c((double)(entityBounds.field_72337_e + 1.0));
        int maxZ = MathHelper.func_76128_c((double)(entityBounds.field_72334_f + 1.0));
        for (int x = minX; x < maxX; ++x) {
            for (int z = minZ; z < maxZ; ++z) {
                for (int y = minY; y < maxY; ++y) {
                    Block block = world.func_147439_a(x, y, z);
                    if (block == null) continue;
                    block.func_149743_a(world, x, y, z, entityBounds, collidingBoundingBoxes, entity);
                }
            }
        }
        return collidingBoundingBoxes;
    }

    public static void spawnItemInWorldWithRandomMotion(World world, ItemStack item, int x, int y, int z) {
        if (item != null) {
            EntityUtil.spawnItemInWorldWithRandomMotion(world, item, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5);
        }
    }

    public static void spawnItemInWorldWithRandomMotion(World world, ItemStack item, double x, double y, double z) {
        if (item != null) {
            EntityUtil.spawnItemInWorldWithRandomMotion(new EntityItem(world, x, y, z, item));
        }
    }

    public static void spawnItemInWorldWithRandomMotion(EntityItem entity) {
        entity.field_145804_b = 10;
        float f = entity.field_70170_p.field_73012_v.nextFloat() * 0.1f - 0.05f;
        float f1 = entity.field_70170_p.field_73012_v.nextFloat() * 0.1f - 0.05f;
        float f2 = entity.field_70170_p.field_73012_v.nextFloat() * 0.1f - 0.05f;
        entity.field_70159_w += (double)f;
        entity.field_70181_x += (double)f1;
        entity.field_70179_y += (double)f2;
        entity.field_70170_p.func_72838_d((Entity)entity);
    }
}

