/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import crazypants.enderio.EnderIO;
import crazypants.enderio.ModObject;
import crazypants.enderio.gui.IconEIO;
import crazypants.enderio.machine.IMachineRecipe;
import crazypants.enderio.machine.MachineRecipeRegistry;
import crazypants.enderio.machine.power.PowerDisplayUtil;
import crazypants.enderio.machine.soul.GuiSoulBinder;
import crazypants.enderio.machine.soul.ISoulBinderRecipe;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import org.lwjgl.opengl.GL11;

public class SoulBinderRecipeHandler
extends TemplateRecipeHandler {
    private static final ArrayList<PositionedStack> EMPTY_VIAL_OUTPUT = new ArrayList();

    public String getRecipeName() {
        return StatCollector.func_74838_a((String)"enderio.nei.soulbinder");
    }

    public String getGuiTexture() {
        return "enderio:textures/gui/soulFuser.png";
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return GuiSoulBinder.class;
    }

    public String getOverlayIdentifier() {
        return "EnderIOSoulBinder";
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(149, 32, 16, 16), "EnderIOSoulBinder", new Object[0]));
    }

    public void loadCraftingRecipes(ItemStack result) {
        if (result == null || result.func_77973_b() == null) {
            return;
        }
        Map<String, IMachineRecipe> recipes = MachineRecipeRegistry.instance.getRecipesForMachine(ModObject.blockSoulBinder.unlocalisedName);
        if (recipes.isEmpty()) {
            return;
        }
        for (IMachineRecipe recipe : recipes.values()) {
            ISoulBinderRecipe sbr;
            if (!(recipe instanceof ISoulBinderRecipe) || !(sbr = (ISoulBinderRecipe)((Object)recipe)).getOutputStack().func_77969_a(result)) continue;
            this.arecipes.add(new SoulBinderRecipeNEI((ISoulBinderRecipe)((Object)recipe)));
        }
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("EnderIOSoulBinder") && ((Object)((Object)this)).getClass() == SoulBinderRecipeHandler.class) {
            Map<String, IMachineRecipe> recipes = MachineRecipeRegistry.instance.getRecipesForMachine(ModObject.blockSoulBinder.unlocalisedName);
            if (recipes.isEmpty()) {
                return;
            }
            for (IMachineRecipe recipe : recipes.values()) {
                if (!(recipe instanceof ISoulBinderRecipe)) continue;
                this.arecipes.add(new SoulBinderRecipeNEI((ISoulBinderRecipe)((Object)recipe)));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        if (ingredient == null || ingredient.func_77973_b() == null) {
            return;
        }
        Map<String, IMachineRecipe> recipes = MachineRecipeRegistry.instance.getRecipesForMachine(ModObject.blockSoulBinder.unlocalisedName);
        if (recipes.isEmpty()) {
            return;
        }
        for (IMachineRecipe recipe : recipes.values()) {
            SoulBinderRecipeNEI sbr;
            if (!(recipe instanceof ISoulBinderRecipe) || !(sbr = new SoulBinderRecipeNEI((ISoulBinderRecipe)((Object)recipe))).contains(sbr.input, ingredient)) continue;
            this.arecipes.add(sbr);
        }
    }

    public void drawBackground(int recipeIndex) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((String)this.getGuiTexture());
        GuiDraw.drawTexturedModalRect((int)18, (int)0, (int)29, (int)11, (int)142, (int)65);
    }

    public void drawExtras(int recipeIndex) {
        this.drawProgressBar(70, 23, 177, 14, 23, 17, 160, 0);
        SoulBinderRecipeNEI recipe = (SoulBinderRecipeNEI)((Object)this.arecipes.get(recipeIndex));
        String energyString = PowerDisplayUtil.formatPower(recipe.getEnergy()) + " " + PowerDisplayUtil.abrevation();
        GuiDraw.drawStringC((String)energyString, (int)83, (int)45, (int)0x808080, (boolean)false);
        int cost = recipe.getExperience();
        if (cost > 0) {
            String s = I18n.func_135052_a((String)"container.repair.cost", (Object[])new Object[]{cost});
            GuiDraw.drawStringC((String)s, (int)83, (int)55, (int)8453920);
        }
        IconEIO.RECIPE_BUTTON.renderIcon(149.0, 32.0, 16.0, 16.0, 0.0, true);
    }

    static {
        EMPTY_VIAL_OUTPUT.add(new PositionedStack((Object)new ItemStack((Item)EnderIO.itemSoulVessel), 101, 23));
    }

    public class SoulBinderRecipeNEI
    extends TemplateRecipeHandler.CachedRecipe {
        private final ArrayList<PositionedStack> input;
        private final PositionedStack output;
        private int energy;
        private int experience;

        public int getEnergy() {
            return this.energy;
        }

        public int getExperience() {
            return this.experience;
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(SoulBinderRecipeHandler.this.cycleticks / 20, this.input);
        }

        public PositionedStack getResult() {
            return this.output;
        }

        public List<PositionedStack> getOtherStacks() {
            return EMPTY_VIAL_OUTPUT;
        }

        public SoulBinderRecipeNEI(ISoulBinderRecipe recipe) {
            this(recipe.getInputStack(), recipe.getOutputStack(), recipe.getEnergyRequired(), recipe.getExperienceRequired(), recipe.getSupportedSouls());
        }

        public SoulBinderRecipeNEI(ItemStack inputStack, ItemStack result, int energy, int experience, List<String> list) {
            super((TemplateRecipeHandler)SoulBinderRecipeHandler.this);
            this.input = new ArrayList();
            int yOff = 11;
            int xOff = 11;
            this.input.add(new PositionedStack(this.getSoulVialInputs(list), 38 - xOff, 34 - yOff));
            this.input.add(new PositionedStack((Object)inputStack, 59 - xOff, 34 - yOff));
            this.output = new PositionedStack((Object)result, 134 - xOff, 34 - yOff);
            this.energy = energy;
            this.experience = experience;
        }

        private List<ItemStack> getSoulVialInputs(List<String> mobs) {
            ArrayList<ItemStack> result = new ArrayList<ItemStack>(mobs.size());
            for (String mobName : mobs) {
                ItemStack sv = new ItemStack((Item)EnderIO.itemSoulVessel);
                sv.field_77990_d = new NBTTagCompound();
                sv.field_77990_d.func_74778_a("id", mobName);
                result.add(sv);
            }
            return result;
        }
    }
}

