/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.vat;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import crazypants.enderio.EnderIO;
import crazypants.enderio.machine.IMachineRecipe;
import crazypants.enderio.machine.IPoweredTask;
import crazypants.enderio.machine.MachineRecipeInput;
import crazypants.enderio.machine.PoweredTaskProgress;
import crazypants.enderio.machine.vat.TileVat;
import crazypants.enderio.network.MessageTileEntity;
import io.netty.buffer.ByteBuf;
import net.minecraftforge.fluids.FluidRegistry;

public class PacketVatProgress
extends MessageTileEntity<TileVat>
implements IMessageHandler<PacketVatProgress, IMessage> {
    private float progress = 0.0f;
    private int inputFluidId = -1;
    private int outputFluidId = -1;

    public PacketVatProgress() {
    }

    public PacketVatProgress(TileVat vat) {
        super(vat);
        this.progress = vat.getProgress();
        IPoweredTask task = vat.getCurrentTask();
        if (task == null) {
            return;
        }
        for (MachineRecipeInput input : task.getInputs()) {
            if (input.fluid == null || input.fluid.getFluid() == null) continue;
            this.inputFluidId = input.fluid.getFluid().getID();
            break;
        }
        IMachineRecipe rec = task.getRecipe();
        for (IMachineRecipe.ResultStack res : rec.getCompletedResult(1.0f, task.getInputs())) {
            if (res.fluid == null || res.fluid.getFluid() == null) continue;
            this.outputFluidId = res.fluid.getFluid().getID();
        }
    }

    @Override
    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeFloat(this.progress);
        buf.writeInt(this.inputFluidId);
        buf.writeInt(this.outputFluidId);
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.progress = buf.readFloat();
        this.inputFluidId = buf.readInt();
        this.outputFluidId = buf.readInt();
    }

    public IMessage onMessage(PacketVatProgress message, MessageContext ctx) {
        TileVat tile = (TileVat)message.getTileEntity(EnderIO.proxy.getClientWorld());
        if (tile != null) {
            tile.currentTaskInputFluid = null;
            tile.currentTaskOutputFluid = null;
            if (message.progress < 0.0f) {
                tile.setClientTask(null);
            } else {
                tile.setClientTask(new PoweredTaskProgress(message.progress));
                if (message.inputFluidId > 0) {
                    tile.currentTaskInputFluid = FluidRegistry.getFluid((int)message.inputFluidId);
                }
                if (message.outputFluidId > 0) {
                    tile.currentTaskOutputFluid = FluidRegistry.getFluid((int)message.outputFluidId);
                }
            }
        }
        return null;
    }
}

