/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.power;

import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.BlockEio;
import crazypants.enderio.EnderIO;
import crazypants.enderio.ModObject;
import crazypants.enderio.gui.IAdvancedTooltipProvider;
import crazypants.enderio.gui.TooltipAddera;
import crazypants.enderio.machine.IoMode;
import crazypants.enderio.machine.power.BlockItemCapacitorBank;
import crazypants.enderio.machine.power.ContainerCapacitorBank;
import crazypants.enderio.machine.power.GuiCapacitorBank;
import crazypants.enderio.machine.power.PacketClientState;
import crazypants.enderio.machine.power.PacketPowerStorage;
import crazypants.enderio.machine.power.PowerDisplayUtil;
import crazypants.enderio.machine.power.TileCapacitorBank;
import crazypants.enderio.network.PacketHandler;
import crazypants.enderio.power.PowerHandlerUtil;
import crazypants.enderio.tool.ToolUtil;
import crazypants.enderio.waila.IWailaInfoProvider;
import crazypants.util.BlockCoord;
import crazypants.util.Lang;
import crazypants.util.Util;
import crazypants.vecmath.Vector3d;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockCapacitorBank
extends BlockEio
implements IGuiHandler,
IAdvancedTooltipProvider,
IWailaInfoProvider {
    public static int renderId = -1;
    IIcon overlayIcon;
    IIcon fillBarIcon;
    private IIcon blockIconInput;
    private IIcon blockIconOutput;
    private IIcon blockIconLocked;

    public static BlockCapacitorBank create() {
        PacketHandler.INSTANCE.registerMessage(PacketClientState.class, PacketClientState.class, PacketHandler.nextID(), Side.SERVER);
        PacketHandler.INSTANCE.registerMessage(PacketPowerStorage.class, PacketPowerStorage.class, PacketHandler.nextID(), Side.CLIENT);
        BlockCapacitorBank res = new BlockCapacitorBank();
        res.init();
        return res;
    }

    protected BlockCapacitorBank() {
        super(ModObject.blockCapacitorBank.unlocalisedName, TileCapacitorBank.class);
        this.func_149711_c(2.0f);
        this.func_149647_a(null);
    }

    @Override
    protected void init() {
        GameRegistry.registerBlock((Block)this, BlockItemCapacitorBank.class, (String)this.name);
        if (this.teClass != null) {
            GameRegistry.registerTileEntity((Class)this.teClass, (String)(this.name + "TileEntity"));
        }
        EnderIO.guiHandler.registerGuiHandler(5, this);
        this.func_149713_g(255);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item p_149666_1_, CreativeTabs p_149666_2_, List list) {
        ItemStack is = BlockItemCapacitorBank.createItemStackWithPower(0);
        list.add(is);
        is = BlockItemCapacitorBank.createItemStackWithPower(TileCapacitorBank.BASE_CAP.getMaxEnergyStored());
        list.add(is);
        is = BlockItemCapacitorBank.createItemStackWithPower(TileCapacitorBank.BASE_CAP.getMaxEnergyStored() / 2);
        is.func_77964_b(1);
        list.add(is);
    }

    public int func_149692_a(int par1) {
        return par1;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addCommonEntries(ItemStack itemstack, EntityPlayer entityplayer, List list, boolean flag) {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addBasicEntries(ItemStack itemstack, EntityPlayer entityplayer, List list, boolean flag) {
        list.add(PowerDisplayUtil.formatStoredPower(PowerHandlerUtil.getStoredEnergyForItem(itemstack), TileCapacitorBank.BASE_CAP.getMaxEnergyStored()));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addDetailedEntries(ItemStack itemstack, EntityPlayer entityplayer, List list, boolean flag) {
        TooltipAddera.addDetailedTooltipFromResources(list, itemstack);
    }

    @Override
    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer entityPlayer, int side, float par7, float par8, float par9) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (!(te instanceof TileCapacitorBank)) {
            return false;
        }
        if (ToolUtil.isToolEquipped(entityPlayer)) {
            ForgeDirection faceHit = ForgeDirection.getOrientation((int)side);
            TileCapacitorBank tcb = (TileCapacitorBank)te;
            tcb.toggleIoModeForFace(faceHit);
            if (world.field_72995_K) {
                world.func_147471_g(x, y, z);
            } else {
                world.func_147459_d(x, y, z, (Block)EnderIO.blockCapacitorBank);
                world.func_147471_g(x, y, z);
            }
            return true;
        }
        return super.func_149727_a(world, x, y, z, entityPlayer, side, par7, par8, par9);
    }

    @Override
    protected boolean openGui(World world, int x, int y, int z, EntityPlayer entityPlayer, int side) {
        if (!world.field_72995_K) {
            entityPlayer.openGui((Object)EnderIO.instance, 5, world, x, y, z);
        }
        return true;
    }

    public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileCapacitorBank) {
            return new ContainerCapacitorBank((Entity)player, player.field_71071_by, ((TileCapacitorBank)te).getController());
        }
        return null;
    }

    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileCapacitorBank) {
            return new GuiCapacitorBank((Entity)player, player.field_71071_by, ((TileCapacitorBank)te).getController());
        }
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister IIconRegister2) {
        this.field_149761_L = IIconRegister2.func_94245_a("enderio:capacitorBank");
        this.blockIconInput = IIconRegister2.func_94245_a("enderio:capacitorBankInput");
        this.blockIconOutput = IIconRegister2.func_94245_a("enderio:capacitorBankOutput");
        this.blockIconLocked = IIconRegister2.func_94245_a("enderio:capacitorBankLocked");
        this.overlayIcon = IIconRegister2.func_94245_a("enderio:capacitorBankOverlays");
        this.fillBarIcon = IIconRegister2.func_94245_a("enderio:capacitorBankFillBar");
    }

    public int func_149645_b() {
        return renderId;
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        return true;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149646_a(IBlockAccess par1IBlockAccess, int par2, int par3, int par4, int par5) {
        Block i1 = par1IBlockAccess.func_147439_a(par2, par3, par4);
        return i1 == this ? false : super.func_149646_a(par1IBlockAccess, par2, par3, par4, par5);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess ba, int x, int y, int z, int side) {
        TileEntity te = ba.func_147438_o(x, y, z);
        if (!(te instanceof TileCapacitorBank)) {
            return this.field_149761_L;
        }
        TileCapacitorBank cb = (TileCapacitorBank)te;
        IoMode mode = cb.getIoMode(ForgeDirection.values()[side]);
        if (mode == null || mode == IoMode.NONE) {
            return this.field_149761_L;
        }
        if (mode == IoMode.PULL) {
            return this.blockIconInput;
        }
        if (mode == IoMode.PUSH) {
            return this.blockIconOutput;
        }
        return this.blockIconLocked;
    }

    public void func_149726_b(World world, int x, int y, int z) {
        if (world.field_72995_K) {
            return;
        }
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileCapacitorBank) {
            TileCapacitorBank tr = (TileCapacitorBank)te;
            int meta = world.func_72805_g(x, y, z);
            if (meta == 1) {
                tr.setCreativeMode();
            }
            tr.onBlockAdded();
        }
    }

    public void func_149695_a(World world, int x, int y, int z, Block blockId) {
        if (world.field_72995_K) {
            return;
        }
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileCapacitorBank) {
            TileCapacitorBank te = (TileCapacitorBank)tile;
            te.onNeighborBlockChange(blockId);
        }
    }

    @Override
    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        TileEntity te;
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        if (!world.field_72995_K && (te = world.func_147438_o(x, y, z)) instanceof TileCapacitorBank) {
            TileCapacitorBank cb = (TileCapacitorBank)te;
            cb.onBreakBlock();
            ItemStack itemStack = BlockItemCapacitorBank.createItemStackWithPower(cb.doGetEnergyStored());
            ret.add(itemStack);
        }
        return ret;
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z) {
        TileEntity te;
        if (!world.field_72995_K && (te = world.func_147438_o(x, y, z)) instanceof TileCapacitorBank) {
            TileCapacitorBank cb = (TileCapacitorBank)te;
            cb.onBreakBlock();
            if (!player.field_71075_bZ.field_75098_d || "true".equalsIgnoreCase(System.getProperty("blockCapBankAllwaysDrop"))) {
                ItemStack itemStack = BlockItemCapacitorBank.createItemStackWithPower(cb.doGetEnergyStored());
                if (cb.isCreative()) {
                    itemStack.func_77964_b(1);
                }
                float f = 0.7f;
                double d0 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                double d1 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                double d2 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                EntityItem entityitem = new EntityItem(world, (double)x + d0, (double)y + d1, (double)z + d2, itemStack);
                entityitem.field_145804_b = 10;
                world.func_72838_d((Entity)entityitem);
            }
        }
        return super.removedByPlayer(world, player, x, y, z);
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase player, ItemStack stack) {
        if (world.field_72995_K) {
            return;
        }
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileCapacitorBank) {
            TileCapacitorBank cb = (TileCapacitorBank)te;
            cb.addEnergy(PowerHandlerUtil.getStoredEnergyForItem(stack));
            if (player instanceof EntityPlayer) {
                for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                    BlockCoord bc = new BlockCoord(x, y, z);
                    bc = bc.getLocation(dir);
                    te = world.func_147438_o(bc.x, bc.y, bc.z);
                    if (!(te instanceof TileCapacitorBank) || !((TileCapacitorBank)te).isMaxSize()) continue;
                    ((EntityPlayer)player).func_146105_b((IChatComponent)new ChatComponentText("Capacitor bank is at maximum size"));
                }
            }
        }
        world.func_147471_g(x, y, z);
    }

    public int func_149745_a(Random r) {
        return 0;
    }

    @Override
    public void func_149749_a(World world, int x, int y, int z, Block par5, int par6) {
        if (!world.field_72995_K && world.func_82736_K().func_82766_b("doTileDrops")) {
            TileEntity te = world.func_147438_o(x, y, z);
            if (!(te instanceof TileCapacitorBank)) {
                super.func_149749_a(world, x, y, z, par5, par6);
                return;
            }
            TileCapacitorBank cb = (TileCapacitorBank)te;
            Util.dropItems(world, cb, x, y, z, true);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_149633_g(World world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (!(te instanceof TileCapacitorBank)) {
            return super.func_149633_g(world, x, y, z);
        }
        TileCapacitorBank tr = (TileCapacitorBank)te;
        if (!tr.isMultiblock()) {
            return super.func_149633_g(world, x, y, z);
        }
        Vector3d min = new Vector3d(Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE);
        Vector3d max = new Vector3d(-1.7976931348623157E308, -1.7976931348623157E308, -1.7976931348623157E308);
        for (BlockCoord bc : tr.multiblock) {
            min.x = Math.min(min.x, (double)bc.x);
            max.x = Math.max(max.x, (double)(bc.x + 1));
            min.y = Math.min(min.y, (double)bc.y);
            max.y = Math.max(max.y, (double)(bc.y + 1));
            min.z = Math.min(min.z, (double)bc.z);
            max.z = Math.max(max.z, (double)(bc.z + 1));
        }
        return AxisAlignedBB.func_72330_a((double)min.x, (double)min.y, (double)min.z, (double)max.x, (double)max.y, (double)max.z);
    }

    public boolean func_149740_M() {
        return true;
    }

    public int func_149736_g(World w, int x, int y, int z, int side) {
        TileEntity te = w.func_147438_o(x, y, z);
        if (te instanceof TileCapacitorBank) {
            return ((TileCapacitorBank)te).getComparatorOutput();
        }
        return 0;
    }

    @Override
    public void getWailaInfo(List<String> tooltip, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileCapacitorBank) {
            TileCapacitorBank cap = (TileCapacitorBank)te;
            String format = Util.TAB + Util.ALIGNRIGHT + EnumChatFormatting.WHITE;
            tooltip.add(String.format("%s : %s%s%sRF/t ", Lang.localize("capbank.maxIO"), format, fmt.format(cap.getMaxIO()), Util.TAB + Util.ALIGNRIGHT));
            tooltip.add(String.format("%s : %s%s%sRF/t ", Lang.localize("capbank.maxIn"), format, fmt.format(cap.getMaxInput()), Util.TAB + Util.ALIGNRIGHT));
            tooltip.add(String.format("%s : %s%s%sRF/t ", Lang.localize("capbank.maxOut"), format, fmt.format(cap.getMaxOutput()), Util.TAB + Util.ALIGNRIGHT));
            tooltip.add("Deprecated. Convert by placing in crafting grid");
        }
    }

    @Override
    public int getDefaultDisplayMask(World world, int x, int y, int z) {
        return 4;
    }
}

