/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.hypercube;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.relauncher.Side;
import crazypants.enderio.BlockEio;
import crazypants.enderio.EnderIO;
import crazypants.enderio.ModObject;
import crazypants.enderio.gui.IResourceTooltipProvider;
import crazypants.enderio.machine.hypercube.Channel;
import crazypants.enderio.machine.hypercube.ConnectionHandler;
import crazypants.enderio.machine.hypercube.ContainerHyperCube;
import crazypants.enderio.machine.hypercube.GuiHyperCube;
import crazypants.enderio.machine.hypercube.ItemRecieveBuffer;
import crazypants.enderio.machine.hypercube.PacketAddRemoveChannel;
import crazypants.enderio.machine.hypercube.PacketChannelList;
import crazypants.enderio.machine.hypercube.PacketClientState;
import crazypants.enderio.machine.hypercube.PacketStoredPower;
import crazypants.enderio.machine.hypercube.TileHyperCube;
import crazypants.enderio.network.PacketHandler;
import crazypants.enderio.power.PowerHandlerUtil;
import crazypants.util.Util;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockHyperCube
extends BlockEio
implements IGuiHandler,
IResourceTooltipProvider {
    static final NumberFormat NF = NumberFormat.getIntegerInstance();

    public static BlockHyperCube create() {
        PacketHandler.INSTANCE.registerMessage(PacketChannelList.class, PacketChannelList.class, PacketHandler.nextID(), Side.CLIENT);
        PacketHandler.INSTANCE.registerMessage(PacketClientState.class, PacketClientState.class, PacketHandler.nextID(), Side.SERVER);
        PacketHandler.INSTANCE.registerMessage(PacketAddRemoveChannel.class, PacketAddRemoveChannel.class, PacketHandler.nextID(), Side.SERVER);
        PacketHandler.INSTANCE.registerMessage(PacketAddRemoveChannel.class, PacketAddRemoveChannel.class, PacketHandler.nextID(), Side.CLIENT);
        PacketHandler.INSTANCE.registerMessage(PacketStoredPower.class, PacketStoredPower.class, PacketHandler.nextID(), Side.CLIENT);
        BlockHyperCube result = new BlockHyperCube();
        result.init();
        ConnectionHandler ch = new ConnectionHandler();
        FMLCommonHandler.instance().bus().register((Object)ch);
        MinecraftForge.EVENT_BUS.register((Object)ch);
        return result;
    }

    private BlockHyperCube() {
        super(ModObject.blockHyperCube.unlocalisedName, TileHyperCube.class);
        this.func_149647_a(null);
    }

    @Override
    protected void init() {
        super.init();
        EnderIO.guiHandler.registerGuiHandler(7, this);
    }

    public IIcon getPortalIcon() {
        return this.field_149761_L;
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        return true;
    }

    @Override
    public void func_149651_a(IIconRegister IIconRegister2) {
        this.field_149761_L = IIconRegister2.func_94245_a("enderio:tesseractPortal");
    }

    public int func_149645_b() {
        return -1;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        return 8;
    }

    public void func_149726_b(World world, int x, int y, int z) {
        if (world.field_72995_K) {
            return;
        }
        TileHyperCube tr = (TileHyperCube)world.func_147438_o(x, y, z);
        tr.onBlockAdded();
    }

    public void func_149695_a(World world, int x, int y, int z, Block blockId) {
        if (world.field_72995_K) {
            return;
        }
        TileHyperCube te = (TileHyperCube)world.func_147438_o(x, y, z);
        te.onNeighborBlockChange();
    }

    @Override
    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        TileEntity te;
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        if (!world.field_72995_K && (te = world.func_147438_o(x, y, z)) instanceof TileHyperCube) {
            TileHyperCube hc = (TileHyperCube)te;
            hc.onBreakBlock();
            ItemStack itemStack = new ItemStack((Block)this);
            PowerHandlerUtil.setStoredEnergyForItem(itemStack, hc.getEnergyStored());
            this.setChannelOnItem(hc, itemStack);
            this.setIoOnItem(hc, itemStack);
            ret.add(itemStack);
            ItemRecieveBuffer rb = hc.getRecieveBuffer();
            for (int i = 0; i < rb.func_70302_i_(); ++i) {
                ItemStack stack = rb.func_70301_a(i);
                if (stack == null) continue;
                ret.add(stack);
            }
        }
        return ret;
    }

    private void setChannelOnItem(TileHyperCube hc, ItemStack itemStack) {
        Channel chan = hc.getChannel();
        if (chan != null) {
            NBTTagCompound tag = itemStack.func_77978_p();
            if (tag == null) {
                tag = new NBTTagCompound();
                itemStack.func_77982_d(tag);
            }
            tag.func_74778_a("channelName", chan.name);
            tag.func_74757_a("channelIsPublic", chan.isPublic());
            if (!chan.isPublic()) {
                tag.func_74778_a("channelUser", chan.user.toString());
            }
        }
    }

    private void setIoOnItem(TileHyperCube hc, ItemStack itemStack) {
        NBTTagCompound tag = itemStack.func_77978_p();
        if (tag == null) {
            tag = new NBTTagCompound();
            itemStack.func_77982_d(tag);
        }
        for (TileHyperCube.SubChannel sc : TileHyperCube.SubChannel.values()) {
            tag.func_74777_a("sendRecieve" + sc.ordinal(), (short)hc.getModeForChannel(sc).ordinal());
        }
    }

    private void setIoOnTransciever(TileHyperCube hc, ItemStack itemStack) {
        NBTTagCompound tag = itemStack.func_77978_p();
        if (tag == null) {
            return;
        }
        for (TileHyperCube.SubChannel sc : TileHyperCube.SubChannel.values()) {
            if (!tag.func_74764_b("sendRecieve" + sc.ordinal())) continue;
            hc.setModeForChannel(sc, TileHyperCube.IoMode.values()[tag.func_74765_d("sendRecieve" + sc.ordinal())]);
        }
    }

    private Channel getChannelFromItem(ItemStack itemStack) {
        NBTTagCompound tag = itemStack.func_77978_p();
        if (tag == null) {
            return null;
        }
        String channelName = tag.func_74779_i("channelName");
        if (channelName == null || channelName.trim().isEmpty()) {
            return null;
        }
        String user = null;
        if (!tag.func_74767_n("channelIsPublic")) {
            user = tag.func_74779_i("channelUser");
        }
        return new Channel(channelName, user);
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z) {
        TileEntity te;
        if (!world.field_72995_K && (te = world.func_147438_o(x, y, z)) instanceof TileHyperCube) {
            TileHyperCube hc = (TileHyperCube)te;
            hc.onBreakBlock();
            ItemStack itemStack = new ItemStack((Block)this);
            PowerHandlerUtil.setStoredEnergyForItem(itemStack, hc.getEnergyStored());
            this.setChannelOnItem(hc, itemStack);
            this.setIoOnItem(hc, itemStack);
            float f = 0.7f;
            double d0 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double d1 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double d2 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            EntityItem entityitem = new EntityItem(world, (double)x + d0, (double)y + d1, (double)z + d2, itemStack);
            entityitem.field_145804_b = 10;
            world.func_72838_d((Entity)entityitem);
            ItemRecieveBuffer rb = hc.getRecieveBuffer();
            Util.dropItems(world, rb, x, y, z, true);
        }
        return super.removedByPlayer(world, player, x, y, z);
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase player, ItemStack stack) {
        if (world.field_72995_K) {
            return;
        }
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileHyperCube) {
            TileHyperCube cb = (TileHyperCube)te;
            cb.setEnergyStored(PowerHandlerUtil.getStoredEnergyForItem(stack));
            if (player instanceof EntityPlayerMP) {
                cb.setOwner(((EntityPlayerMP)player).func_146103_bH().getName());
            }
            cb.setChannel(this.getChannelFromItem(stack));
            this.setIoOnTransciever(cb, stack);
        }
        world.func_147471_g(x, y, z);
    }

    public int func_149745_a(Random r) {
        return 0;
    }

    @Override
    protected boolean openGui(World world, int x, int y, int z, EntityPlayer entityPlayer, int side) {
        if (!world.field_72995_K) {
            entityPlayer.openGui((Object)EnderIO.instance, 7, world, x, y, z);
        }
        return true;
    }

    public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerHyperCube();
    }

    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileHyperCube) {
            TileHyperCube hc = (TileHyperCube)te;
            return new GuiHyperCube(hc);
        }
        return null;
    }

    @Override
    public String getUnlocalizedNameForTooltip(ItemStack stack) {
        return this.func_149739_a();
    }
}

