/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.farm.farmers;

import crazypants.enderio.machine.farm.TileFarmStation;
import crazypants.enderio.machine.farm.farmers.HarvestResult;
import crazypants.enderio.machine.farm.farmers.TreeFarmer;
import crazypants.util.BlockCoord;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockNewLeaf;
import net.minecraft.block.BlockOldLeaf;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TreeHarvestUtil {
    private int horizontalRange;
    private int verticalRange;
    private BlockCoord origin;

    public static boolean canDropApples(Block block, int meta) {
        return block instanceof BlockOldLeaf && (meta == 0 || meta == 8) || block instanceof BlockNewLeaf && (meta == 1 || meta == 9);
    }

    public void harvest(TileFarmStation farm, TreeFarmer farmer, BlockCoord bc, HarvestResult res) {
        this.horizontalRange = farm.getFarmSize() + 7;
        this.verticalRange = 30;
        this.harvest(farm.func_145831_w(), farm.getLocation(), bc, res, farmer.getIgnoreMeta());
    }

    public void harvest(World world, BlockCoord bc, HarvestResult res) {
        this.horizontalRange = 12;
        this.verticalRange = 30;
        this.origin = new BlockCoord(bc);
        Block wood = world.func_147439_a(bc.x, bc.y, bc.z);
        int woodMeta = world.func_72805_g(bc.x, bc.y, bc.z);
        this.harvestUp(world, bc, res, new HarvestTarget(wood, woodMeta));
    }

    private void harvest(World world, BlockCoord origin, BlockCoord bc, HarvestResult res, boolean ignoreMeta) {
        this.origin = new BlockCoord(origin);
        Block wood = world.func_147439_a(bc.x, bc.y, bc.z);
        int woodMeta = world.func_72805_g(bc.x, bc.y, bc.z);
        if (ignoreMeta) {
            this.harvestUp(world, bc, res, new BaseHarvestTarget(wood));
        } else {
            this.harvestUp(world, bc, res, new HarvestTarget(wood, woodMeta));
        }
    }

    protected void harvestUp(World world, BlockCoord bc, HarvestResult res, BaseHarvestTarget target) {
        if (!this.isInHarvestBounds(bc) || res.harvestedBlocks.contains(bc)) {
            return;
        }
        Block blk = world.func_147439_a(bc.x, bc.y, bc.z);
        boolean isLeaves = blk instanceof BlockLeaves;
        if (target.isTarget(blk, world.func_72805_g(bc.x, bc.y, bc.z)) || isLeaves) {
            res.harvestedBlocks.add(bc);
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                if (dir == ForgeDirection.DOWN) continue;
                this.harvestUp(world, bc.getLocation(dir), res, target);
            }
        } else {
            this.harvestAdjacentWood(world, bc, res, target);
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                if (dir.offsetY != 0) continue;
                BlockCoord loc = bc.getLocation(dir);
                Block targetBlock = world.func_147439_a(loc.x, loc.y, loc.z);
                if (!(targetBlock instanceof BlockLeaves)) continue;
                this.harvestAdjacentWood(world, bc, res, target);
            }
        }
    }

    private void harvestAdjacentWood(World world, BlockCoord bc, HarvestResult res, BaseHarvestTarget target) {
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            if (dir.offsetY != 0) continue;
            BlockCoord loc = bc.getLocation(dir);
            Block targetBlock = world.func_147439_a(loc.x, loc.y, loc.z);
            if (!target.isTarget(targetBlock, world.func_72805_g(loc.x, loc.y, loc.z))) continue;
            this.harvestUp(world, bc.getLocation(dir), res, target);
        }
    }

    private boolean isInHarvestBounds(BlockCoord bc) {
        int dist = Math.abs(this.origin.x - bc.x);
        if (dist > this.horizontalRange) {
            return false;
        }
        dist = Math.abs(this.origin.z - bc.z);
        if (dist > this.horizontalRange) {
            return false;
        }
        dist = Math.abs(this.origin.y - bc.y);
        return dist <= this.verticalRange;
    }

    private static class BaseHarvestTarget {
        private final Block wood;

        BaseHarvestTarget(Block wood) {
            this.wood = wood;
        }

        boolean isTarget(Block blk, int meta) {
            return blk == this.wood;
        }
    }

    private static final class HarvestTarget
    extends BaseHarvestTarget {
        private final int woodMeta;

        HarvestTarget(Block wood, int woodMeta) {
            super(wood);
            this.woodMeta = woodMeta;
        }

        @Override
        boolean isTarget(Block blk, int meta) {
            return super.isTarget(blk, meta) && (meta & 3) == (this.woodMeta & 3);
        }
    }
}

