/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.capbank;

import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.BlockEio;
import crazypants.enderio.EnderIO;
import crazypants.enderio.ModObject;
import crazypants.enderio.TileEntityEio;
import crazypants.enderio.api.redstone.IRedstoneConnectable;
import crazypants.enderio.gui.IAdvancedTooltipProvider;
import crazypants.enderio.gui.TooltipAddera;
import crazypants.enderio.machine.IoMode;
import crazypants.enderio.machine.capbank.BlockItemCapBank;
import crazypants.enderio.machine.capbank.CapBankType;
import crazypants.enderio.machine.capbank.ContainerCapBank;
import crazypants.enderio.machine.capbank.GuiCapBank;
import crazypants.enderio.machine.capbank.InfoDisplayType;
import crazypants.enderio.machine.capbank.TileCapBank;
import crazypants.enderio.machine.capbank.network.CapBankClientNetwork;
import crazypants.enderio.machine.capbank.network.ICapBankNetwork;
import crazypants.enderio.machine.capbank.network.NetworkUtil;
import crazypants.enderio.machine.capbank.packet.PacketGuiChange;
import crazypants.enderio.machine.capbank.packet.PacketNetworkEnergyRequest;
import crazypants.enderio.machine.capbank.packet.PacketNetworkEnergyResponse;
import crazypants.enderio.machine.capbank.packet.PacketNetworkIdRequest;
import crazypants.enderio.machine.capbank.packet.PacketNetworkIdResponse;
import crazypants.enderio.machine.capbank.packet.PacketNetworkStateRequest;
import crazypants.enderio.machine.capbank.packet.PacketNetworkStateResponse;
import crazypants.enderio.machine.power.PowerDisplayUtil;
import crazypants.enderio.network.PacketHandler;
import crazypants.enderio.power.PowerHandlerUtil;
import crazypants.enderio.tool.ToolUtil;
import crazypants.enderio.waila.IWailaInfoProvider;
import crazypants.util.Lang;
import crazypants.util.Util;
import crazypants.vecmath.Vector3d;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockCapBank
extends BlockEio
implements IGuiHandler,
IAdvancedTooltipProvider,
IWailaInfoProvider,
IRedstoneConnectable {
    public static int renderId = -1;
    @SideOnly(value=Side.CLIENT)
    private IIcon gaugeIcon;
    @SideOnly(value=Side.CLIENT)
    private IIcon fillBarIcon;
    @SideOnly(value=Side.CLIENT)
    private IIcon[] blockIcons;
    @SideOnly(value=Side.CLIENT)
    private IIcon[] borderIcons;
    @SideOnly(value=Side.CLIENT)
    private IIcon[] inputIcons;
    @SideOnly(value=Side.CLIENT)
    private IIcon[] outputIcons;
    @SideOnly(value=Side.CLIENT)
    private IIcon[] lockedIcons;
    @SideOnly(value=Side.CLIENT)
    private IIcon infoPanelIcon;

    public static BlockCapBank create() {
        PacketHandler.INSTANCE.registerMessage(PacketNetworkStateResponse.class, PacketNetworkStateResponse.class, PacketHandler.nextID(), Side.CLIENT);
        PacketHandler.INSTANCE.registerMessage(PacketNetworkStateRequest.class, PacketNetworkStateRequest.class, PacketHandler.nextID(), Side.SERVER);
        PacketHandler.INSTANCE.registerMessage(PacketNetworkIdRequest.class, PacketNetworkIdRequest.class, PacketHandler.nextID(), Side.SERVER);
        PacketHandler.INSTANCE.registerMessage(PacketNetworkIdResponse.class, PacketNetworkIdResponse.class, PacketHandler.nextID(), Side.CLIENT);
        PacketHandler.INSTANCE.registerMessage(PacketNetworkEnergyRequest.class, PacketNetworkEnergyRequest.class, PacketHandler.nextID(), Side.SERVER);
        PacketHandler.INSTANCE.registerMessage(PacketNetworkEnergyResponse.class, PacketNetworkEnergyResponse.class, PacketHandler.nextID(), Side.CLIENT);
        PacketHandler.INSTANCE.registerMessage(PacketGuiChange.class, PacketGuiChange.class, PacketHandler.nextID(), Side.SERVER);
        BlockCapBank res = new BlockCapBank();
        res.init();
        return res;
    }

    protected BlockCapBank() {
        super(ModObject.blockCapBank.unlocalisedName, TileCapBank.class);
        this.func_149711_c(2.0f);
    }

    @Override
    protected void init() {
        GameRegistry.registerBlock((Block)this, BlockItemCapBank.class, (String)this.name);
        if (this.teClass != null) {
            GameRegistry.registerTileEntity((Class)this.teClass, (String)(this.name + "TileEntity"));
        }
        EnderIO.guiHandler.registerGuiHandler(142, this);
        this.func_149713_g(255);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item p_149666_1_, CreativeTabs p_149666_2_, List list) {
        int meta = 0;
        for (CapBankType type : CapBankType.types()) {
            if (type.isCreative()) {
                list.add(BlockItemCapBank.createItemStackWithPower(meta, type.getMaxEnergyStored() / 2));
            } else {
                list.add(BlockItemCapBank.createItemStackWithPower(meta, 0));
                list.add(BlockItemCapBank.createItemStackWithPower(meta, type.getMaxEnergyStored()));
            }
            ++meta;
        }
    }

    public int func_149692_a(int par1) {
        return par1;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addCommonEntries(ItemStack itemstack, EntityPlayer entityplayer, List list, boolean flag) {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addBasicEntries(ItemStack itemstack, EntityPlayer entityplayer, List list, boolean flag) {
        list.add(PowerDisplayUtil.formatStoredPower(PowerHandlerUtil.getStoredEnergyForItem(itemstack), CapBankType.getTypeFromMeta(itemstack.func_77960_j()).getMaxEnergyStored()));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addDetailedEntries(ItemStack itemstack, EntityPlayer entityplayer, List list, boolean flag) {
        TooltipAddera.addDetailedTooltipFromResources(list, itemstack);
    }

    @Override
    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer entityPlayer, int side, float par7, float par8, float par9) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (!(te instanceof TileCapBank)) {
            return false;
        }
        TileCapBank tcb = (TileCapBank)te;
        ForgeDirection faceHit = ForgeDirection.getOrientation((int)side);
        if (entityPlayer.func_70093_af() && entityPlayer.func_71045_bC() == null && faceHit.offsetY == 0) {
            InfoDisplayType newDisplayType = tcb.getDisplayType(faceHit).next();
            if (newDisplayType == InfoDisplayType.NONE) {
                tcb.setDefaultIoMode(faceHit);
            } else {
                tcb.setIoMode(faceHit, IoMode.DISABLED);
            }
            tcb.setDisplayType(faceHit, newDisplayType);
            return true;
        }
        if (!entityPlayer.func_70093_af() && ToolUtil.isToolEquipped(entityPlayer)) {
            IoMode ioMode = tcb.getIoMode(faceHit);
            if (faceHit.offsetY == 0) {
                if (ioMode == IoMode.DISABLED) {
                    InfoDisplayType newDisplayType = tcb.getDisplayType(faceHit).next();
                    tcb.setDisplayType(faceHit, newDisplayType);
                    if (newDisplayType == InfoDisplayType.NONE) {
                        tcb.setDefaultIoMode(faceHit);
                    }
                } else {
                    tcb.toggleIoModeForFace(faceHit);
                }
            } else {
                tcb.toggleIoModeForFace(faceHit);
            }
            if (world.field_72995_K) {
                world.func_147471_g(x, y, z);
            } else {
                world.func_147459_d(x, y, z, (Block)EnderIO.blockCapBank);
                world.func_147471_g(x, y, z);
            }
            return true;
        }
        return super.func_149727_a(world, x, y, z, entityPlayer, side, par7, par8, par9);
    }

    @Override
    public boolean doNormalDrops(World world, int x, int y, int z) {
        return false;
    }

    @Override
    protected boolean openGui(World world, int x, int y, int z, EntityPlayer entityPlayer, int side) {
        if (!world.field_72995_K) {
            entityPlayer.openGui((Object)EnderIO.instance, 142, world, x, y, z);
        }
        return true;
    }

    public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileCapBank) {
            return new ContainerCapBank((Entity)player, player.field_71071_by, (TileCapBank)te);
        }
        return null;
    }

    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileCapBank) {
            return new GuiCapBank((Entity)player, player.field_71071_by, (TileCapBank)te);
        }
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister IIconRegister2) {
        this.field_149761_L = IIconRegister2.func_94245_a("enderio:capacitorBank");
        this.gaugeIcon = IIconRegister2.func_94245_a("enderio:capacitorBankOverlays");
        this.fillBarIcon = IIconRegister2.func_94245_a("enderio:capacitorBankFillBar");
        this.infoPanelIcon = IIconRegister2.func_94245_a("enderio:capBankInfoPanel");
        this.blockIcons = new IIcon[CapBankType.types().size()];
        this.borderIcons = new IIcon[CapBankType.types().size()];
        this.inputIcons = new IIcon[CapBankType.types().size()];
        this.outputIcons = new IIcon[CapBankType.types().size()];
        this.lockedIcons = new IIcon[CapBankType.types().size()];
        int index = 0;
        for (CapBankType type : CapBankType.types()) {
            this.blockIcons[index] = IIconRegister2.func_94245_a(type.getIcon());
            this.borderIcons[index] = IIconRegister2.func_94245_a(type.getBorderIcon());
            this.inputIcons[index] = IIconRegister2.func_94245_a(type.getInputIcon());
            this.outputIcons[index] = IIconRegister2.func_94245_a(type.getOutputIcon());
            this.lockedIcons[index] = IIconRegister2.func_94245_a(type.getLockedIcon());
            ++index;
        }
    }

    public int func_149645_b() {
        return renderId;
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        return true;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149646_a(IBlockAccess par1IBlockAccess, int par2, int par3, int par4, int par5) {
        Block i1 = par1IBlockAccess.func_147439_a(par2, par3, par4);
        return i1 == this ? false : super.func_149646_a(par1IBlockAccess, par2, par3, par4, par5);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        meta = MathHelper.func_76125_a((int)meta, (int)0, (int)(this.blockIcons.length - 1));
        return this.blockIcons[meta];
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getBorderIcon(int side, int meta) {
        meta = MathHelper.func_76125_a((int)meta, (int)0, (int)(this.blockIcons.length - 1));
        return this.borderIcons[meta];
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess ba, int x, int y, int z, int side) {
        TileEntity te = ba.func_147438_o(x, y, z);
        if (!(te instanceof TileCapBank)) {
            return this.blockIcons[0];
        }
        TileCapBank cb = (TileCapBank)te;
        ForgeDirection face = ForgeDirection.values()[side];
        int meta = ba.func_72805_g(x, y, z);
        meta = MathHelper.func_76125_a((int)meta, (int)0, (int)(CapBankType.types().size() - 1));
        IoMode mode = cb.getIoMode(face);
        if (mode == null || mode == IoMode.NONE || cb.getDisplayType(face) != InfoDisplayType.NONE) {
            return this.blockIcons[meta];
        }
        if (mode == IoMode.PULL) {
            return this.inputIcons[meta];
        }
        if (mode == IoMode.PUSH) {
            return this.outputIcons[meta];
        }
        return this.lockedIcons[meta];
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getGaugeIcon() {
        return this.gaugeIcon;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getFillBarIcon() {
        return this.fillBarIcon;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getInfoPanelIcon() {
        return this.infoPanelIcon;
    }

    public void func_149695_a(World world, int x, int y, int z, Block blockId) {
        if (world.field_72995_K) {
            return;
        }
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileCapBank) {
            TileCapBank te = (TileCapBank)tile;
            te.onNeighborBlockChange(blockId);
        }
    }

    public int func_149745_a(Random r) {
        return 0;
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase player, ItemStack stack) {
        Collection<TileCapBank> neigbours;
        super.func_149689_a(world, x, y, z, player, stack);
        TileCapBank cb = this.getTileEntity(world, x, y, z);
        if (cb == null) {
            return;
        }
        if (stack.field_77990_d != null) {
            cb.readCommonNBT(stack.field_77990_d);
        }
        if ((neigbours = NetworkUtil.getNeigbours(cb)).isEmpty()) {
            int heading = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
            ForgeDirection dir = this.getDirForHeading(heading);
            cb.setDisplayType(dir, InfoDisplayType.LEVEL_BAR);
        } else {
            boolean modifiedDisplayType = false;
            modifiedDisplayType = this.setDisplayToVerticalFillBar(cb, this.getTileEntity(world, x, y - 1, z));
            if (modifiedDisplayType |= this.setDisplayToVerticalFillBar(cb, this.getTileEntity(world, x, y + 1, z))) {
                cb.validateDisplayTypes();
            }
        }
        if (world.field_72995_K) {
            return;
        }
        world.func_147471_g(x, y, z);
    }

    protected boolean setDisplayToVerticalFillBar(TileCapBank cb, TileCapBank capBank) {
        boolean modifiedDisplayType = false;
        if (capBank != null) {
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                if (dir.offsetY != 0 || capBank.getDisplayType(dir) != InfoDisplayType.LEVEL_BAR || capBank.getType() != cb.getType()) continue;
                cb.setDisplayType(dir, InfoDisplayType.LEVEL_BAR);
                modifiedDisplayType = true;
            }
        }
        return modifiedDisplayType;
    }

    private TileCapBank getTileEntity(World world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileCapBank) {
            return (TileCapBank)te;
        }
        return null;
    }

    protected ForgeDirection getDirForHeading(int heading) {
        switch (heading) {
            case 0: {
                return ForgeDirection.values()[2];
            }
            case 1: {
                return ForgeDirection.values()[5];
            }
            case 2: {
                return ForgeDirection.values()[3];
            }
        }
        return ForgeDirection.values()[4];
    }

    @Override
    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z, boolean doHarvest) {
        TileEntity te;
        if (!world.field_72995_K && !player.field_71075_bZ.field_75098_d && (te = world.func_147438_o(x, y, z)) instanceof TileCapBank) {
            TileCapBank cb = (TileCapBank)te;
            cb.moveInventoryToNetwork();
        }
        return super.removedByPlayer(world, player, x, y, z, doHarvest);
    }

    @Override
    protected void processDrop(World world, int x, int y, int z, TileEntityEio te, ItemStack drop) {
        drop.field_77990_d = new NBTTagCompound();
        if (te != null) {
            ((TileCapBank)te).writeCommonNBT(drop.field_77990_d);
        }
    }

    @Override
    public void func_149749_a(World world, int x, int y, int z, Block par5, int par6) {
        if (!world.field_72995_K) {
            TileEntity te = world.func_147438_o(x, y, z);
            if (!(te instanceof TileCapBank)) {
                return;
            }
            TileCapBank cb = (TileCapBank)te;
            cb.onBreakBlock();
        }
        super.func_149749_a(world, x, y, z, par5, par6);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_149633_g(World world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (!(te instanceof TileCapBank)) {
            return super.func_149633_g(world, x, y, z);
        }
        TileCapBank tr = (TileCapBank)te;
        ICapBankNetwork network = tr.getNetwork();
        if (!tr.getType().isMultiblock() || network == null) {
            return super.func_149633_g(world, x, y, z);
        }
        Vector3d min = new Vector3d(Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE);
        Vector3d max = new Vector3d(-1.7976931348623157E308, -1.7976931348623157E308, -1.7976931348623157E308);
        for (TileCapBank bc : network.getMembers()) {
            min.x = Math.min(min.x, (double)bc.field_145851_c);
            max.x = Math.max(max.x, (double)(bc.field_145851_c + 1));
            min.y = Math.min(min.y, (double)bc.field_145848_d);
            max.y = Math.max(max.y, (double)(bc.field_145848_d + 1));
            min.z = Math.min(min.z, (double)bc.field_145849_e);
            max.z = Math.max(max.z, (double)(bc.field_145849_e + 1));
        }
        return AxisAlignedBB.func_72330_a((double)min.x, (double)min.y, (double)min.z, (double)max.x, (double)max.y, (double)max.z);
    }

    public boolean func_149740_M() {
        return true;
    }

    public int func_149736_g(World w, int x, int y, int z, int side) {
        TileEntity te = w.func_147438_o(x, y, z);
        if (te instanceof TileCapBank) {
            return ((TileCapBank)te).getComparatorOutput();
        }
        return 0;
    }

    @Override
    public void getWailaInfo(List<String> tooltip, EntityPlayer player, World world, int x, int y, int z) {
        TileCapBank cap;
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileCapBank && (cap = (TileCapBank)te).getNetwork() != null) {
            if (world.field_72995_K && world.func_82737_E() % 20L == 0L) {
                PacketHandler.INSTANCE.sendToServer((IMessage)new PacketNetworkStateRequest(cap));
            }
            ICapBankNetwork nw = cap.getNetwork();
            if (world.field_72995_K) {
                ((CapBankClientNetwork)nw).requestPowerUpdate(cap, 2);
            }
            String format = Util.TAB + Util.ALIGNRIGHT + EnumChatFormatting.WHITE;
            if (TooltipAddera.showAdvancedTooltips()) {
                tooltip.add(String.format("%s : %s%s%sRF/t ", Lang.localize("capbank.maxIO"), format, fmt.format(nw.getMaxIO()), Util.TAB + Util.ALIGNRIGHT));
                tooltip.add(String.format("%s : %s%s%sRF/t ", Lang.localize("capbank.maxIn"), format, fmt.format(nw.getMaxInput()), Util.TAB + Util.ALIGNRIGHT));
                tooltip.add(String.format("%s : %s%s%sRF/t ", Lang.localize("capbank.maxOut"), format, fmt.format(nw.getMaxOutput()), Util.TAB + Util.ALIGNRIGHT));
                tooltip.add("");
            }
            long stored = nw.getEnergyStoredL();
            long max = nw.getMaxEnergyStoredL();
            tooltip.add(String.format("%s%s%s / %s%s%s RF", EnumChatFormatting.WHITE, fmt.format(stored), EnumChatFormatting.RESET, EnumChatFormatting.WHITE, fmt.format(max), EnumChatFormatting.RESET));
            int change = Math.round(nw.getAverageChangePerTick());
            String color = EnumChatFormatting.WHITE.toString();
            if (change > 0) {
                color = EnumChatFormatting.GREEN.toString() + "+";
            } else if (change < 0) {
                color = EnumChatFormatting.RED.toString();
            }
            tooltip.add(String.format("%s%s%sRF/t ", color, fmt.format(change), " " + EnumChatFormatting.RESET.toString()));
        }
    }

    @Override
    public int getDefaultDisplayMask(World world, int x, int y, int z) {
        return 4;
    }

    @Override
    public boolean shouldRedstoneConduitConnect(World world, int x, int y, int z, ForgeDirection from) {
        return true;
    }
}

