/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.item.skull;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.BlockEio;
import crazypants.enderio.ModObject;
import crazypants.enderio.item.skull.ItemEndermanSkull;
import crazypants.enderio.item.skull.TileEndermanSkull;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockEndermanSkull
extends BlockEio {
    public static int renderId = -1;
    IIcon frontIcon;
    IIcon frontIconEyes;
    IIcon sideIcon;
    IIcon topIcon;

    public static BlockEndermanSkull create() {
        BlockEndermanSkull res = new BlockEndermanSkull();
        res.init();
        return res;
    }

    private BlockEndermanSkull() {
        super(ModObject.blockEndermanSkull.unlocalisedName, TileEndermanSkull.class, Material.field_151594_q);
        this.func_149676_a(0.25f, 0.0f, 0.25f, 0.75f, 0.5f, 0.75f);
    }

    @Override
    protected void init() {
        GameRegistry.registerBlock((Block)this, ItemEndermanSkull.class, (String)this.name);
        GameRegistry.registerTileEntity((Class)this.teClass, (String)(this.name + "TileEntity"));
    }

    @Override
    public void func_149651_a(IIconRegister iIconRegister) {
        this.frontIcon = iIconRegister.func_94245_a("enderio:endermanSkullFront");
        this.frontIconEyes = iIconRegister.func_94245_a("enderio:endermanSkullFrontEyes");
        this.sideIcon = iIconRegister.func_94245_a("enderio:endermanSkullSide");
        this.topIcon = iIconRegister.func_94245_a("enderio:endermanSkullTop");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        ForgeDirection orint = ForgeDirection.getOrientation((int)side);
        if (orint == ForgeDirection.NORTH) {
            meta = MathHelper.func_76125_a((int)meta, (int)0, (int)(SkullType.values().length - 1));
            return SkullType.values()[meta].showEyes ? this.frontIconEyes : this.frontIcon;
        }
        if (orint == ForgeDirection.UP || orint == ForgeDirection.DOWN || orint == ForgeDirection.SOUTH) {
            return this.topIcon;
        }
        return this.sideIcon;
    }

    public int func_149645_b() {
        return renderId;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public String func_149702_O() {
        return "enderio:endermanSkull";
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase player, ItemStack stack) {
        int inc = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 16.0f / 360.0f) + 0.5)) & 0xF;
        float facingYaw = -22.5f * (float)inc;
        TileEndermanSkull te = (TileEndermanSkull)world.func_147438_o(x, y, z);
        te.setYaw(facingYaw);
        if (world.field_72995_K) {
            return;
        }
        world.func_72921_c(x, y, z, stack.func_77960_j(), 2);
        world.func_147471_g(x, y, z);
    }

    public int func_149692_a(int meta) {
        return meta;
    }

    public static enum SkullType {
        BASE("base", false),
        REANIMATED("reanimated", true),
        TORMENTED("tormented", false),
        REANIMATED_TORMENTED("reanimatedTormented", true);

        final String name;
        final boolean showEyes;

        private SkullType(String name, boolean showEyes) {
            this.name = name;
            this.showEyes = showEyes;
        }
    }
}

