/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.item;

import cofh.api.energy.ItemEnergyContainer;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.EnderIO;
import crazypants.enderio.EnderIOTab;
import crazypants.enderio.ModObject;
import crazypants.enderio.config.Config;
import crazypants.enderio.gui.IResourceTooltipProvider;
import crazypants.enderio.item.MagnetController;
import crazypants.enderio.machine.power.PowerDisplayUtil;
import crazypants.util.ItemUtil;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class ItemMagnet
extends ItemEnergyContainer
implements IResourceTooltipProvider {
    private static final String ACTIVE_KEY = "magnetActive";

    public static void setActive(ItemStack item, boolean active) {
        if (item == null) {
            return;
        }
        NBTTagCompound nbt = ItemUtil.getOrCreateNBT(item);
        nbt.func_74757_a(ACTIVE_KEY, active);
    }

    public static boolean isActive(ItemStack item) {
        if (item == null) {
            return false;
        }
        if (item.field_77990_d == null) {
            return false;
        }
        if (!item.field_77990_d.func_74764_b(ACTIVE_KEY)) {
            return false;
        }
        return item.field_77990_d.func_74767_n(ACTIVE_KEY);
    }

    public static boolean hasPower(ItemStack itemStack) {
        return EnderIO.itemMagnet.getEnergyStored(itemStack) > 0;
    }

    public static void drainPerSecondPower(ItemStack itemStack) {
        EnderIO.itemMagnet.extractEnergy(itemStack, Config.magnetPowerUsePerSecondRF, false);
    }

    public static ItemMagnet create() {
        ItemMagnet result = new ItemMagnet();
        result.init();
        FMLCommonHandler.instance().bus().register((Object)new MagnetController());
        return result;
    }

    protected ItemMagnet() {
        super(Config.magnetPowerCapacityRF, Config.magnetPowerCapacityRF / 100);
        this.func_77637_a(EnderIOTab.tabEnderIO);
        this.func_77655_b(ModObject.itemMagnet.unlocalisedName);
        this.func_77656_e(16);
        this.func_77625_d(1);
        this.func_77627_a(true);
    }

    protected void init() {
        GameRegistry.registerItem((Item)this, (String)ModObject.itemMagnet.unlocalisedName);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister IIconRegister2) {
        this.field_77791_bV = IIconRegister2.func_94245_a("enderio:magnet");
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs par2CreativeTabs, List par3List) {
        ItemStack is = new ItemStack((Item)this);
        this.setFull(is);
        par3List.add(is);
        is = new ItemStack((Item)this);
        this.setEnergy(is, 0);
        par3List.add(is);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, EntityPlayer par2EntityPlayer, List list, boolean par4) {
        super.func_77624_a(itemStack, par2EntityPlayer, list, par4);
        String str = PowerDisplayUtil.formatPower(this.getEnergyStored(itemStack)) + "/" + PowerDisplayUtil.formatPower(this.getMaxEnergyStored(itemStack)) + " " + PowerDisplayUtil.abrevation();
        list.add(str);
    }

    public boolean hasEffect(ItemStack item, int pass) {
        return ItemMagnet.isActive(item);
    }

    public void func_77622_d(ItemStack itemStack, World world, EntityPlayer entityPlayer) {
        this.setEnergy(itemStack, 0);
    }

    @Override
    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        int res = super.receiveEnergy(container, maxReceive, simulate);
        if (res != 0 && !simulate) {
            this.updateDamage(container);
        }
        return res;
    }

    @Override
    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        int res = super.extractEnergy(container, maxExtract, simulate);
        if (res != 0 && !simulate) {
            this.updateDamage(container);
        }
        return res;
    }

    void setEnergy(ItemStack container, int energy) {
        if (container.field_77990_d == null) {
            container.field_77990_d = new NBTTagCompound();
        }
        container.field_77990_d.func_74768_a("Energy", energy);
        this.updateDamage(container);
    }

    void setFull(ItemStack container) {
        this.setEnergy(container, Config.magnetPowerCapacityRF);
    }

    private void updateDamage(ItemStack stack) {
        float r = (float)this.getEnergyStored(stack) / (float)this.getMaxEnergyStored(stack);
        int res = 16 - (int)(r * 16.0f);
        stack.func_77964_b(res);
    }

    public ItemStack func_77659_a(ItemStack equipped, World world, EntityPlayer player) {
        if (player.func_70093_af()) {
            ItemMagnet.setActive(equipped, !ItemMagnet.isActive(equipped));
        }
        return equipped;
    }

    @Override
    public String getUnlocalizedNameForTooltip(ItemStack stack) {
        return this.func_77658_a();
    }
}

