/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.EnderIOTab;
import crazypants.enderio.Log;
import crazypants.enderio.TileEntityEio;
import crazypants.enderio.api.tool.ITool;
import crazypants.enderio.machine.AbstractMachineEntity;
import crazypants.enderio.tool.ToolUtil;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class BlockEio
extends Block {
    protected final Class<? extends TileEntity> teClass;
    protected final String name;

    protected BlockEio(String name, Class<? extends TileEntity> teClass) {
        this(name, teClass, new Material(MapColor.field_151668_h));
    }

    protected BlockEio(String name, Class<? extends TileEntity> teClass, Material mat) {
        super(mat);
        this.teClass = teClass;
        this.name = name;
        this.func_149711_c(0.5f);
        this.func_149663_c(name);
        this.func_149672_a(Block.field_149777_j);
        this.setHarvestLevel("pickaxe", 0);
        this.func_149647_a(EnderIOTab.tabEnderIO);
    }

    protected void init() {
        GameRegistry.registerBlock((Block)this, (String)this.name);
        if (this.teClass != null) {
            GameRegistry.registerTileEntity(this.teClass, (String)(this.name + "TileEntity"));
        }
    }

    public boolean hasTileEntity(int metadata) {
        return this.teClass != null;
    }

    public TileEntity createTileEntity(World world, int metadata) {
        if (this.teClass != null) {
            try {
                return this.teClass.newInstance();
            }
            catch (Exception e) {
                Log.error("Could not create tile entity for block " + this.name + " for class " + this.teClass);
            }
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iIconRegister) {
        this.field_149761_L = iIconRegister.func_94245_a("enderio:" + this.name);
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        return this.doNormalDrops(world, x, y, z) ? super.getDrops(world, x, y, z, metadata, fortune) : new ArrayList();
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer entityPlayer, int side, float par7, float par8, float par9) {
        TileEntity te;
        if (this.shouldWrench(world, x, y, z, entityPlayer, side) && ToolUtil.breakBlockWithTool(this, world, x, y, z, entityPlayer)) {
            return true;
        }
        ITool tool = ToolUtil.getEquippedTool(entityPlayer);
        if (tool != null && !entityPlayer.func_70093_af() && (te = world.func_147438_o(x, y, z)) instanceof AbstractMachineEntity) {
            ((AbstractMachineEntity)te).toggleIoModeForFace(ForgeDirection.getOrientation((int)side));
            world.func_147471_g(x, y, z);
            return true;
        }
        if (entityPlayer.func_70093_af()) {
            return false;
        }
        return this.openGui(world, x, y, z, entityPlayer, side);
    }

    protected boolean shouldWrench(World world, int x, int y, int z, EntityPlayer entityPlayer, int side) {
        return true;
    }

    protected boolean openGui(World world, int x, int y, int z, EntityPlayer entityPlayer, int side) {
        return false;
    }

    public boolean doNormalDrops(World world, int x, int y, int z) {
        return true;
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z, boolean doHarvest) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileEntityEio && ((TileEntityEio)te).shouldDrop()) {
            if (!(world.field_72995_K || player.field_71075_bZ.field_75098_d || this.doNormalDrops(world, x, y, z))) {
                this.dropAsItem(world, x, y, z, (TileEntityEio)te);
                ((TileEntityEio)te).preventDrops();
            } else if (player.field_71075_bZ.field_75098_d) {
                ((TileEntityEio)te).preventDrops();
            }
        }
        return super.removedByPlayer(world, player, x, y, z, false);
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileEntityEio && ((TileEntityEio)te).shouldDrop() && !this.doNormalDrops(world, x, y, z)) {
            this.dropAsItem(world, x, y, z, (TileEntityEio)te);
            ((TileEntityEio)te).preventDrops();
        }
        super.func_149749_a(world, x, y, z, block, meta);
    }

    public void dropAsItem(World world, int x, int y, int z, TileEntityEio te) {
        int meta = this.func_149692_a(world.func_72805_g(x, y, z));
        ItemStack itemStack = new ItemStack((Block)this, 1, meta);
        this.processDrop(world, x, y, z, te, itemStack);
        this.func_149642_a(world, x, y, z, itemStack);
    }

    protected void processDrop(World world, int x, int y, int z, @Nullable TileEntityEio te, ItemStack drop) {
    }
}

