/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.common.multiblock.tileentity;

import erogenousbeef.bigreactors.common.multiblock.MultiblockTurbine;
import erogenousbeef.bigreactors.common.multiblock.interfaces.INeighborUpdatableEntity;
import erogenousbeef.bigreactors.common.multiblock.interfaces.ITickableMultiblockPart;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityTurbinePartStandard;
import erogenousbeef.core.multiblock.MultiblockControllerBase;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileEntityTurbineFluidPort
extends TileEntityTurbinePartStandard
implements IFluidHandler,
INeighborUpdatableEntity,
ITickableMultiblockPart {
    FluidFlow flowSetting = FluidFlow.In;
    IFluidHandler pumpDestination = null;
    protected static final FluidTankInfo[] emptyTankInfoArray = new FluidTankInfo[0];

    public void setFluidFlowDirection(FluidFlow newDirection, boolean markDirty) {
        this.flowSetting = newDirection;
        if (!this.field_145850_b.field_72995_K) {
            if (markDirty) {
                this.func_70296_d();
            } else {
                this.notifyNeighborsOfTileChange();
            }
        } else {
            this.notifyNeighborsOfTileChange();
        }
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public void onMachineAssembled(MultiblockControllerBase multiblockControllerBase) {
        super.onMachineAssembled(multiblockControllerBase);
        this.checkForAdjacentTank();
        this.notifyNeighborsOfTileChange();
    }

    @Override
    public void onMachineBroken() {
        super.onMachineBroken();
        this.pumpDestination = null;
    }

    @Override
    public void func_145841_b(NBTTagCompound data) {
        super.func_145841_b(data);
        data.func_74768_a("flowSetting", this.flowSetting.ordinal());
    }

    @Override
    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        if (data.func_74764_b("flowSetting")) {
            this.flowSetting = FluidFlow.values()[data.func_74762_e("flowSetting")];
        }
    }

    @Override
    public void encodeDescriptionPacket(NBTTagCompound data) {
        super.encodeDescriptionPacket(data);
        data.func_74768_a("flowSetting", this.flowSetting.ordinal());
    }

    @Override
    public void decodeDescriptionPacket(NBTTagCompound data) {
        super.decodeDescriptionPacket(data);
        if (data.func_74764_b("flowSetting")) {
            this.flowSetting = FluidFlow.values()[data.func_74762_e("flowSetting")];
        }
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (!this.isConnected() || from != this.getOutwardsDir()) {
            return 0;
        }
        if (this.flowSetting != FluidFlow.In) {
            return 0;
        }
        return this.getTurbine().fill(this.getTankIndex(), resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (resource == null || !this.isConnected() || from != this.getOutwardsDir()) {
            return resource;
        }
        return this.getTurbine().drain(this.getTankIndex(), resource, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        if (!this.isConnected() || from != this.getOutwardsDir()) {
            return null;
        }
        return this.getTurbine().drain(this.getTankIndex(), maxDrain, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        if (!this.isConnected() || from != this.getOutwardsDir()) {
            return false;
        }
        if (this.flowSetting != FluidFlow.In) {
            return false;
        }
        return this.getTurbine().canFill(this.getTankIndex(), fluid);
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        if (!this.isConnected() || from != this.getOutwardsDir()) {
            return false;
        }
        return this.getTurbine().canDrain(this.getTankIndex(), fluid);
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        if (!this.isConnected() || from != this.getOutwardsDir()) {
            return emptyTankInfoArray;
        }
        return new FluidTankInfo[]{this.getTurbine().getTankInfo(this.getTankIndex())};
    }

    private int getTankIndex() {
        if (this.flowSetting == FluidFlow.In) {
            return 0;
        }
        return 1;
    }

    public FluidFlow getFlowDirection() {
        return this.flowSetting;
    }

    @Override
    public void onMultiblockServerTick() {
        if (this.pumpDestination == null || this.flowSetting != FluidFlow.Out) {
            return;
        }
        MultiblockTurbine turbine = this.getTurbine();
        FluidStack fluidToDrain = turbine.drain(1, 4000, false);
        if (fluidToDrain != null && fluidToDrain.amount > 0) {
            fluidToDrain.amount = this.pumpDestination.fill(this.getOutwardsDir().getOpposite(), fluidToDrain, true);
            turbine.drain(1, fluidToDrain, true);
        }
    }

    @Override
    public void onNeighborBlockChange(World world, int x, int y, int z, Block neighborBlock) {
        if (!world.field_72995_K) {
            this.checkForAdjacentTank();
        }
    }

    @Override
    public void onNeighborTileChange(IBlockAccess world, int x, int y, int z, int neighborX, int neighborY, int neighborZ) {
        if (!this.field_145850_b.field_72995_K) {
            this.checkForAdjacentTank();
        }
    }

    protected void checkForAdjacentTank() {
        this.pumpDestination = null;
        if (this.field_145850_b.field_72995_K || this.flowSetting == FluidFlow.In) {
            return;
        }
        ForgeDirection outDir = this.getOutwardsDir();
        if (outDir == ForgeDirection.UNKNOWN) {
            return;
        }
        TileEntity neighbor = this.field_145850_b.func_147438_o(this.field_145851_c + outDir.offsetX, this.field_145848_d + outDir.offsetY, this.field_145849_e + outDir.offsetZ);
        if (neighbor instanceof IFluidHandler) {
            this.pumpDestination = (IFluidHandler)neighbor;
        }
    }

    public static enum FluidFlow {
        In,
        Out;

    }
}

