/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.common.multiblock.helpers;

import erogenousbeef.bigreactors.utils.StaticUtils;

public class ThermalHelper {
    private int m_Mass = 0;
    private float m_Rf = 0.0f;

    public void setRf(float newRf) {
        this.m_Rf = Math.max(0.0f, newRf);
    }

    public void setMass(int newMass) {
        this.m_Mass = Math.max(0, newMass);
    }

    public float getTemp() {
        if (this.m_Mass <= 0) {
            if (this.m_Rf < 0.0f) {
                return Float.NEGATIVE_INFINITY;
            }
            if (this.m_Rf > 0.0f) {
                return Float.POSITIVE_INFINITY;
            }
            return 0.0f;
        }
        return StaticUtils.Energy.getTemp(this.m_Mass, this.m_Rf);
    }

    public float getRf() {
        return this.m_Rf;
    }

    public int getMass() {
        return this.m_Mass;
    }

    public void merge(ThermalHelper other) {
        this.m_Rf = Math.max(this.m_Rf, other.m_Rf);
        this.m_Mass = Math.max(this.m_Mass, other.m_Mass);
    }
}

