/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.common.multiblock.helpers;

import erogenousbeef.bigreactors.api.registry.SteamRegistry;
import erogenousbeef.bigreactors.common.BRLog;
import erogenousbeef.bigreactors.common.multiblock.helpers.FluidHelper;
import erogenousbeef.bigreactors.common.multiblock.helpers.ThermalHelper;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class SteamEvapContainer
extends FluidHelper {
    public static final int STEAM = 0;
    public static final int WATER = 1;
    protected static final String[] TANK_NAMES = new String[]{"steam", "water"};
    protected int m_VaporRemainder = 0;
    protected int m_SteamMode = 0;
    protected float m_RfTransferCoefficient = 0.0f;
    protected boolean m_Dirty = false;
    protected int m_SteamProducedLastTick = 0;

    public SteamEvapContainer() {
        super(true);
    }

    public void setRfTransferCoefficient(float coeff) {
        this.m_RfTransferCoefficient = Math.max(0.0f, coeff);
    }

    @Override
    public int getNumberOfFluidTanks() {
        return TANK_NAMES.length;
    }

    @Override
    protected String[] getNBTTankNames() {
        return TANK_NAMES;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound destination) {
        super.writeToNBT(destination);
        destination.func_74768_a("remainder", this.m_VaporRemainder);
        destination.func_74768_a("mode", this.m_SteamMode);
        return destination;
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        if (data.func_74764_b("remainder")) {
            this.m_VaporRemainder = data.func_74762_e("remainder");
        }
        if (data.func_74764_b("mode")) {
            this.setMode(data.func_74762_e("mode"), false);
        }
    }

    @Override
    protected boolean isFluidValidForStack(int stackIdx, Fluid fluid) {
        if (stackIdx == 1) {
            return "water".equals(fluid.getName());
        }
        if (stackIdx == 0) {
            return fluid.getName().startsWith("steam");
        }
        return false;
    }

    public void setSteamMode(int newMode) {
        this.setMode(newMode, true);
    }

    protected void setMode(int newMode, boolean setDirty) {
        this.m_SteamMode = newMode;
        if (setDirty) {
            this.m_Dirty = true;
        }
    }

    public boolean shouldSave() {
        return this.m_Dirty;
    }

    public void onSave() {
        this.m_Dirty = false;
    }

    public void merge(SteamEvapContainer other) {
        super.merge(other);
        this.m_SteamMode = Math.max(this.m_SteamMode, other.m_SteamMode);
        this.m_VaporRemainder = Math.max(this.m_VaporRemainder, this.m_VaporRemainder);
        this.m_Dirty = true;
    }

    public int getSteamProducedLastTick() {
        return this.m_SteamProducedLastTick;
    }

    public float evaporate(ThermalHelper helper) {
        int potentialSteamUnits;
        int waterAmt = this.getFluidAmount(1);
        int spaceAvailable = this.getCapacity() - this.getFluidAmount(0);
        if ((waterAmt = Math.min(waterAmt, spaceAvailable)) <= 0 || spaceAvailable <= 0) {
            return 0.0f;
        }
        float deltaTemp = helper.getTemp() - 100.0f;
        if (deltaTemp <= 0.0f) {
            return 0.0f;
        }
        Fluid steamFluid = this.getFluidType(0);
        if (steamFluid == null) {
            steamFluid = SteamRegistry.get(this.m_SteamMode);
        }
        if ((potentialSteamUnits = Math.min(waterAmt * 1 + this.m_VaporRemainder, spaceAvailable)) <= 0) {
            return 0.0f;
        }
        float rfPerSteamUnit = SteamRegistry.getBaseRfAmountForFluid(steamFluid);
        float rfAbsorption = rfPerSteamUnit * (float)potentialSteamUnits;
        rfAbsorption = Math.min(deltaTemp * this.m_RfTransferCoefficient, rfAbsorption);
        if ((rfAbsorption = Math.min(rfAbsorption, helper.getRf())) <= 0.0f) {
            return 0.0f;
        }
        int steamUnitsToCreate = (int)(rfAbsorption / rfPerSteamUnit);
        if (steamUnitsToCreate <= 0) {
            return 0.0f;
        }
        int waterUnitsToUse = this.m_VaporRemainder >= steamUnitsToCreate ? 0 : Math.max(1, (int)Math.ceil((steamUnitsToCreate - this.m_VaporRemainder) / 1));
        if (waterUnitsToUse > waterAmt) {
            waterUnitsToUse = waterAmt;
            steamUnitsToCreate = this.m_VaporRemainder + waterUnitsToUse * 1;
        }
        this.drain(1, waterUnitsToUse, true);
        this.fill(0, new FluidStack(steamFluid, steamUnitsToCreate), true);
        rfAbsorption = (float)steamUnitsToCreate * rfPerSteamUnit;
        helper.setRf(helper.getRf() - rfAbsorption);
        this.m_VaporRemainder += waterUnitsToUse * 1;
        this.m_VaporRemainder -= steamUnitsToCreate;
        if (this.m_VaporRemainder < 0) {
            BRLog.error("m_VaporRemainder is less than zero! This is a math error! (value: %d)", this.m_VaporRemainder);
            this.m_VaporRemainder = 0;
        }
        return rfAbsorption;
    }
}

