/*
 * Decompiled with CFR 0.152.
 */
package openeye.config;

import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import openeye.config.ConfigProperty;
import openeye.config.IConfigPropertyHolder;

public class ConfigPropertyCollector {
    private static IConfigPropertyHolder createHolder(ConfigProperty annotation, Field field, Object target) {
        String name = annotation.name();
        String category = annotation.category();
        if (Strings.isNullOrEmpty((String)name)) {
            name = field.getName();
        }
        if (Strings.isNullOrEmpty((String)category)) {
            category = null;
        }
        return new InstancePropertyHolder(field, target, name, category, annotation.comment());
    }

    public static List<IConfigPropertyHolder> collectFromClass(Class<?> cls) {
        ArrayList result = Lists.newArrayList();
        for (Field f : cls.getFields()) {
            ConfigProperty property;
            if (!Modifier.isStatic(f.getModifiers()) || (property = f.getAnnotation(ConfigProperty.class)) == null) continue;
            result.add(ConfigPropertyCollector.createHolder(property, f, null));
        }
        return result;
    }

    public static List<IConfigPropertyHolder> collectFromInstance(Object target, boolean excludeStatic) {
        ArrayList result = Lists.newArrayList();
        for (Field f : target.getClass().getFields()) {
            ConfigProperty property;
            boolean isStatic = Modifier.isStatic(f.getModifiers());
            if (excludeStatic && isStatic || (property = f.getAnnotation(ConfigProperty.class)) == null) continue;
            result.add(ConfigPropertyCollector.createHolder(property, f, isStatic ? null : target));
        }
        return result;
    }

    private static class InstancePropertyHolder
    extends ConfigPropertyHolder {
        private final Field field;
        private final Object target;

        public InstancePropertyHolder(Field field, Object target, String name, String category, String comment) {
            super(name, category, comment);
            this.field = field;
            this.target = target;
        }

        @Override
        public Object getValue() {
            try {
                return this.field.get(this.target);
            }
            catch (Throwable t) {
                throw Throwables.propagate((Throwable)t);
            }
        }

        @Override
        public void setValue(Object value) {
            try {
                this.field.set(this.target, value);
            }
            catch (Throwable t) {
                throw Throwables.propagate((Throwable)t);
            }
        }

        @Override
        public Class<?> getType() {
            return this.field.getType();
        }
    }

    private static abstract class ConfigPropertyHolder
    implements IConfigPropertyHolder {
        private final String name;
        private final String category;
        private final String comment;

        public ConfigPropertyHolder(String name, String category, String comment) {
            this.name = name;
            this.category = category;
            this.comment = comment;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public String category() {
            return this.category;
        }

        @Override
        public String comment() {
            return this.comment;
        }
    }
}

