/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.wawla.modules.addons;

import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaRegistrar;
import net.darkhax.wawla.modules.Module;
import net.darkhax.wawla.util.Utilities;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.DimensionManager;

public class ModuleThaumcraft
extends Module {
    private String showJarAspects = "wawla.thaumcraft.jarAspect";
    private String showJarAmount = "wawla.thaumcraft.jarAmount";
    private String showMirrorLink = "wawla.thaumcraft.mirrorLink";
    private String showMirrorDimension = "wawla.thaumcraft.mirrorDim";
    private String showJarEXP = "wawla.thaumcraft.jarEXP";
    private String showWandItem = "wawla.thaumcraft.wandItem";
    private String showWandCharge = "wawla.thaumcraft.wandCharge";
    private String showPedestalItem = "wawla.thaumcraft.pedestalItem";
    private String showDeconstructionAspect = "wawla.thaumcraft.deconAspect";
    public Class classTileJarFillable = null;
    public Class classTileJarFillableVoid = null;
    public Class classTileMirror = null;
    public Class classTileMirrorEssentia = null;
    public Class classTileJarBrain = null;
    public Class classTileWandPedestal = null;
    public Class classTilePedestal = null;
    public Class classTileDeconstructionTable = null;
    public Class classEntityGolemBase = null;

    public ModuleThaumcraft(boolean enabled) {
        super(enabled);
        if (enabled) {
            try {
                this.classTileJarFillable = Class.forName("thaumcraft.common.tiles.TileJarFillable");
                this.classTileJarFillableVoid = Class.forName("thaumcraft.common.tiles.TileJarFillableVoid");
                this.classTileMirror = Class.forName("thaumcraft.common.tiles.TileMirror");
                this.classTileMirrorEssentia = Class.forName("thaumcraft.common.tiles.TileMirrorEssentia");
                this.classTileJarBrain = Class.forName("thaumcraft.common.tiles.TileJarBrain");
                this.classTileWandPedestal = Class.forName("thaumcraft.common.tiles.TileWandPedestal");
                this.classTilePedestal = Class.forName("thaumcraft.common.tiles.TilePedestal");
                this.classTileDeconstructionTable = Class.forName("thaumcraft.common.tiles.TileDeconstructionTable");
                this.classEntityGolemBase = Class.forName("thaumcraft.common.entities.golems.EntityGolemBase");
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void onWailaBlockDescription(ItemStack stack, List<String> tooltip, IWailaDataAccessor access, IWailaConfigHandler config) {
        if (access.getBlock() != null && access.getTileEntity() != null) {
            ItemStack pedestalStack;
            if (Utilities.compareTileEntityByClass(access.getTileEntity(), this.classTileJarFillable) || Utilities.compareTileEntityByClass(access.getTileEntity(), this.classTileJarFillableVoid)) {
                String aspect = access.getNBTData().func_74779_i("Aspect");
                short amount = access.getNBTData().func_74765_d("Amount");
                if (aspect != null && !aspect.isEmpty() && config.getConfig(this.showJarAspects)) {
                    tooltip.add(StatCollector.func_74838_a((String)"tooltip.wawla.thaumcraft.aspect") + ": " + Utilities.upperCase(aspect));
                }
                if (amount > 0 && config.getConfig(this.showJarAmount)) {
                    tooltip.add(StatCollector.func_74838_a((String)"tooltip.wawla.amount") + ": " + amount);
                }
            }
            if ((Utilities.compareTileEntityByClass(access.getTileEntity(), this.classTileMirror) || Utilities.compareTileEntityByClass(access.getTileEntity(), this.classTileMirrorEssentia)) && access.getNBTData().func_74767_n("linked")) {
                if (config.getConfig(this.showMirrorLink)) {
                    tooltip.add(StatCollector.func_74838_a((String)"tooltip.wawla.thaumcraft.linked") + ": X:" + access.getNBTData().func_74762_e("linkX") + " Y:" + access.getNBTData().func_74762_e("linkY") + " Z:" + access.getNBTData().func_74762_e("linkZ"));
                }
                if (config.getConfig(this.showMirrorDimension)) {
                    tooltip.add(StatCollector.func_74838_a((String)"tooltip.wawla.thaumcraft.dimension") + ": " + DimensionManager.getProvider((int)access.getNBTData().func_74762_e("linkDim")).func_80007_l());
                }
            }
            if (Utilities.compareTileEntityByClass(access.getTileEntity(), this.classTileJarBrain) && config.getConfig(this.showJarEXP)) {
                tooltip.add(StatCollector.func_74838_a((String)"tooltip.wawla.thaumcraft.experience") + ": " + access.getNBTData().func_74762_e("XP"));
            }
            if (Utilities.compareTileEntityByClass(access.getTileEntity(), this.classTileDeconstructionTable) && config.getConfig(this.showDeconstructionAspect)) {
                tooltip.add(StatCollector.func_74838_a((String)"tooltip.wawla.thaumcraft.aspect") + ": " + (access.getNBTData().func_74764_b("Aspect") ? Utilities.upperCase(access.getNBTData().func_74779_i("Aspect")) : "None"));
            }
            if (Utilities.compareTileEntityByClass(access.getTileEntity(), this.classTilePedestal) && config.getConfig(this.showPedestalItem) && (pedestalStack = Utilities.getInventoryStacks(access.getNBTData(), 1)[0]) != null) {
                tooltip.add(StatCollector.func_74838_a((String)"tooltip.wawla.item") + ": " + pedestalStack.func_82833_r());
            }
            if (Utilities.compareTileEntityByClass(access.getTileEntity(), this.classTileWandPedestal) && (pedestalStack = Utilities.getInventoryStacks(access.getNBTData(), 1)[0]) != null && pedestalStack.func_77942_o()) {
                if (config.getConfig(this.showWandItem)) {
                    tooltip.add(pedestalStack.func_82833_r());
                }
                if (pedestalStack.field_77990_d.func_74764_b("aqua") && config.getConfig(this.showWandCharge)) {
                    String split = EnumChatFormatting.WHITE + " | ";
                    tooltip.add(EnumChatFormatting.YELLOW + "" + (float)pedestalStack.field_77990_d.func_74762_e("aer") / 100.0f + split + EnumChatFormatting.DARK_GREEN + "" + (float)(pedestalStack.field_77990_d.func_74762_e("terra") / 100) + split + EnumChatFormatting.RED + "" + (float)pedestalStack.field_77990_d.func_74762_e("ignis") / 100.0f + split + EnumChatFormatting.DARK_AQUA + "" + (float)pedestalStack.field_77990_d.func_74762_e("aqua") / 100.0f + split + EnumChatFormatting.GRAY + "" + (float)pedestalStack.field_77990_d.func_74762_e("ordo") / 100.0f + split + EnumChatFormatting.DARK_GRAY + "" + (float)pedestalStack.field_77990_d.func_74762_e("perditio") / 100.0f);
                }
            }
        }
    }

    @Override
    public void onWailaRegistrar(IWailaRegistrar register) {
        if (this.classTileJarFillable != null) {
            register.registerSyncedNBTKey("*", this.classTileJarFillable);
        }
        if (this.classTileMirror != null) {
            register.registerSyncedNBTKey("*", this.classTileMirror);
        }
        if (this.classTileMirrorEssentia != null) {
            register.registerSyncedNBTKey("*", this.classTileMirrorEssentia);
        }
        if (this.classTileJarBrain != null) {
            register.registerSyncedNBTKey("*", this.classTileJarBrain);
        }
        if (this.classTileWandPedestal != null) {
            register.registerSyncedNBTKey("*", this.classTileWandPedestal);
        }
        if (this.classTilePedestal != null) {
            register.registerSyncedNBTKey("*", this.classTilePedestal);
        }
        if (this.classTileDeconstructionTable != null) {
            register.registerSyncedNBTKey("*", this.classTileDeconstructionTable);
        }
        register.addConfig("Thaumcraft", this.showJarAspects);
        register.addConfig("Thaumcraft", this.showJarAmount);
        register.addConfig("Thaumcraft", this.showMirrorLink);
        register.addConfig("Thaumcraft", this.showMirrorDimension);
        register.addConfig("Thaumcraft", this.showJarEXP);
        register.addConfig("Thaumcraft", this.showWandItem);
        register.addConfig("Thaumcraft", this.showWandCharge);
        register.addConfig("Thaumcraft", this.showPedestalItem);
        register.addConfig("Thaumcraft", this.showDeconstructionAspect);
    }
}

