/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.wawla.modules.addons;

import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaEntityAccessor;
import mcp.mobius.waila.api.IWailaRegistrar;
import net.darkhax.wawla.modules.Module;
import net.darkhax.wawla.util.Constants;
import net.darkhax.wawla.util.Utilities;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.StatCollector;

public class ModulePixelmon
extends Module {
    public static Class classEntityPixelmon = null;
    public static Class classTileEntityApricornTree = null;
    public static Class enumNature = null;
    public static Class enumGrowth = null;
    private String tooltipKey = "tooltip.wawla.pixelmon.";
    private String showAbility = "wawla.pixelmon.showAbility";
    private String showFriendship = "wawla.pixelmon.showFriendship";
    private String showHeldItem = "wawla.pixelmon.showHeldItem";
    private String showNature = "wawla.pixelmon.showNature";
    private String showSize = "wawla.pixelmon.showSize";
    private String showApricornGrowth = "wawla.pixelmon.showApricornGrowth";
    private String showApricornProduct = "wawla.pixelmon.showApricornProduct";
    private static String[] natureList = null;
    private static String[] sizeList = null;

    public ModulePixelmon(Boolean enabled) {
        super(enabled);
        if (enabled.booleanValue()) {
            try {
                classEntityPixelmon = Class.forName("com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon");
                classTileEntityApricornTree = Class.forName("com.pixelmonmod.pixelmon.blocks.apricornTrees.TileEntityApricornTree");
                enumNature = Class.forName("com.pixelmonmod.pixelmon.enums.EnumNature");
                enumGrowth = Class.forName("com.pixelmonmod.pixelmon.enums.EnumGrowth");
            }
            catch (ClassNotFoundException e) {
                Constants.LOG.info("The Pixelmon mod can not be detected. Module ignored.");
            }
        }
    }

    @Override
    public void onWailaBlockDescription(ItemStack stack, List<String> tooltip, IWailaDataAccessor access, IWailaConfigHandler config) {
        this.createApricornTooltip(access.getTileEntity(), tooltip, access.getBlock(), config);
        this.createApricornTooltip(access.getWorld().func_147438_o(access.getPosition().field_72311_b, access.getPosition().field_72312_c - 1, access.getPosition().field_72309_d), tooltip, access.getBlock(), config);
    }

    @Override
    public void onWailaEntityDescription(Entity entity, List<String> tooltip, IWailaEntityAccessor accessor, IWailaConfigHandler config) {
        if (Utilities.compareByClass(classEntityPixelmon, entity.getClass()) && accessor.getNBTData() != null) {
            NBTTagCompound tag = accessor.getNBTData();
            if (accessor.getPlayer().func_70093_af()) {
                if (natureList != null && config.getConfig(this.showNature)) {
                    tooltip.add(StatCollector.func_74838_a((String)(this.tooltipKey + "nature")) + ": " + natureList[tag.func_74765_d("Nature")]);
                }
                if (config.getConfig(this.showAbility)) {
                    tooltip.add(StatCollector.func_74838_a((String)(this.tooltipKey + "ability")) + ": " + tag.func_74779_i("Ability"));
                }
                if (sizeList != null && config.getConfig(this.showSize)) {
                    tooltip.add(StatCollector.func_74838_a((String)(this.tooltipKey + "size")) + ": " + sizeList[tag.func_74765_d("Growth")]);
                }
                if (config.getConfig(this.showFriendship)) {
                    tooltip.add(StatCollector.func_74838_a((String)(this.tooltipKey + "happiness")) + ": " + tag.func_74762_e("Friendship"));
                }
                if (config.getConfig(this.showHeldItem) && tag.func_74764_b("HeldItemStack")) {
                    tooltip.add(StatCollector.func_74838_a((String)(this.tooltipKey + "helditem")) + ": " + ItemStack.func_77949_a((NBTTagCompound)((NBTTagCompound)tag.func_74781_a("HeldItemStack"))).func_82833_r());
                }
            }
        }
    }

    @Override
    public void onWailaRegistrar(IWailaRegistrar register) {
        if (classEntityPixelmon != null) {
            register.registerSyncedNBTKey("*", classEntityPixelmon);
        }
        if (classTileEntityApricornTree != null) {
            register.registerSyncedNBTKey("*", classTileEntityApricornTree);
        }
        register.addConfig("Pixelmon", this.showAbility);
        register.addConfig("Pixelmon", this.showFriendship);
        register.addConfig("Pixelmon", this.showHeldItem);
        register.addConfig("Pixelmon", this.showNature);
        register.addConfig("Pixelmon", this.showSize);
        register.addConfig("Pixelmon", this.showApricornGrowth);
        register.addConfig("Pixelmon", this.showApricornProduct);
        natureList = Utilities.generateElementArray(enumNature);
        sizeList = Utilities.generateElementArray(enumGrowth);
    }

    float getGrowth(float curStage, float maxStage) {
        return curStage / maxStage * 100.0f;
    }

    void createApricornTooltip(TileEntity entity, List<String> tooltip, Block block, IWailaConfigHandler config) {
        if (entity != null && Utilities.compareByClass(classTileEntityApricornTree, entity.getClass())) {
            float meta = entity.func_145831_w().func_72805_g(entity.field_145851_c, entity.field_145848_d, entity.field_145849_e);
            String product = Block.field_149771_c.func_148750_c((Object)block);
            if (config.getConfig(this.showApricornGrowth)) {
                tooltip.add(StatCollector.func_74838_a((String)(this.tooltipKey + "growth")) + ": " + Utilities.round(this.getGrowth(meta, 5.0f), 0) + "%");
            }
            if (config.getConfig(this.showApricornProduct)) {
                tooltip.add(StatCollector.func_74838_a((String)(this.tooltipKey + "product")) + ": " + product.substring(9, product.length() - 5));
            }
        }
    }
}

