/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.wawla.modules;

import java.util.ArrayList;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaEntityAccessor;
import mcp.mobius.waila.api.IWailaRegistrar;
import net.darkhax.wawla.modules.Module;
import net.darkhax.wawla.util.Utilities;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;

public class ModulePets
extends Module {
    public static ArrayList<String> nbtNames = new ArrayList();
    private String showPetOwner = "wawla.pets.showOwner";
    private String showPetSitting = "wawla.pets.sitting";
    private String showAge = "wawla.pets.age";
    private String showBirthCooldown = "wawla.pets.cooldown";

    public ModulePets(boolean enabled) {
        super(enabled);
        nbtNames.add("Owner");
        nbtNames.add("OwnerName");
        nbtNames.add("owner");
        nbtNames.add("ownerName");
    }

    @Override
    public void onWailaEntityDescription(Entity entity, List<String> tooltip, IWailaEntityAccessor accessor, IWailaConfigHandler config) {
        if (config.getConfig(this.showPetOwner)) {
            NBTTagCompound tag = Utilities.convertEntityToNbt(entity);
            NBTTagCompound extTag = entity.getEntityData();
            for (String currentKey : nbtNames) {
                if (tag.func_74764_b(currentKey) && !tag.func_74779_i(currentKey).isEmpty()) {
                    tooltip.add(StatCollector.func_74838_a((String)"tooltip.wawla.owner") + ": " + tag.func_74779_i(currentKey));
                }
                if (!extTag.func_74764_b(currentKey) || extTag.func_74779_i(currentKey).isEmpty()) continue;
                tooltip.add(StatCollector.func_74838_a((String)"tooltip.wawla.owner") + ": " + extTag.func_74779_i(currentKey));
            }
        }
        if (entity instanceof EntityAnimal) {
            EntityAnimal animal = (EntityAnimal)entity;
            if (config.getConfig(this.showAge) && animal.func_70631_g_()) {
                tooltip.add(StatCollector.func_74838_a((String)"tooltip.wawla.age") + ": " + animal.func_70874_b() / 20 * -1 + " " + StatCollector.func_74838_a((String)"tooltip.wawla.seconds"));
            } else if (config.getConfig(this.showBirthCooldown) && !animal.func_70631_g_()) {
                tooltip.add(StatCollector.func_74838_a((String)"tooltip.wawla.birth") + ": " + animal.func_70874_b() / 20 + " " + StatCollector.func_74838_a((String)"tooltip.wawla.seconds"));
            }
        }
        if (entity instanceof EntityTameable && config.getConfig(this.showPetSitting)) {
            EntityTameable pet = (EntityTameable)entity;
            tooltip.add(StatCollector.func_74838_a((String)"tooltip.wawla.sit") + ": " + pet.func_70906_o());
        }
    }

    @Override
    public void onWailaRegistrar(IWailaRegistrar register) {
        register.addConfig("Wawla-Entity", this.showPetOwner);
        register.addConfig("Wawla-Entity", this.showPetSitting);
        register.addConfig("Wawla-Entity", this.showAge);
        register.addConfig("Wawla-Entity", this.showBirthCooldown);
    }
}

