/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.wawla.modules;

import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaRegistrar;
import net.darkhax.wawla.modules.Module;
import net.darkhax.wawla.modules.addons.ModuleTinkers;
import net.darkhax.wawla.util.Utilities;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;

public class ModuleHarvest
extends Module {
    private String showTool = "wawla.harvest.showTool";
    private String showHarvestable = "wawla.harvest.showHarvest";
    private String showTier = "wawla.harvest.showTier";

    public ModuleHarvest(boolean enabled) {
        super(enabled);
    }

    @Override
    public void onWailaBlockDescription(ItemStack stack, List<String> tooltip, IWailaDataAccessor access, IWailaConfigHandler config) {
        int itemLevel;
        MovingObjectPosition pos = access.getPosition();
        Block block = access.getBlock();
        ItemStack item = access.getPlayer().func_70694_bm();
        String tool = block != null ? block.getHarvestTool(access.getMetadata()) : "";
        int blockLevel = block.getHarvestLevel(access.getMetadata());
        int n = itemLevel = item != null ? item.func_77973_b().getHarvestLevel(item, tool) : 0;
        if (tool != null && tool.equalsIgnoreCase("chisel")) {
            if (block == Blocks.field_150348_b) {
                tool = "pickaxe";
            }
            if (block == Blocks.field_150344_f) {
                tool = "axe";
            }
        }
        if (item != null && (item.func_77973_b().getToolClasses(item).contains(tool) || ModuleTinkers.canHarvest(item, tool))) {
            if (config.getConfig(this.showHarvestable) && (blockLevel <= itemLevel || blockLevel == 0)) {
                tooltip.add(StatCollector.func_74838_a((String)"tooltip.wawla.canHarvest") + ": " + EnumChatFormatting.DARK_GREEN + StatCollector.func_74838_a((String)"tooltip.wawla.yes"));
            } else {
                if (config.getConfig(this.showHarvestable)) {
                    tooltip.add(StatCollector.func_74838_a((String)"tooltip.wawla.canHarvest") + ": " + EnumChatFormatting.RED + StatCollector.func_74838_a((String)"tooltip.wawla.no"));
                }
                if (config.getConfig(this.showTier)) {
                    tooltip.add(StatCollector.func_74838_a((String)"tooltip.wawla.blockLevel") + ": " + blockLevel);
                }
            }
            return;
        }
        if (tool != null && config.getConfig(this.showTool)) {
            tooltip.add(StatCollector.func_74838_a((String)"tooltip.wawla.toolType") + ": " + Utilities.upperCase(tool));
        }
    }

    @Override
    public void onWailaRegistrar(IWailaRegistrar register) {
        register.addConfig("Wawla-General", this.showTool);
        register.addConfig("Wawla-General", this.showHarvestable);
        register.addConfig("Wawla-General", this.showTier);
    }
}

