/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.wawla.modules;

import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaRegistrar;
import net.darkhax.wawla.modules.Module;
import net.darkhax.wawla.util.Utilities;
import net.minecraft.block.BlockFurnace;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.StatCollector;

public class ModuleFurnace
extends Module {
    public ModuleFurnace(boolean enabled) {
        super(enabled);
    }

    @Override
    public void onWailaBlockDescription(ItemStack stack, List<String> tooltip, IWailaDataAccessor access, IWailaConfigHandler config) {
        if (access.getTileEntity() != null && access.getTileEntity() instanceof TileEntityFurnace) {
            TileEntityFurnace furnace = (TileEntityFurnace)access.getTileEntity();
            int burnTime = access.getNBTData().func_74762_e("BurnTime") / 20;
            if (burnTime > 0 && config.getConfig("wawla.furnace.burntime")) {
                tooltip.add(StatCollector.func_74838_a((String)"tooltip.wawla.burnTime") + ": " + burnTime + " " + StatCollector.func_74838_a((String)"tooltip.wawla.seconds"));
            }
            if (access.getPlayer().func_70093_af()) {
                ItemStack[] furnaceStacks = Utilities.getInventoryStacks(access.getNBTData(), 3);
                if (furnaceStacks[0] != null && config.getConfig("wawla.furnace.input")) {
                    tooltip.add(StatCollector.func_74838_a((String)"tooltip.wawla.input") + ": " + furnaceStacks[0].func_82833_r() + " X " + furnaceStacks[0].field_77994_a);
                }
                if (furnaceStacks[1] != null && config.getConfig("wawla.furnace.fuel")) {
                    tooltip.add(StatCollector.func_74838_a((String)"tooltip.wawla.fuel") + ": " + furnaceStacks[1].func_82833_r() + " X " + furnaceStacks[1].field_77994_a);
                }
                if (furnaceStacks[2] != null && config.getConfig("wawla.furnace.output")) {
                    tooltip.add(StatCollector.func_74838_a((String)"tooltip.wawla.output") + ": " + furnaceStacks[2].func_82833_r() + " X " + furnaceStacks[2].field_77994_a);
                }
            }
        }
    }

    @Override
    public void onWailaRegistrar(IWailaRegistrar register) {
        register.addConfig("Wawla-Blocks", "wawla.furnace.input");
        register.addConfig("Wawla-Blocks", "wawla.furnace.fuel");
        register.addConfig("Wawla-Blocks", "wawla.furnace.output");
        register.addConfig("Wawla-Blocks", "wawla.furnace.burntime");
        register.registerSyncedNBTKey("*", BlockFurnace.class);
    }
}

