/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.tool;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.item.ElectricItem;
import ic2.api.item.IBoxable;
import ic2.api.item.IElectricItem;
import ic2.api.item.IItemHudInfo;
import ic2.core.IC2;
import ic2.core.init.InternalName;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public abstract class ItemElectricTool
extends ItemTool
implements IElectricItem,
IBoxable,
IItemHudInfo {
    public double operationEnergyCost;
    public int maxCharge;
    public int transferLimit;
    public int tier;
    private final EnumSet<ToolClass> toolClasses;

    public ItemElectricTool(InternalName internalName, int operationEnergyCost) {
        this(internalName, operationEnergyCost, HarvestLevel.Iron, EnumSet.noneOf(ToolClass.class));
    }

    public ItemElectricTool(InternalName internalName, int operationEnergyCost, HarvestLevel harvestLevel, EnumSet<ToolClass> toolClasses) {
        this(internalName, operationEnergyCost, harvestLevel, toolClasses, new HashSet<Block>());
    }

    private ItemElectricTool(InternalName internalName, int operationEnergyCost, HarvestLevel harvestLevel, EnumSet<ToolClass> toolClasses, Set<Block> mineableBlocks) {
        super(0.0f, harvestLevel.toolMaterial, mineableBlocks);
        this.operationEnergyCost = operationEnergyCost;
        this.toolClasses = toolClasses;
        this.func_77656_e(27);
        this.func_77625_d(1);
        this.func_77655_b(internalName.name());
        this.func_77637_a(IC2.tabIC2);
        for (ToolClass toolClass : toolClasses) {
            if (toolClass.name == null) continue;
            this.setHarvestLevel(toolClass.name, harvestLevel.level);
        }
        if (toolClasses.contains((Object)ToolClass.Pickaxe) && harvestLevel.toolMaterial == Item.ToolMaterial.EMERALD) {
            mineableBlocks.add(Blocks.field_150343_Z);
            mineableBlocks.add(Blocks.field_150450_ax);
            mineableBlocks.add(Blocks.field_150439_ay);
        }
        GameRegistry.registerItem((Item)this, (String)internalName.name());
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float xOffset, float yOffset, float zOffset) {
        ElectricItem.manager.use(stack, 0.0, (EntityLivingBase)player);
        return super.func_77648_a(stack, player, world, x, y, z, side, xOffset, yOffset, zOffset);
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        ElectricItem.manager.use(stack, 0.0, (EntityLivingBase)player);
        return super.func_77659_a(stack, world, player);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.field_77791_bV = iconRegister.func_94245_a(IC2.textureDomain + ":" + this.func_77658_a().substring(4));
    }

    public String func_77658_a() {
        return "ic2." + super.func_77658_a().substring(5);
    }

    public String func_77667_c(ItemStack itemStack) {
        return this.func_77658_a();
    }

    public String func_77653_i(ItemStack itemStack) {
        return StatCollector.func_74838_a((String)this.func_77667_c(itemStack));
    }

    public boolean canHarvestBlock(Block block, ItemStack stack) {
        Material material = block.func_149688_o();
        for (ToolClass toolClass : this.toolClasses) {
            if (!toolClass.whitelist.contains(block) && !toolClass.whitelist.contains(material)) continue;
            return true;
        }
        return super.canHarvestBlock(block, stack);
    }

    public float getDigSpeed(ItemStack tool, Block block, int meta) {
        if (!ElectricItem.manager.canUse(tool, this.operationEnergyCost)) {
            return 1.0f;
        }
        return super.getDigSpeed(tool, block, meta);
    }

    public float func_150893_a(ItemStack stack, Block block) {
        if (this.canHarvestBlock(block, stack)) {
            return this.field_77864_a;
        }
        return super.func_150893_a(stack, block);
    }

    public boolean func_77644_a(ItemStack itemstack, EntityLivingBase entityliving, EntityLivingBase entityliving1) {
        return true;
    }

    public int func_77619_b() {
        return 0;
    }

    public boolean isRepairable() {
        return false;
    }

    @Override
    public boolean canProvideEnergy(ItemStack itemStack) {
        return false;
    }

    @Override
    public Item getChargedItem(ItemStack itemStack) {
        return this;
    }

    @Override
    public Item getEmptyItem(ItemStack itemStack) {
        return this;
    }

    @Override
    public double getMaxCharge(ItemStack itemStack) {
        return this.maxCharge;
    }

    @Override
    public int getTier(ItemStack itemStack) {
        return this.tier;
    }

    @Override
    public double getTransferLimit(ItemStack itemStack) {
        return this.transferLimit;
    }

    public boolean func_150894_a(ItemStack par1ItemStack, World par2World, Block block, int par4, int par5, int par6, EntityLivingBase par7EntityLiving) {
        if ((double)block.func_149712_f(par2World, par4, par5, par6) != 0.0) {
            if (par7EntityLiving != null) {
                ElectricItem.manager.use(par1ItemStack, this.operationEnergyCost, par7EntityLiving);
            } else {
                ElectricItem.manager.discharge(par1ItemStack, this.operationEnergyCost, this.tier, true, false, false);
            }
        }
        return true;
    }

    public boolean func_82789_a(ItemStack par1ItemStack, ItemStack par2ItemStack) {
        return false;
    }

    @Override
    public boolean canBeStoredInToolbox(ItemStack itemstack) {
        return true;
    }

    public boolean isBookEnchantable(ItemStack itemstack1, ItemStack itemstack2) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tabs, List itemList) {
        itemList.add(this.getItemStack(Double.POSITIVE_INFINITY));
        itemList.add(this.getItemStack(0.0));
    }

    public void func_77624_a(ItemStack itemStack, EntityPlayer player, List info, boolean b) {
        info.add(StatCollector.func_74838_a((String)"ic2.item.tooltip.PowerTier") + " " + this.tier);
    }

    @Override
    public List<String> getHudInfo(ItemStack itemStack) {
        LinkedList<String> info = new LinkedList<String>();
        info.add(ElectricItem.manager.getToolTip(itemStack));
        info.add(StatCollector.func_74838_a((String)"ic2.item.tooltip.PowerTier") + " " + this.tier);
        return info;
    }

    protected ItemStack getItemStack(double charge) {
        ItemStack ret = new ItemStack((Item)this);
        ElectricItem.manager.charge(ret, charge, Integer.MAX_VALUE, true, false);
        return ret;
    }

    protected static enum ToolClass {
        Axe("axe", Material.field_151575_d, Material.field_151585_k, Material.field_151582_l),
        Pickaxe("pickaxe", Material.field_151573_f, Material.field_151574_g, Material.field_151576_e),
        Shears("shears", Blocks.field_150321_G, Blocks.field_150325_L, Blocks.field_150488_af, Blocks.field_150473_bD, Material.field_151584_j),
        Shovel("shovel", Blocks.field_150431_aC, Blocks.field_150433_aE),
        Sword("sword", Blocks.field_150321_G, Material.field_151585_k, Material.field_151582_l, Material.field_151589_v, Material.field_151584_j, Material.field_151572_C),
        Hoe(null, Blocks.field_150346_d, Blocks.field_150349_c, Blocks.field_150391_bh);

        public final String name;
        public final Set<Object> whitelist;

        private ToolClass(String name, Object ... whitelist) {
            this.name = name;
            this.whitelist = new HashSet<Object>(Arrays.asList(whitelist));
        }
    }

    protected static enum HarvestLevel {
        Wood(0, Item.ToolMaterial.WOOD),
        Stone(1, Item.ToolMaterial.STONE),
        Iron(2, Item.ToolMaterial.IRON),
        Diamond(3, Item.ToolMaterial.EMERALD),
        Iridium(4, Item.ToolMaterial.EMERALD);

        public final int level;
        public final Item.ToolMaterial toolMaterial;

        private HarvestLevel(int level, Item.ToolMaterial toolMaterial) {
            this.level = level;
            this.toolMaterial = toolMaterial;
        }
    }
}

