/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.minecraft.dragon.client.model.anim;

import info.ata4.minecraft.dragon.util.math.MathX;

public class TickFloat {
    private float min;
    private float max;
    private boolean clamp = false;
    private float current;
    private float previous;

    public TickFloat() {
        this.previous = 0.0f;
        this.current = 0.0f;
    }

    public TickFloat(float value) {
        this.current = this.previous = value;
    }

    public TickFloat setLimit(float min, float max) {
        this.clamp = true;
        this.setMin(min);
        this.setMax(max);
        this.set(this.current);
        return this;
    }

    public float get(float x) {
        return MathX.lerp(this.previous, this.current, x);
    }

    public float get() {
        return this.current;
    }

    public void sync() {
        this.previous = this.current;
    }

    public void set(float value) {
        this.sync();
        this.current = this.clamp ? MathX.clamp(value, this.min, this.max) : value;
    }

    public void add(float value) {
        this.sync();
        this.current += value;
        if (this.clamp) {
            this.current = MathX.clamp(this.current, this.min, this.max);
        }
    }

    public float getPrevious() {
        return this.previous;
    }

    public float getMin() {
        return this.min;
    }

    public void setMin(float min) {
        this.min = min;
    }

    public float getMax() {
        return this.max;
    }

    public void setMax(float max) {
        this.max = max;
    }
}

