/*
 * Decompiled with CFR 0.152.
 */
package com.choonster.chiselfacades;

import com.choonster.chiselfacades.Config;
import com.choonster.chiselfacades.Logger;
import com.cricketcraft.chisel.Features;
import com.cricketcraft.chisel.api.carving.ICarvingGroup;
import com.cricketcraft.chisel.api.carving.ICarvingVariation;
import com.cricketcraft.chisel.carving.Carving;
import com.cricketcraft.chisel.config.Configurations;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.event.FMLInterModComms;
import java.io.PrintWriter;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;

public class FacadeCreator {
    private static int _numFacades = 0;
    private static PrintWriter writer;

    private static void sendFacadeMessage(Block block, int meta) {
        ItemStack stack = new ItemStack(block, 1, meta);
        FMLInterModComms.sendMessage((String)"BuildCraft|Transport", (String)"add-facade", (ItemStack)stack);
        if (writer != null) {
            String blockName = Block.field_149771_c.func_148750_c((Object)block);
            boolean fullBoundingBox = block.func_149704_x() == 0.0 && block.func_149665_z() == 0.0 && block.func_149706_B() == 0.0 && block.func_149753_y() == 1.0 && block.func_149669_A() == 1.0 && block.func_149693_C() == 1.0;
            writer.printf("%s - %s - %b - %d - %s\n", blockName, block.toString(), fullBoundingBox, meta, stack.func_77981_g());
        }
        ++_numFacades;
    }

    private static void registerGroup(String groupName) {
        ICarvingGroup group = Carving.chisel.getGroup(groupName);
        if (group == null) {
            Logger.warn("CarvingGroup %s is null!", groupName);
            return;
        }
        for (ICarvingVariation variation : group.getVariations()) {
            Block block = variation.getBlock();
            if (!Block.field_149771_c.func_148750_c((Object)block).startsWith("chisel:")) continue;
            FacadeCreator.sendFacadeMessage(block, variation.getItemMeta());
        }
    }

    private static void registerGroupIfEnabled(Features feature, String groupName) {
        if (feature.enabled()) {
            FacadeCreator.registerGroup(groupName);
        }
    }

    public static int init() {
        if (Config.debugOutputEnabled) {
            try {
                writer = new PrintWriter("ChiselFacades" + (FMLCommonHandler.instance().getEffectiveSide().isClient() ? "Client" : "Server") + "Debug.txt", "UTF-8");
                writer.println("Name - Instance - FullBoundingBox - Meta - Subtypes");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        FacadeCreator.registerGroupIfEnabled(Features.MARBLE, "marble_slab");
        if (Features.MARBLE_PILLAR.enabled() && !Configurations.oldPillars) {
            FacadeCreator.registerGroup("marble_pillar_slab");
            Logger.info("Old pillars disabled, adding Pillar slab Facades", new Object[0]);
        }
        FacadeCreator.registerGroupIfEnabled(Features.ROAD_LINE, "road_line");
        if (writer != null) {
            writer.close();
        }
        return _numFacades;
    }
}

