/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.modularpots.world.gen.feature;

import com.jaquadro.minecraft.modularpots.block.BlockLargePot;
import com.jaquadro.minecraft.modularpots.block.support.WoodRegistry;
import com.jaquadro.minecraft.modularpots.core.ModBlocks;
import com.jaquadro.minecraft.modularpots.tileentity.TileEntityWoodProxy;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;

public abstract class WorldGenOrnamentalTree
extends WorldGenAbstractTree {
    private final Block wood;
    private final Block leaves;
    private final int metaWood;
    private final int metaLeaves;
    protected static final String PAT_1X1 = "T";
    protected static final String PAT_3X3 = "XXXXTXXXX";
    protected static final String PAT_3X3PLUS = " X XTX X ";
    protected static final String PAT_3X3IPLUS = "X X T X X";
    protected static final String PAT_3X3UNBAL = "0X XTX X ";
    protected static final String PAT_5X5 = "XXXXXXXXXXXXTXXXXXXXXXXXX";
    protected static final String PAT_5X5PLUS = "  X   XXX XXTXX XXX   X  ";
    protected static final String PAT_5X5PLUS2 = " XXX XXXXXXXTXXXXXXX XXX ";
    protected static final String PAT_5X5PLUS2N = " X X XXXXX XTX XXXXX X X ";
    protected static final String PAT_5X5PLUS2T = " XXX XXTXXXTTTXXXTXX XXX ";
    protected static final String PAT_5X5UNBAL = " 00  0XXX 0XTX  XXX      ";

    protected static String transform(String pattern, LayerType type) {
        return WorldGenOrnamentalTree.transform(pattern, type, 0);
    }

    protected static String transform(String pattern, LayerType type, int option) {
        boolean flipV;
        int groups = WorldGenOrnamentalTree.countOptionGroups(pattern);
        for (int i = 0; i < groups; ++i) {
            pattern = (option >> i & 1) == 0 ? pattern.replace((char)(48 + i), ' ') : pattern.replace((char)(48 + i), 'X');
        }
        if (type == LayerType.LEAF) {
            pattern = pattern.replace('T', 'X');
        } else if (type == LayerType.TRUNK) {
            pattern = pattern.replace('X', 'T');
        }
        boolean flipH = (option >>> 30 & 1) == 1;
        boolean bl = flipV = (option >>> 31 & 1) == 1;
        if (flipH && flipV) {
            pattern = new StringBuilder(pattern).reverse().toString();
        } else if (flipH) {
            int dim = WorldGenOrnamentalTree.getPatternDim(pattern);
            StringBuilder sb = new StringBuilder(pattern);
            for (int y = 0; y < dim; ++y) {
                int base = y * dim;
                for (int x = 0; x < dim; ++x) {
                    sb.setCharAt(base + x, pattern.charAt(base + dim - x - 1));
                }
            }
            pattern = sb.toString();
        } else if (flipV) {
            int dim = WorldGenOrnamentalTree.getPatternDim(pattern);
            StringBuilder sb = new StringBuilder(pattern);
            for (int y = 0; y < dim; ++y) {
                int base = y * dim;
                int base2 = (dim - y - 1) * dim;
                for (int x = 0; x < dim; ++x) {
                    sb.setCharAt(base + x, pattern.charAt(base2 + x));
                }
            }
            pattern = sb.toString();
        }
        return pattern;
    }

    private static int countOptionGroups(String pattern) {
        char high = '/';
        int n = pattern.length();
        for (int i = 0; i < n; ++i) {
            char c = pattern.charAt(i);
            if (c < '0' || c > '9' || c <= high) continue;
            high = c;
        }
        return high - 48 + 1;
    }

    public WorldGenOrnamentalTree(boolean blockNotify, Block wood, int metaWood, Block leaves, int metaLeaves) {
        super(blockNotify);
        this.wood = wood;
        this.leaves = leaves;
        this.metaWood = metaWood;
        this.metaLeaves = metaLeaves;
    }

    public boolean func_76484_a(World world, Random rand, int x, int y, int z) {
        boolean potted = world.func_147439_a(x, y - 1, z) instanceof BlockLargePot;
        int height = potted ? 5 : 6;
        int trunkHeight = height - 4;
        this.prepare(world, rand, x, y, z, trunkHeight);
        if (!this.canGenerate(world, x, y, z, height)) {
            return false;
        }
        this.generateCanopy(world, x, y, z, trunkHeight);
        this.generateTrunk(world, x, y, z, trunkHeight);
        return true;
    }

    private boolean canGenerate(World world, int x, int y, int z, int height) {
        int trunkHeight = height - 4;
        if (y + height > 256) {
            return false;
        }
        return this.canGenerateTrunk(world, x, y, z, trunkHeight) && this.canGenerateCanopy(world, x, y, z, trunkHeight);
    }

    protected void prepare(World world, Random rand, int x, int y, int z, int trunkHeight) {
    }

    protected boolean canGenerateTrunk(World world, int x, int y, int z, int trunkHeight) {
        for (int iy = y; iy < y + trunkHeight; ++iy) {
            if (this.isReplaceable(world, x, iy, z)) continue;
            return false;
        }
        return true;
    }

    protected abstract boolean canGenerateCanopy(World var1, int var2, int var3, int var4, int var5);

    protected void generateTrunk(World world, int x, int y, int z, int trunkHeight) {
        for (int iy = y; iy < y + trunkHeight + 1; ++iy) {
            this.generateBlock(world, x, iy, z, this.wood, this.metaWood);
        }
    }

    protected abstract void generateCanopy(World var1, int var2, int var3, int var4, int var5);

    private static int getPatternDim(String pattern) {
        return (int)Math.floor(Math.sqrt(pattern.length()));
    }

    protected boolean canGeneratePattern(World world, int x, int y, int z, String pattern) {
        int dim = WorldGenOrnamentalTree.getPatternDim(pattern) / 2;
        for (int ix = x - dim; ix <= x + dim; ++ix) {
            for (int iz = z - dim; iz <= z + dim; ++iz) {
                int index = (iz - z + dim) * (dim * 2 + 1) + (ix - x + dim);
                if (pattern.charAt(index) != 'X' && pattern.charAt(index) != 'T' || this.isReplaceable(world, ix, y, iz)) continue;
                return false;
            }
        }
        return true;
    }

    protected void generatePattern(World world, int x, int y, int z, String pattern) {
        int dim = WorldGenOrnamentalTree.getPatternDim(pattern) / 2;
        for (int ix = x - dim; ix <= x + dim; ++ix) {
            for (int iz = z - dim; iz <= z + dim; ++iz) {
                int index = (iz - z + dim) * (dim * 2 + 1) + (ix - x + dim);
                if (pattern.charAt(index) == 'X') {
                    this.generateBlock(world, ix, y, iz);
                    continue;
                }
                if (pattern.charAt(index) != 'T') continue;
                this.generateTrunk(world, ix, y, iz);
            }
        }
    }

    private void generateBlock(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        if (block.isAir((IBlockAccess)world, x, y, z) || block.isLeaves((IBlockAccess)world, x, y, z)) {
            this.func_150516_a(world, x, y, z, this.leaves, this.metaLeaves);
        }
    }

    private void generateTrunk(World world, int x, int y, int z) {
        this.generateBlock(world, x, y, z, this.wood, this.metaWood);
    }

    private void generateBlock(World world, int x, int y, int z, Block block, int meta) {
        Block existingBlock = world.func_147439_a(x, y, z);
        if (existingBlock.isAir((IBlockAccess)world, x, y, z) || existingBlock.isLeaves((IBlockAccess)world, x, y, z)) {
            if (WoodRegistry.contains(block, meta)) {
                this.func_150516_a(world, x, y, z, block, 0);
                TileEntityWoodProxy te = new TileEntityWoodProxy();
                te.setProtoBlock(block, meta);
                this.func_150516_a(world, x, y, z, (Block)ModBlocks.thinLog, 0);
                world.func_147455_a(x, y, z, (TileEntity)te);
            } else if (block == Blocks.field_150364_r) {
                this.func_150516_a(world, x, y, z, (Block)ModBlocks.thinLog, meta % 4);
            } else if (block == Blocks.field_150363_s) {
                this.func_150516_a(world, x, y, z, (Block)ModBlocks.thinLog, meta % 4 + 4);
            } else {
                this.func_150516_a(world, x, y, z, block, meta);
            }
        }
    }

    protected boolean isReplaceable(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        return super.isReplaceable(world, x, y, z);
    }

    protected static enum LayerType {
        LEAF,
        TRUNK,
        CORE;

    }
}

