/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.modularpots.world.gen.feature;

import com.jaquadro.minecraft.modularpots.world.gen.feature.OrnamentalTreeFactory;
import com.jaquadro.minecraft.modularpots.world.gen.feature.WorldGenStandardOrnTree;
import java.util.HashMap;
import java.util.Map;

public class OrnamentalTreeRegistry {
    private static Map<String, OrnamentalTreeFactory> registry = new HashMap<String, OrnamentalTreeFactory>();

    public static void registerTree(String name, OrnamentalTreeFactory treeFactory) {
        registry.put(name, treeFactory);
    }

    public static OrnamentalTreeFactory getTree(String name) {
        return registry.get(name);
    }

    static {
        OrnamentalTreeRegistry.registerTree("small_oak", WorldGenStandardOrnTree.SmallOakTree.FACTORY);
        OrnamentalTreeRegistry.registerTree("small_spruce", WorldGenStandardOrnTree.SmallSpruceTree.FACTORY);
        OrnamentalTreeRegistry.registerTree("small_jungle", WorldGenStandardOrnTree.SmallJungleTree.FACTORY);
        OrnamentalTreeRegistry.registerTree("small_acacia", WorldGenStandardOrnTree.SmallAcaciaTree.FACTORY);
        OrnamentalTreeRegistry.registerTree("small_palm", WorldGenStandardOrnTree.SmallPalmTree.FACTORY);
        OrnamentalTreeRegistry.registerTree("small_willow", WorldGenStandardOrnTree.SmallWillowTree.FACTORY);
        OrnamentalTreeRegistry.registerTree("small_pine", WorldGenStandardOrnTree.SmallPineTree.FACTORY);
        OrnamentalTreeRegistry.registerTree("small_mahogany", WorldGenStandardOrnTree.SmallMahoganyTree.FACTORY);
        OrnamentalTreeRegistry.registerTree("large_oak", WorldGenStandardOrnTree.LargeOakTree.FACTORY);
    }
}

