/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.modularpots.tileentity;

import com.jaquadro.minecraft.modularpots.block.BlockLargePotPlantProxy;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;

public class TileEntityLargePot
extends TileEntity {
    private static final int DEFAULT_BIOME_DATA = 65407;
    private Item flowerPotItem;
    private int flowerPotData;
    private Item substrate;
    private int substrateData;
    private int substrateOrigData;
    private int carving;
    private boolean hasBiomeOverride;
    private int biomeData = 65407;

    public TileEntityLargePot() {
    }

    public TileEntityLargePot(Item item, int itemData) {
        this.flowerPotItem = item;
        this.flowerPotData = itemData;
    }

    public Item getFlowerPotItem() {
        return this.flowerPotItem;
    }

    public int getFlowerPotData() {
        return this.flowerPotData;
    }

    public Item getSubstrate() {
        return this.substrate;
    }

    public int getSubstrateData() {
        return this.substrateData;
    }

    public int getSubstrateOriginalData() {
        return this.substrateOrigData;
    }

    public int getCarving() {
        return this.carving;
    }

    public boolean hasBiomeDataOverride() {
        return this.hasBiomeOverride;
    }

    public int getBiomeData() {
        return this.biomeData;
    }

    public float getBiomeTemperature() {
        return (float)(this.biomeData & 0xFF) / 255.0f;
    }

    public float getBiomeHumidity() {
        return (float)(this.biomeData >> 8 & 0xFF) / 255.0f;
    }

    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        if (this.flowerPotItem != null) {
            tag.func_74778_a("Item", Item.field_150901_e.func_148750_c((Object)this.flowerPotItem));
        }
        if (this.flowerPotData != 0) {
            tag.func_74777_a("ItemD", (short)this.flowerPotData);
        }
        if (this.substrate != null) {
            tag.func_74778_a("Subs", Item.field_150901_e.func_148750_c((Object)this.substrate));
        }
        if (this.substrateData != 0) {
            tag.func_74777_a("SubsD", (short)this.substrateData);
        }
        if (this.substrateOrigData != 0) {
            tag.func_74777_a("SubsO", (short)this.substrateOrigData);
        }
        if (this.hasBiomeOverride || this.biomeData != 65407) {
            tag.func_74768_a("Biom", this.biomeData);
        }
        if (this.carving != 0) {
            tag.func_74777_a("Carv", (short)this.carving);
        }
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.flowerPotItem = null;
        this.flowerPotData = 0;
        this.substrate = null;
        this.substrateData = 0;
        if (tag.func_74764_b("Item")) {
            String itemString = tag.func_74779_i("Item");
            this.flowerPotItem = itemString == null || itemString.equals("") ? null : (Item)Item.field_150901_e.func_82594_a(itemString);
            int n = this.flowerPotData = tag.func_74764_b("ItemD") ? (int)tag.func_74765_d("ItemD") : 0;
        }
        if (tag.func_74764_b("Subs")) {
            String substrateString = tag.func_74779_i("Subs");
            this.substrate = substrateString == null || substrateString.equals("") ? null : (Item)Item.field_150901_e.func_82594_a(substrateString);
            this.substrateData = tag.func_74764_b("SubsD") ? (int)tag.func_74765_d("SubsD") : 0;
            this.substrateOrigData = tag.func_74764_b("SubsO") ? (int)tag.func_74765_d("SubsO") : 0;
        }
        this.hasBiomeOverride = tag.func_74764_b("Biom");
        this.biomeData = tag.func_74764_b("Biom") ? tag.func_74762_e("Biom") : 65407;
        this.carving = tag.func_74764_b("Carv") ? (int)tag.func_74765_d("Carv") : 0;
    }

    public Packet func_145844_m() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_145841_b(tag);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 5, tag);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
        this.func_145831_w().func_147479_m(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        int y = this.field_145848_d;
        while (this.func_145831_w().func_147439_a(this.field_145851_c, ++y, this.field_145849_e) instanceof BlockLargePotPlantProxy) {
            this.func_145831_w().func_147479_m(this.field_145851_c, y, this.field_145849_e);
        }
    }

    public void setItem(Item item, int itemData) {
        this.flowerPotItem = item;
        this.flowerPotData = itemData;
    }

    public void setSubstrate(Item item, int itemData) {
        this.substrate = item;
        this.substrateData = itemData;
    }

    public void setSubstrate(Item item, int itemData, int origData) {
        this.substrate = item;
        this.substrateData = itemData;
        this.substrateOrigData = origData;
    }

    public void setBiomeData(int data) {
        this.biomeData = data;
        this.hasBiomeOverride = true;
    }

    public void setCarving(int id) {
        this.carving = id;
    }
}

