/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.modularpots.registry;

import com.jaquadro.minecraft.modularpots.block.support.UniqueMetaIdentifier;
import com.jaquadro.minecraft.modularpots.core.ModItems;
import com.jaquadro.minecraft.modularpots.registry.RegistryGroup;
import cpw.mods.fml.common.FMLLog;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import org.apache.logging.log4j.Level;

public class PlantRegistry {
    private static PlantRegistry instance;
    private List<UniqueMetaIdentifier> blacklist;
    private List<UniqueMetaIdentifier> bonemealBlacklist;

    public static PlantRegistry instance() {
        if (instance == null) {
            new PlantRegistry();
        }
        return instance;
    }

    protected PlantRegistry() {
        instance = this;
        this.blacklist = new ArrayList<UniqueMetaIdentifier>();
        this.bonemealBlacklist = new ArrayList<UniqueMetaIdentifier>();
    }

    public boolean isBlacklisted(UniqueMetaIdentifier id) {
        return this.blacklist.contains(id);
    }

    public boolean isBlacklisted(UniqueMetaIdentifier id, RegistryGroup group) {
        switch (group) {
            case Plant: {
                return this.blacklist.contains(id) || this.blacklist.contains(new UniqueMetaIdentifier(id.modId, id.name, Short.MAX_VALUE));
            }
            case Bonemeal: {
                return this.bonemealBlacklist.contains(id) || this.bonemealBlacklist.contains(new UniqueMetaIdentifier(id.modId, id.name, Short.MAX_VALUE));
            }
        }
        return false;
    }

    public boolean isBlacklisted(ItemStack itemStack) {
        return this.isBlacklisted(ModItems.getUniqueMetaID(itemStack));
    }

    public void addToBlacklist(ItemStack itemStack) {
        UniqueMetaIdentifier id = ModItems.getUniqueMetaID(itemStack);
        if (id != null && !this.blacklist.contains(id)) {
            this.blacklist.add(id);
            FMLLog.log((String)"modularpots", (Level)Level.INFO, (String)("Blacklisting plant " + id.toString()), (Object[])new Object[0]);
        }
    }

    public void addToBlacklist(ItemStack itemStack, RegistryGroup group) {
        List<UniqueMetaIdentifier> list = null;
        switch (group) {
            case Plant: {
                list = this.blacklist;
                break;
            }
            case Bonemeal: {
                list = this.bonemealBlacklist;
            }
        }
        UniqueMetaIdentifier id = ModItems.getUniqueMetaID(itemStack);
        if (id != null && list != null && !list.contains(id)) {
            list.add(id);
            FMLLog.log((String)"modularpots", (Level)Level.INFO, (String)("Blacklisting plant " + id.toString() + " (" + group.toString() + ")"), (Object[])new Object[0]);
        }
    }

    public void addToBlacklist(NBTTagCompound tagData) {
        if (tagData.func_150297_b("items", 9)) {
            NBTTagList list = tagData.func_150295_c("items", 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                this.addToBlacklist(list.func_150305_b(i));
            }
            return;
        }
        try {
            ItemStack item = ItemStack.func_77949_a((NBTTagCompound)tagData);
            if (item != null) {
                this.addToBlacklist(item);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addToBlacklist(NBTTagCompound tagData, RegistryGroup group) {
        if (tagData.func_150297_b("items", 9)) {
            NBTTagList list = tagData.func_150295_c("items", 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                this.addToBlacklist(list.func_150305_b(i), group);
            }
            return;
        }
        try {
            ItemStack item = ItemStack.func_77949_a((NBTTagCompound)tagData);
            if (item != null) {
                this.addToBlacklist(item, group);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

